/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.fileupload;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.myfaces.custom.fileupload.StorageStrategy;
import org.apache.myfaces.custom.fileupload.UploadedFileDefaultImplBase;

public class UploadedFileDefaultMemoryImpl
extends UploadedFileDefaultImplBase {
    private static final long serialVersionUID = -6006333070975059090L;
    private byte[] bytes;
    private StorageStrategy storageStrategy;

    public UploadedFileDefaultMemoryImpl(final FileItem fileItem) throws IOException {
        super(fileItem.getName(), fileItem.getContentType());
        int sizeInBytes = (int)fileItem.getSize();
        this.bytes = new byte[sizeInBytes];
        fileItem.getInputStream().read(this.bytes);
        this.storageStrategy = new StorageStrategy(){

            public void deleteFileContents() {
                fileItem.delete();
                UploadedFileDefaultMemoryImpl.access$002(UploadedFileDefaultMemoryImpl.this, null);
            }
        };
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.bytes);
    }

    public long getSize() {
        if (this.bytes == null) {
            return 0L;
        }
        return this.bytes.length;
    }

    public StorageStrategy getStorageStrategy() {
        return this.storageStrategy;
    }

    static /* synthetic */ byte[] access$002(UploadedFileDefaultMemoryImpl x0, byte[] x1) {
        x0.bytes = x1;
        return x1;
    }
}

