/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webservice.util;

import java.io.InputStream;
import java.util.Properties;
import javax.xml.rpc.ServiceException;
import org.alfresco.webservice.accesscontrol.AccessControlServiceLocator;
import org.alfresco.webservice.accesscontrol.AccessControlServiceSoapBindingStub;
import org.alfresco.webservice.action.ActionServiceLocator;
import org.alfresco.webservice.action.ActionServiceSoapBindingStub;
import org.alfresco.webservice.administration.AdministrationServiceLocator;
import org.alfresco.webservice.administration.AdministrationServiceSoapBindingStub;
import org.alfresco.webservice.authentication.AuthenticationServiceLocator;
import org.alfresco.webservice.authentication.AuthenticationServiceSoapBindingStub;
import org.alfresco.webservice.authoring.AuthoringServiceLocator;
import org.alfresco.webservice.authoring.AuthoringServiceSoapBindingStub;
import org.alfresco.webservice.classification.ClassificationServiceLocator;
import org.alfresco.webservice.classification.ClassificationServiceSoapBindingStub;
import org.alfresco.webservice.content.ContentServiceLocator;
import org.alfresco.webservice.content.ContentServiceSoapBindingStub;
import org.alfresco.webservice.dictionary.DictionaryServiceLocator;
import org.alfresco.webservice.dictionary.DictionaryServiceSoapBindingStub;
import org.alfresco.webservice.repository.RepositoryServiceLocator;
import org.alfresco.webservice.repository.RepositoryServiceSoapBindingStub;
import org.alfresco.webservice.util.AuthenticationUtils;
import org.alfresco.webservice.util.WebServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class WebServiceFactory {
    private static Log logger = LogFactory.getLog(WebServiceFactory.class);
    private static final String PROPERTY_FILE_NAME = "alfresco/webserviceclient.properties";
    private static final String REPO_LOCATION = "repository.location";
    private static final String DEFAULT_ENDPOINT_ADDRESS = "http://localhost:8080/alfresco/api";
    private static final String AUTHENTICATION_SERVICE_ADDRESS = "/AuthenticationService";
    private static final String REPOSITORY_SERVICE_ADDRESS = "/RepositoryService";
    private static final String CONTENT_SERVICE_ADDRESS = "/ContentService";
    private static final String AUTHORING_SERVICE_ADDRESS = "/AuthoringService";
    private static final String CLASSIFICATION_SERVICE_ADDRESS = "/ClassificationService";
    private static final String ACTION_SERVICE_ADDRESS = "/ActionService";
    private static final String ACCESS_CONTROL_ADDRESS = "/AccessControlService";
    private static final String ADMINISTRATION_ADDRESS = "/AdministrationService";
    private static final String DICTIONARY_SERVICE_ADDRESS = "/DictionaryService";
    private static AuthenticationServiceSoapBindingStub authenticationService = null;
    private static RepositoryServiceSoapBindingStub repositoryService = null;
    private static ContentServiceSoapBindingStub contentService = null;
    private static AuthoringServiceSoapBindingStub authoringService = null;
    private static ClassificationServiceSoapBindingStub classificationService = null;
    private static ActionServiceSoapBindingStub actionService = null;
    private static AccessControlServiceSoapBindingStub accessControlService = null;
    private static AdministrationServiceSoapBindingStub administrationService = null;
    private static DictionaryServiceSoapBindingStub dictionaryService = null;

    public static AuthenticationServiceSoapBindingStub getAuthenticationService() {
        if (authenticationService == null) {
            try {
                AuthenticationServiceLocator locator = new AuthenticationServiceLocator();
                locator.setAuthenticationServiceEndpointAddress(WebServiceFactory.getEndpointAddress() + AUTHENTICATION_SERVICE_ADDRESS);
                authenticationService = (AuthenticationServiceSoapBindingStub)locator.getAuthenticationService();
            }
            catch (ServiceException jre) {
                if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                    jre.getLinkedCause().printStackTrace();
                }
                throw new WebServiceException("Error creating authentication service: " + jre.getMessage(), jre);
            }
            authenticationService.setTimeout(60000);
        }
        return authenticationService;
    }

    public static RepositoryServiceSoapBindingStub getRepositoryService() {
        if (repositoryService == null) {
            try {
                RepositoryServiceLocator locator = new RepositoryServiceLocator(AuthenticationUtils.getEngineConfiguration());
                locator.setRepositoryServiceEndpointAddress(WebServiceFactory.getEndpointAddress() + REPOSITORY_SERVICE_ADDRESS);
                repositoryService = (RepositoryServiceSoapBindingStub)locator.getRepositoryService();
            }
            catch (ServiceException jre) {
                if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                    jre.getLinkedCause().printStackTrace();
                }
                throw new WebServiceException("Error creating repositoryService service: " + jre.getMessage(), jre);
            }
            repositoryService.setTimeout(60000);
        }
        return repositoryService;
    }

    public static AuthoringServiceSoapBindingStub getAuthoringService() {
        if (authoringService == null) {
            try {
                AuthoringServiceLocator locator = new AuthoringServiceLocator(AuthenticationUtils.getEngineConfiguration());
                locator.setAuthoringServiceEndpointAddress(WebServiceFactory.getEndpointAddress() + AUTHORING_SERVICE_ADDRESS);
                authoringService = (AuthoringServiceSoapBindingStub)locator.getAuthoringService();
            }
            catch (ServiceException jre) {
                if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                    jre.getLinkedCause().printStackTrace();
                }
                throw new WebServiceException("Error creating authoring service: " + jre.getMessage(), jre);
            }
            authoringService.setTimeout(60000);
        }
        return authoringService;
    }

    public static ClassificationServiceSoapBindingStub getClassificationService() {
        if (classificationService == null) {
            try {
                ClassificationServiceLocator locator = new ClassificationServiceLocator(AuthenticationUtils.getEngineConfiguration());
                locator.setClassificationServiceEndpointAddress(WebServiceFactory.getEndpointAddress() + CLASSIFICATION_SERVICE_ADDRESS);
                classificationService = (ClassificationServiceSoapBindingStub)locator.getClassificationService();
            }
            catch (ServiceException jre) {
                if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                    jre.getLinkedCause().printStackTrace();
                }
                throw new WebServiceException("Error creating classification service: " + jre.getMessage(), jre);
            }
            classificationService.setTimeout(60000);
        }
        return classificationService;
    }

    public static ActionServiceSoapBindingStub getActionService() {
        if (actionService == null) {
            try {
                ActionServiceLocator locator = new ActionServiceLocator(AuthenticationUtils.getEngineConfiguration());
                locator.setActionServiceEndpointAddress(WebServiceFactory.getEndpointAddress() + ACTION_SERVICE_ADDRESS);
                actionService = (ActionServiceSoapBindingStub)locator.getActionService();
            }
            catch (ServiceException jre) {
                if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                    jre.getLinkedCause().printStackTrace();
                }
                throw new WebServiceException("Error creating action service: " + jre.getMessage(), jre);
            }
            actionService.setTimeout(60000);
        }
        return actionService;
    }

    public static ContentServiceSoapBindingStub getContentService() {
        if (contentService == null) {
            try {
                ContentServiceLocator locator = new ContentServiceLocator(AuthenticationUtils.getEngineConfiguration());
                locator.setContentServiceEndpointAddress(WebServiceFactory.getEndpointAddress() + CONTENT_SERVICE_ADDRESS);
                contentService = (ContentServiceSoapBindingStub)locator.getContentService();
            }
            catch (ServiceException jre) {
                if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                    jre.getLinkedCause().printStackTrace();
                }
                throw new WebServiceException("Error creating content service: " + jre.getMessage(), jre);
            }
            contentService.setTimeout(60000);
        }
        return contentService;
    }

    public static AccessControlServiceSoapBindingStub getAccessControlService() {
        if (accessControlService == null) {
            try {
                AccessControlServiceLocator locator = new AccessControlServiceLocator(AuthenticationUtils.getEngineConfiguration());
                locator.setAccessControlServiceEndpointAddress(WebServiceFactory.getEndpointAddress() + ACCESS_CONTROL_ADDRESS);
                accessControlService = (AccessControlServiceSoapBindingStub)locator.getAccessControlService();
            }
            catch (ServiceException jre) {
                if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                    jre.getLinkedCause().printStackTrace();
                }
                throw new WebServiceException("Error creating access control service: " + jre.getMessage(), jre);
            }
            accessControlService.setTimeout(60000);
        }
        return accessControlService;
    }

    public static AdministrationServiceSoapBindingStub getAdministrationService() {
        if (administrationService == null) {
            try {
                AdministrationServiceLocator locator = new AdministrationServiceLocator(AuthenticationUtils.getEngineConfiguration());
                locator.setAdministrationServiceEndpointAddress(WebServiceFactory.getEndpointAddress() + ADMINISTRATION_ADDRESS);
                administrationService = (AdministrationServiceSoapBindingStub)locator.getAdministrationService();
            }
            catch (ServiceException jre) {
                if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                    jre.getLinkedCause().printStackTrace();
                }
                throw new WebServiceException("Error creating administration service: " + jre.getMessage(), jre);
            }
            administrationService.setTimeout(60000);
        }
        return administrationService;
    }

    public static DictionaryServiceSoapBindingStub getDictionaryService() {
        if (dictionaryService == null) {
            try {
                DictionaryServiceLocator locator = new DictionaryServiceLocator(AuthenticationUtils.getEngineConfiguration());
                locator.setDictionaryServiceEndpointAddress(WebServiceFactory.getEndpointAddress() + DICTIONARY_SERVICE_ADDRESS);
                dictionaryService = (DictionaryServiceSoapBindingStub)locator.getDictionaryService();
            }
            catch (ServiceException jre) {
                if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                    jre.getLinkedCause().printStackTrace();
                }
                throw new WebServiceException("Error creating dictionary service: " + jre.getMessage(), jre);
            }
            dictionaryService.setTimeout(60000);
        }
        return dictionaryService;
    }

    private static String getEndpointAddress() {
        String endPoint;
        block4: {
            endPoint = DEFAULT_ENDPOINT_ADDRESS;
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(PROPERTY_FILE_NAME);
            if (is != null) {
                Properties props = new Properties();
                try {
                    props.load(is);
                    endPoint = props.getProperty(REPO_LOCATION);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Using endpoint " + endPoint));
                    }
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)"Unable to file web service client proerties file.  Using default.");
                }
            }
        }
        return endPoint;
    }
}

