/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webservice.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.alfresco.webservice.content.Content;
import org.alfresco.webservice.util.AuthenticationUtils;
import org.alfresco.webservice.util.WebServiceException;
import org.springframework.util.FileCopyUtils;

public class ContentUtils {
    public static final int BUFFER_SIZE = 4096;

    public static byte[] convertToByteArray(InputStream inputStream) throws Exception {
        byte[] result = null;
        if (inputStream.available() > 0) {
            result = new byte[inputStream.available()];
            inputStream.read(result);
        }
        return result;
    }

    public static String getContentAsString(Content content) {
        String ticket = AuthenticationUtils.getCurrentTicket();
        String strUrl = content.getUrl() + "?ticket=" + ticket;
        StringBuilder readContent = new StringBuilder();
        try {
            URL url = new URL(strUrl);
            URLConnection conn = url.openConnection();
            InputStream is = conn.getInputStream();
            int read = is.read();
            while (read != -1) {
                readContent.append((char)read);
                read = is.read();
            }
        }
        catch (Exception exception) {
            throw new WebServiceException("Unable to get content as string.", exception);
        }
        return readContent.toString();
    }

    public static InputStream getContentAsInputStream(Content content) {
        String ticket = AuthenticationUtils.getCurrentTicket();
        String strUrl = content.getUrl() + "?ticket=" + ticket;
        try {
            URL url = new URL(strUrl);
            URLConnection conn = url.openConnection();
            return conn.getInputStream();
        }
        catch (Exception exception) {
            throw new WebServiceException("Unable to get content as inputStream.", exception);
        }
    }

    public static void copyContentToFile(Content content, File file) {
        try {
            FileOutputStream os = new FileOutputStream(file);
            FileCopyUtils.copy((InputStream)ContentUtils.getContentAsInputStream(content), (OutputStream)os);
        }
        catch (IOException exception) {
            throw new WebServiceException("Unable to copy content into file.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in, OutputStream out) throws IOException {
        try {
            int byteCount = 0;
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {}
            try {
                out.close();
            }
            catch (IOException ex) {}
        }
    }
}

