/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webservice.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.alfresco.webservice.authentication.AuthenticationFault;
import org.alfresco.webservice.authentication.AuthenticationResult;
import org.alfresco.webservice.util.WebServiceException;
import org.alfresco.webservice.util.WebServiceFactory;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.configuration.FileProvider;
import org.apache.ws.security.WSPasswordCallback;

public class AuthenticationUtils
implements CallbackHandler {
    private static final String WS_SECURITY_INFO = "<deployment xmlns='http://xml.apache.org/axis/wsdd/' xmlns:java='http://xml.apache.org/axis/wsdd/providers/java'>   <transport name='http' pivot='java:org.apache.axis.transport.http.HTTPSender'/>   <globalConfiguration >      <requestFlow >       <handler type='java:org.apache.ws.axis.security.WSDoAllSender' >               <parameter name='action' value='UsernameToken Timestamp'/>               <parameter name='user' value='ticket'/>               <parameter name='passwordCallbackClass' value='org.alfresco.webservice.util.AuthenticationUtils'/>               <parameter name='passwordType' value='PasswordText'/>           </handler>       </requestFlow >   </globalConfiguration></deployment>";
    private static ThreadLocal<String> currentTicket = new ThreadLocal();

    public static void startSession(String username, String password) throws AuthenticationFault {
        try {
            AuthenticationResult result = WebServiceFactory.getAuthenticationService().startSession(username, password);
            currentTicket.set(result.getTicket());
        }
        catch (RemoteException exception) {
            if (exception instanceof AuthenticationFault) {
                throw (AuthenticationFault)((Object)exception);
            }
            throw new WebServiceException("Error starting session.", exception);
        }
    }

    public static void endSession() {
        String ticket = currentTicket.get();
        if (ticket != null) {
            try {
                WebServiceFactory.getAuthenticationService().endSession(ticket);
                currentTicket.remove();
            }
            catch (RemoteException exception) {
                exception.printStackTrace();
                throw new WebServiceException("Error ending session.", exception);
            }
        }
    }

    public static String getCurrentTicket() {
        return currentTicket.get();
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof WSPasswordCallback)) {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
            pc.setPassword(currentTicket.get());
        }
    }

    public static EngineConfiguration getEngineConfiguration() {
        return new FileProvider((InputStream)new ByteArrayInputStream(WS_SECURITY_INFO.getBytes()));
    }
}

