/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.decorator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.decorator.DisplaytagColumnDecorator;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.exception.DecoratorException;
import org.displaytag.exception.ObjectLookupException;
import org.displaytag.model.Column;
import org.displaytag.model.ColumnIterator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.TableModel;

public class MultilevelTotalTableDecorator
extends TableDecorator {
    private static final int NO_RESET_GROUP = 4200;
    protected int innermostGroup;
    private Log logger = LogFactory.getLog((Class)MultilevelTotalTableDecorator.class);
    private String grandTotalLabel = "grandtotal-sum";
    private String subtotalHeaderClass = "subtotal-header";
    private String subtotalLabelClass = "subtotal-label";
    private String subtotalValueClass = "subtotal-sum";
    private Map groupNumberToGroupTotal = new HashMap();
    private int deepestResetGroup = 4200;
    private List headerRows = new ArrayList(5);

    public void init(PageContext context, Object decorated, TableModel model) {
        super.init(context, decorated, model);
        List headerCells = model.getHeaderCellList();
        Iterator iterator = headerCells.iterator();
        while (iterator.hasNext()) {
            HeaderCell headerCell = (HeaderCell)iterator.next();
            if (headerCell.getGroup() <= 0) continue;
            this.groupNumberToGroupTotal.put(new Integer(headerCell.getGroup()), new GroupTotals(headerCell.getColumnNumber()));
            if (headerCell.getGroup() <= this.innermostGroup) continue;
            this.innermostGroup = headerCell.getGroup();
        }
    }

    public String getGrandTotalLabel() {
        return this.grandTotalLabel;
    }

    public void setGrandTotalLabel(String grandTotalLabel) {
        this.grandTotalLabel = grandTotalLabel;
    }

    public String getSubtotalValueClass() {
        return this.subtotalValueClass;
    }

    public void setSubtotalValueClass(String subtotalValueClass) {
        this.subtotalValueClass = subtotalValueClass;
    }

    public String getSubtotalLabelClass() {
        return this.subtotalLabelClass;
    }

    public void setSubtotalLabelClass(String subtotalLabelClass) {
        this.subtotalLabelClass = subtotalLabelClass;
    }

    public String getSubtotalHeaderClass() {
        return this.subtotalHeaderClass;
    }

    public void setSubtotalHeaderClass(String subtotalHeaderClass) {
        this.subtotalHeaderClass = subtotalHeaderClass;
    }

    public void startOfGroup(String value, int group) {
        StringBuffer tr = new StringBuffer();
        tr.append("<tr>");
        for (int i = 1; i < group; ++i) {
            tr.append("<td></td>\n");
        }
        tr.append("<td class=\"").append(this.getSubtotalHeaderClass()).append(" group-").append(group).append("\">");
        tr.append(value).append("</td>\n");
        tr.append("</tr>");
        this.headerRows.add(tr);
    }

    public String displayGroupedValue(String value, short groupingStatus) {
        return "";
    }

    public String startRow() {
        StringBuffer sb = new StringBuffer();
        Iterator iterator = this.headerRows.iterator();
        while (iterator.hasNext()) {
            StringBuffer stringBuffer = (StringBuffer)iterator.next();
            sb.append(stringBuffer);
        }
        return sb.toString();
    }

    public void endOfGroup(String value, int groupNumber) {
        if (this.deepestResetGroup > groupNumber) {
            this.deepestResetGroup = groupNumber;
        }
    }

    public String finishRow() {
        String returnValue;
        if (this.innermostGroup > 0 && this.deepestResetGroup != 4200) {
            StringBuffer out = new StringBuffer();
            for (int i = this.innermostGroup; i >= this.deepestResetGroup; --i) {
                Integer groupNumber = new Integer(i);
                GroupTotals totals = (GroupTotals)this.groupNumberToGroupTotal.get(groupNumber);
                if (totals == null) {
                    this.logger.warn((Object)("There is a gap in the defined groups - no group defined for " + groupNumber));
                    continue;
                }
                totals.printTotals(this.getListIndex(), out);
                totals.setStartRow(this.getListIndex() + 1);
            }
            returnValue = out.toString();
        } else {
            returnValue = null;
        }
        this.deepestResetGroup = 4200;
        this.headerRows.clear();
        if (this.isLastRow()) {
            returnValue = StringUtils.defaultString(returnValue);
            returnValue = returnValue + this.totalAllRows();
        }
        return returnValue;
    }

    protected String totalAllRows() {
        GroupTotals grandTotal = new GroupTotals(-1);
        StringBuffer out = new StringBuffer();
        grandTotal.setStartRow(0);
        grandTotal.setTotalValueClass(this.getGrandTotalLabel());
        grandTotal.printTotals(this.getListIndex(), out);
        return out.toString();
    }

    protected String getCellValue(int columnNumber, int rowNumber) {
        List fullList = this.tableModel.getRowListFull();
        Row row = (Row)fullList.get(rowNumber);
        ColumnIterator columnIterator = row.getColumnIterator(this.tableModel.getHeaderCellList());
        while (columnIterator.hasNext()) {
            Column column = columnIterator.nextColumn();
            if (column.getHeaderCell().getColumnNumber() != columnNumber) continue;
            try {
                column.initialize();
                return column.getChoppedAndLinkedValue();
            }
            catch (ObjectLookupException e) {
                this.logger.error((Object)("Error: " + e.getMessage()), (Throwable)((Object)e));
                throw new RuntimeException("Error: " + e.getMessage(), (Throwable)((Object)e));
            }
            catch (DecoratorException e) {
                this.logger.error((Object)("Error: " + e.getMessage()), (Throwable)((Object)e));
                throw new RuntimeException("Error: " + e.getMessage(), (Throwable)((Object)e));
            }
        }
        throw new RuntimeException("Unable to find column " + columnNumber + " in the list of columns");
    }

    protected double getTotalForColumn(int columnNumber, int startRow, int stopRow) {
        List fullList = this.tableModel.getRowListFull();
        List window = fullList.subList(startRow, stopRow + 1);
        double total = 0.0;
        Iterator iterator = window.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            ColumnIterator columnIterator = row.getColumnIterator(this.tableModel.getHeaderCellList());
            while (columnIterator.hasNext()) {
                Column column = columnIterator.nextColumn();
                if (column.getHeaderCell().getColumnNumber() != columnNumber) continue;
                Number value = null;
                try {
                    value = (Number)column.getValue(false);
                }
                catch (ObjectLookupException e) {
                    this.logger.error((Object)e);
                }
                catch (DecoratorException e) {
                    this.logger.error((Object)e);
                }
                if (value == null) continue;
                total += value.doubleValue();
            }
        }
        return total;
    }

    public String getTotalsTdOpen(HeaderCell header, String totalClass) {
        String cssClass = ObjectUtils.toString(header.getHtmlAttributes().get("class"));
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n<");
        buffer.append("td");
        if (cssClass != null || totalClass != null) {
            buffer.append(" class=\"");
            if (cssClass != null) {
                buffer.append(cssClass);
                if (totalClass != null) {
                    buffer.append(" ");
                }
            }
            if (totalClass != null) {
                buffer.append(totalClass);
            }
            buffer.append("\"");
        }
        buffer.append(">");
        return buffer.toString();
    }

    public String getTotalsRowOpen() {
        return "\n<tr class=\"subtotal\">";
    }

    public String getTotalRowLabel(String groupingValue) {
        return groupingValue + " Total";
    }

    public String formatTotal(HeaderCell header, double total) {
        Object displayValue = new Double(total);
        if (header.getColumnDecorators().length > 0) {
            for (int i = 0; i < header.getColumnDecorators().length; ++i) {
                DisplaytagColumnDecorator decorator = header.getColumnDecorators()[i];
                try {
                    displayValue = decorator.decorate(displayValue, this.getPageContext(), this.tableModel.getMedia());
                    continue;
                }
                catch (DecoratorException e) {
                    this.logger.warn((Object)e.getMessage(), (Throwable)((Object)e));
                }
            }
        }
        return displayValue.toString();
    }

    class GroupTotals {
        protected String totalLabelClass;
        protected String totalValueClass;
        private int columnNumber;
        private int firstRowOfCurrentSet;

        public GroupTotals(int headerCellColumn) {
            this.totalLabelClass = MultilevelTotalTableDecorator.this.getSubtotalLabelClass();
            this.totalValueClass = MultilevelTotalTableDecorator.this.getSubtotalValueClass();
            this.columnNumber = headerCellColumn;
            this.firstRowOfCurrentSet = 0;
        }

        public void printTotals(int currentRow, StringBuffer out) {
            List headerCells = MultilevelTotalTableDecorator.this.tableModel.getHeaderCellList();
            if (this.firstRowOfCurrentSet < currentRow) {
                out.append(MultilevelTotalTableDecorator.this.getTotalsRowOpen());
                Iterator iterator = headerCells.iterator();
                while (iterator.hasNext()) {
                    HeaderCell headerCell = (HeaderCell)iterator.next();
                    if (this.columnNumber == headerCell.getColumnNumber()) {
                        String currentLabel = MultilevelTotalTableDecorator.this.getCellValue(this.columnNumber, this.firstRowOfCurrentSet);
                        out.append(MultilevelTotalTableDecorator.this.getTotalsTdOpen(headerCell, this.getTotalLabelClass() + " group-" + (this.columnNumber + 1)));
                        out.append(MultilevelTotalTableDecorator.this.getTotalRowLabel(currentLabel));
                    } else if (headerCell.isTotaled()) {
                        double total = MultilevelTotalTableDecorator.this.getTotalForColumn(headerCell.getColumnNumber(), this.firstRowOfCurrentSet, currentRow);
                        out.append(MultilevelTotalTableDecorator.this.getTotalsTdOpen(headerCell, this.getTotalValueClass() + " group-" + (this.columnNumber + 1)));
                        out.append(MultilevelTotalTableDecorator.this.formatTotal(headerCell, total));
                    } else {
                        String style = "group-" + (this.columnNumber + 1);
                        if (headerCell.getColumnNumber() < MultilevelTotalTableDecorator.this.innermostGroup) {
                            style = style + " " + this.getTotalLabelClass() + " ";
                        }
                        out.append(MultilevelTotalTableDecorator.this.getTotalsTdOpen(headerCell, style));
                    }
                    out.append("</td>");
                }
                out.append("</tr>\n");
            }
        }

        public void setStartRow(int i) {
            this.firstRowOfCurrentSet = i;
        }

        public String getTotalLabelClass() {
            return this.totalLabelClass;
        }

        public void setTotalLabelClass(String totalLabelClass) {
            this.totalLabelClass = totalLabelClass;
        }

        public String getTotalValueClass() {
            return this.totalValueClass;
        }

        public void setTotalValueClass(String totalValueClass) {
            this.totalValueClass = totalValueClass;
        }
    }
}

