/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.ocsp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.ocsp.OCSPException;

public class RespID {
    ResponderID id;

    public RespID(ResponderID responderID) {
        this.id = responderID;
    }

    public RespID(X509Principal x509Principal) {
    }

    public RespID(PublicKey publicKey) throws OCSPException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(publicKey.getEncoded()));
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(aSN1InputStream.readObject());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(subjectPublicKeyInfo.getPublicKey());
            messageDigest.update(byteArrayOutputStream.toByteArray());
            DEROctetString dEROctetString = new DEROctetString(messageDigest.digest());
            this.id = new ResponderID(dEROctetString);
        }
        catch (Exception exception) {
            throw new OCSPException("problem creating ID: " + exception, exception);
        }
    }

    public ResponderID toASN1Object() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RespID)) {
            return false;
        }
        RespID respID = (RespID)object;
        return this.id.getDERObject().equals(respID.id.getDERObject());
    }

    public int hashCode() {
        return this.id.getDERObject().hashCode();
    }
}

