/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jackrabbit.core.query.LazyReader;
import org.apache.jackrabbit.core.query.TextFilter;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.core.value.InternalValue;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLTextFilter
implements TextFilter {
    public boolean canFilter(String mimeType) {
        return "text/xml".equalsIgnoreCase(mimeType);
    }

    public Map doFilter(PropertyState data, String encoding) throws RepositoryException {
        InternalValue[] values = data.getValues();
        if (values.length > 0) {
            final BLOBFileValue blob = (BLOBFileValue)values[0].internalValue();
            LazyReader reader = new LazyReader(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void initializeReader() throws IOException {
                    try {
                        StringBuffer buffer = new StringBuffer();
                        XMLParser parser = new XMLParser(buffer);
                        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                        saxParserFactory.setValidating(false);
                        SAXParser saxParser = saxParserFactory.newSAXParser();
                        XMLReader xmlReader = saxParser.getXMLReader();
                        xmlReader.setContentHandler(parser);
                        xmlReader.setErrorHandler(parser);
                        InputStream in = blob.getStream();
                        try {
                            InputSource source = new InputSource(in);
                            xmlReader.parse(source);
                            this.delegate = new StringReader(buffer.toString());
                        }
                        finally {
                            in.close();
                        }
                    }
                    catch (SAXException se) {
                        throw new IOException(se.getMessage());
                    }
                    catch (RepositoryException se) {
                        throw new IOException(se.getMessage());
                    }
                    catch (ParserConfigurationException e) {
                        throw new IOException(e.getMessage());
                    }
                }
            };
            HashMap<String, 1> result = new HashMap<String, 1>();
            result.put(FieldNames.FULLTEXT, reader);
            return result;
        }
        throw new RepositoryException("Multi-valued binary properties not supported.");
    }

    private static class XMLParser
    extends DefaultHandler
    implements ErrorHandler {
        private final StringBuffer buffer;

        public XMLParser(StringBuffer buffer) {
            this.buffer = buffer;
        }

        public void startElement(String uri, String local, String name, Attributes attributes) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String value = " " + attributes.getValue(i) + " ";
                this.characters(value.toCharArray(), 0, value.length());
            }
        }

        public void characters(char[] ch, int start, int length) {
            boolean space = false;
            for (int i = start; i < start + length; ++i) {
                if (Character.isLetterOrDigit(ch[i])) {
                    if (space) {
                        this.buffer.append(' ');
                        space = false;
                    }
                    this.buffer.append(ch[i]);
                    continue;
                }
                space = true;
            }
            if (space) {
                this.buffer.append(' ');
            }
        }

        public void warning(SAXParseException spe) {
        }

        public void error(SAXParseException spe) {
        }

        public void fatalError(SAXParseException spe) {
        }
    }
}

