/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.io.BufferedInputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.query.LazyReader;
import org.apache.jackrabbit.core.query.TextFilter;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.core.value.InternalValue;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;

public class PdfTextFilter
implements TextFilter {
    public boolean canFilter(String mimeType) {
        return "application/pdf".equalsIgnoreCase(mimeType);
    }

    public Map doFilter(PropertyState data, String encoding) throws RepositoryException {
        InternalValue[] values = data.getValues();
        if (values.length > 0) {
            final BLOBFileValue blob = (BLOBFileValue)values[0].internalValue();
            LazyReader reader = new LazyReader(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void initializeReader() throws IOException {
                    InputStream in;
                    try {
                        in = blob.getStream();
                    }
                    catch (RepositoryException e) {
                        throw new IOException(e.getMessage());
                    }
                    try {
                        PDFParser parser = new PDFParser((InputStream)new BufferedInputStream(in));
                        parser.parse();
                        PDDocument document = parser.getPDDocument();
                        try {
                            CharArrayWriter writer = new CharArrayWriter();
                            PDFTextStripper stripper = new PDFTextStripper();
                            stripper.setLineSeparator("\n");
                            stripper.writeText(document, (Writer)writer);
                            this.delegate = new CharArrayReader(writer.toCharArray());
                        }
                        finally {
                            document.close();
                        }
                    }
                    catch (Exception e) {
                        throw new IOException(e.getMessage());
                    }
                    finally {
                        in.close();
                    }
                }
            };
            HashMap<String, 1> result = new HashMap<String, 1>();
            result.put(FieldNames.FULLTEXT, reader);
            return result;
        }
        throw new RepositoryException("Multi-valued binary properties not supported.");
    }

    static {
        PDFParser.class.getName();
    }
}

