/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.query.LazyReader;
import org.apache.jackrabbit.core.query.TextFilter;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.util.LittleEndian;

public class MsPowerPointTextFilter
implements TextFilter {
    public boolean canFilter(String mimeType) {
        return "application/vnd.ms-powerpoint".equalsIgnoreCase(mimeType) || "application/mspowerpoint".equalsIgnoreCase(mimeType);
    }

    public Map doFilter(PropertyState data, String encoding) throws RepositoryException {
        InternalValue[] values = data.getValues();
        if (values.length == 1) {
            final BLOBFileValue blob = (BLOBFileValue)values[0].internalValue();
            LazyReader reader = new LazyReader(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void initializeReader() throws IOException {
                    InputStream in;
                    try {
                        in = blob.getStream();
                    }
                    catch (RepositoryException e) {
                        throw new IOException(e.getMessage());
                    }
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        MsPowerPointListener listener = new MsPowerPointListener(baos);
                        POIFSReader reader = new POIFSReader();
                        reader.registerListener((POIFSReaderListener)listener);
                        reader.read(in);
                        this.delegate = new InputStreamReader(new ByteArrayInputStream(baos.toByteArray()));
                    }
                    finally {
                        in.close();
                    }
                }
            };
            HashMap<String, 1> result = new HashMap<String, 1>();
            result.put(FieldNames.FULLTEXT, reader);
            return result;
        }
        throw new RepositoryException("Multi-valued binary properties not supported.");
    }

    static {
        POIFSReader.class.getName();
    }

    private class MsPowerPointListener
    implements POIFSReaderListener {
        private OutputStream os;

        MsPowerPointListener(OutputStream os) {
            this.os = os;
        }

        public void processPOIFSReaderEvent(POIFSReaderEvent event) {
            try {
                if (!event.getName().equalsIgnoreCase("PowerPoint Document")) {
                    return;
                }
                DocumentInputStream input = event.getStream();
                byte[] buffer = new byte[input.available()];
                input.read(buffer, 0, input.available());
                for (int i = 0; i < buffer.length - 20; ++i) {
                    long type = LittleEndian.getUShort((byte[])buffer, (int)(i + 2));
                    long size = LittleEndian.getUInt((byte[])buffer, (int)(i + 4));
                    if (type != 4008L) continue;
                    this.os.write(buffer, i + 4 + 1, (int)size + 3);
                    i = i + 4 + 1 + (int)size - 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

