/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import ymsg.network.ConnectionHandler;
import ymsg.network.DebugInputStream;
import ymsg.network.DebugOutputStream;
import ymsg.network.NetworkConstants;
import ymsg.network.PacketBodyBuffer;
import ymsg.network.Session;
import ymsg.network.Util;
import ymsg.network.YMSG9InputStream;
import ymsg.network.YMSG9Packet;

public class DirectConnectionHandler
extends ConnectionHandler
implements NetworkConstants {
    private String host;
    private int port;
    private boolean dontUseFallbacks = false;
    private Socket socket;
    private YMSG9InputStream ips;
    private DataOutputStream ops;

    public DirectConnectionHandler(String string, int n) {
        this.host = string;
        this.port = n;
        this.dontUseFallbacks = true;
    }

    public DirectConnectionHandler(int n) {
        this(Util.directHost(), n);
    }

    public DirectConnectionHandler(boolean bl) {
        this();
        this.dontUseFallbacks = bl;
    }

    public DirectConnectionHandler() {
        this(Util.directHost(), Util.directPort());
        this.dontUseFallbacks = false;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    void install(Session session, ThreadGroup threadGroup) {
    }

    void open() throws SocketException, IOException {
        if (this.dontUseFallbacks) {
            this.socket = new Socket(this.host, this.port);
        } else {
            int[] nArray = Util.directPorts();
            int n = 0;
            while (this.socket == null) {
                try {
                    this.socket = new Socket(this.host, nArray[n]);
                    this.port = nArray[n];
                }
                catch (SocketException socketException) {
                    this.socket = null;
                    if (++n < nArray.length) continue;
                    throw socketException;
                }
            }
        }
        if (Util.debugMode) {
            this.ips = new YMSG9InputStream(new DebugInputStream(this.socket.getInputStream()));
            this.ops = new DataOutputStream(new DebugOutputStream(this.socket.getOutputStream()));
        } else {
            this.ips = new YMSG9InputStream(this.socket.getInputStream());
            this.ops = new DataOutputStream(this.socket.getOutputStream());
        }
    }

    void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        this.socket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendPacket(PacketBodyBuffer packetBodyBuffer, int n, long l, long l2) throws IOException {
        byte[] byArray = packetBodyBuffer.getBuffer();
        DataOutputStream dataOutputStream = this.ops;
        synchronized (dataOutputStream) {
            this.ops.write(NetworkConstants.MAGIC, 0, 4);
            this.ops.write(NetworkConstants.VERSION, 0, 4);
            this.ops.writeShort(byArray.length & 0xFFFF);
            this.ops.writeShort(n & 0xFFFF);
            this.ops.writeInt((int)(l & 0xFFFFFFFFFFFFFFFFL));
            this.ops.writeInt((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
            this.ops.write(byArray, 0, byArray.length);
            this.ops.flush();
        }
    }

    protected YMSG9Packet receivePacket() throws IOException {
        return this.ips.readPacket();
    }

    public String toString() {
        return "Direct connection: " + this.host + ":" + this.port;
    }
}

