/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public class VCard
extends IQ {
    private Map homePhones = new HashMap();
    private Map workPhones = new HashMap();
    private Map homeAddr = new HashMap();
    private Map workAddr = new HashMap();
    private String firstName;
    private String lastName;
    private String middleName;
    private String emailHome;
    private String emailWork;
    private String organization;
    private String organizationUnit;
    private String avatar;
    private Map otherSimpleFields = new HashMap();
    static /* synthetic */ Class class$org$jivesoftware$smackx$packet$VCard;

    public String getField(String field) {
        return (String)this.otherSimpleFields.get(field);
    }

    public void setField(String field, String value) {
        this.otherSimpleFields.put(field, value);
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getNickName() {
        return (String)this.otherSimpleFields.get("NICKNAME");
    }

    public void setNickName(String nickName) {
        this.otherSimpleFields.put("NICKNAME", nickName);
    }

    public String getEmailHome() {
        return this.emailHome;
    }

    public void setEmailHome(String email) {
        this.emailHome = email;
    }

    public String getEmailWork() {
        return this.emailWork;
    }

    public void setEmailWork(String emailWork) {
        this.emailWork = emailWork;
    }

    public String getJabberId() {
        return (String)this.otherSimpleFields.get("JABBERID");
    }

    public void setJabberId(String jabberId) {
        this.otherSimpleFields.put("JABBERID", jabberId);
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getOrganizationUnit() {
        return this.organizationUnit;
    }

    public void setOrganizationUnit(String organizationUnit) {
        this.organizationUnit = organizationUnit;
    }

    public String getAddressFieldHome(String addrField) {
        return (String)this.homeAddr.get(addrField);
    }

    public void setAddressFieldHome(String addrField, String value) {
        this.homeAddr.put(addrField, value);
    }

    public String getAddressFieldWork(String addrField) {
        return (String)this.workAddr.get(addrField);
    }

    public void setAddressFieldWork(String addrField, String value) {
        this.workAddr.put(addrField, value);
    }

    public void setPhoneHome(String phoneType, String phoneNum) {
        this.homePhones.put(phoneType, phoneNum);
    }

    public String getPhoneHome(String phoneType) {
        return (String)this.homePhones.get(phoneType);
    }

    public void setPhoneWork(String phoneType, String phoneNum) {
        this.workPhones.put(phoneType, phoneNum);
    }

    public String getPhoneWork(String phoneType) {
        return (String)this.workPhones.get(phoneType);
    }

    public void setAvatar(URL avatarURL) {
        String encodedImage;
        byte[] bytes = new byte[]{};
        try {
            bytes = VCard.getBytes(avatarURL);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.avatar = encodedImage = StringUtils.encodeBase64(bytes);
        this.setField("PHOTO", "<TYPE>image/jpeg</TYPE><BINVAL>" + encodedImage + "</BINVAL>");
    }

    public void setAvatar(byte[] bytes) {
        String encodedImage;
        this.avatar = encodedImage = StringUtils.encodeBase64(bytes);
        this.setField("PHOTO", "<TYPE>image/jpeg</TYPE><BINVAL>" + encodedImage + "</BINVAL>");
    }

    public void setEncodedImage(String encodedAvatar) {
        this.avatar = encodedAvatar;
    }

    public byte[] getAvatar() {
        if (this.avatar == null) {
            return null;
        }
        if (this.avatar != null) {
            return StringUtils.decodeBase64(this.avatar);
        }
        return null;
    }

    public static byte[] getBytes(URL url) throws IOException {
        String path = url.getPath();
        File file = new File(path);
        if (file.exists()) {
            return VCard.getFileBytes(file);
        }
        return null;
    }

    private static byte[] getFileBytes(File file) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        int bytes = (int)file.length();
        byte[] buffer = new byte[bytes];
        int readBytes = bis.read(buffer);
        bis.close();
        return buffer;
    }

    public String getAvatarHash() {
        byte[] bytes = this.getAvatar();
        if (bytes == null) {
            return null;
        }
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        digest.update(bytes);
        return StringUtils.encodeHex(digest.digest());
    }

    public void save(XMPPConnection connection) throws XMPPException {
        this.checkAuthenticated(connection);
        this.setType(IQ.Type.SET);
        this.setFrom(connection.getUser());
        PacketCollector collector = connection.createPacketCollector(new PacketIDFilter(this.getPacketID()));
        connection.sendPacket(this);
        Packet response = collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
    }

    public void load(XMPPConnection connection) throws XMPPException {
        this.checkAuthenticated(connection);
        this.setFrom(connection.getUser());
        this.doLoad(connection, connection.getUser());
    }

    public void load(XMPPConnection connection, String user) throws XMPPException {
        this.checkAuthenticated(connection);
        this.setTo(user);
        this.doLoad(connection, user);
    }

    private void doLoad(XMPPConnection connection, String user) throws XMPPException {
        this.setType(IQ.Type.GET);
        PacketCollector collector = connection.createPacketCollector(new PacketIDFilter(this.getPacketID()));
        connection.sendPacket(this);
        VCard result = null;
        try {
            result = (VCard)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
            if (result == null) {
                throw new XMPPException(new XMPPError(408, "Timeout getting VCard information"));
            }
            if (result.getError() != null) {
                throw new XMPPException(result.getError());
            }
        }
        catch (ClassCastException e) {
            System.out.println("No VCard for " + user);
        }
        this.copyFieldsFrom(result);
    }

    public String getChildElementXML() {
        StringBuffer sb = new StringBuffer();
        new VCardWriter(sb).write();
        return sb.toString();
    }

    private void copyFieldsFrom(VCard result) {
        if (result == null) {
            result = new VCard();
        }
        Field[] fields = (class$org$jivesoftware$smackx$packet$VCard == null ? (class$org$jivesoftware$smackx$packet$VCard = VCard.class$("org.jivesoftware.smackx.packet.VCard")) : class$org$jivesoftware$smackx$packet$VCard).getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (field.getDeclaringClass() != (class$org$jivesoftware$smackx$packet$VCard == null ? VCard.class$("org.jivesoftware.smackx.packet.VCard") : class$org$jivesoftware$smackx$packet$VCard) || Modifier.isFinal(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
                field.set(this, field.get(result));
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("This cannot happen:" + field, e);
            }
        }
    }

    private void checkAuthenticated(XMPPConnection connection) {
        if (connection == null) {
            new IllegalArgumentException("No connection was provided");
        }
        if (!connection.isAuthenticated()) {
            new IllegalArgumentException("Connection is not authenticated");
        }
        if (connection.isAnonymous()) {
            new IllegalArgumentException("Connection cannot be anonymous");
        }
    }

    private boolean hasContent() {
        return this.hasNameField() || this.hasOrganizationFields() || this.emailHome != null || this.emailWork != null || this.otherSimpleFields.size() > 0 || this.homeAddr.size() > 0 || this.homePhones.size() > 0 || this.workAddr.size() > 0 || this.workPhones.size() > 0;
    }

    private boolean hasNameField() {
        return this.firstName != null || this.lastName != null || this.middleName != null;
    }

    private boolean hasOrganizationFields() {
        return this.organization != null || this.organizationUnit != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VCard vCard = (VCard)o;
        if (this.emailHome != null ? !this.emailHome.equals(vCard.emailHome) : vCard.emailHome != null) {
            return false;
        }
        if (this.emailWork != null ? !this.emailWork.equals(vCard.emailWork) : vCard.emailWork != null) {
            return false;
        }
        if (this.firstName != null ? !this.firstName.equals(vCard.firstName) : vCard.firstName != null) {
            return false;
        }
        if (!((Object)this.homeAddr).equals(vCard.homeAddr)) {
            return false;
        }
        if (!((Object)this.homePhones).equals(vCard.homePhones)) {
            return false;
        }
        if (this.lastName != null ? !this.lastName.equals(vCard.lastName) : vCard.lastName != null) {
            return false;
        }
        if (this.middleName != null ? !this.middleName.equals(vCard.middleName) : vCard.middleName != null) {
            return false;
        }
        if (this.organization != null ? !this.organization.equals(vCard.organization) : vCard.organization != null) {
            return false;
        }
        if (this.organizationUnit != null ? !this.organizationUnit.equals(vCard.organizationUnit) : vCard.organizationUnit != null) {
            return false;
        }
        if (!((Object)this.otherSimpleFields).equals(vCard.otherSimpleFields)) {
            return false;
        }
        if (!((Object)this.workAddr).equals(vCard.workAddr)) {
            return false;
        }
        return ((Object)this.workPhones).equals(vCard.workPhones);
    }

    public int hashCode() {
        int result = ((Object)this.homePhones).hashCode();
        result = 29 * result + ((Object)this.workPhones).hashCode();
        result = 29 * result + ((Object)this.homeAddr).hashCode();
        result = 29 * result + ((Object)this.workAddr).hashCode();
        result = 29 * result + (this.firstName != null ? this.firstName.hashCode() : 0);
        result = 29 * result + (this.lastName != null ? this.lastName.hashCode() : 0);
        result = 29 * result + (this.middleName != null ? this.middleName.hashCode() : 0);
        result = 29 * result + (this.emailHome != null ? this.emailHome.hashCode() : 0);
        result = 29 * result + (this.emailWork != null ? this.emailWork.hashCode() : 0);
        result = 29 * result + (this.organization != null ? this.organization.hashCode() : 0);
        result = 29 * result + (this.organizationUnit != null ? this.organizationUnit.hashCode() : 0);
        result = 29 * result + ((Object)this.otherSimpleFields).hashCode();
        return result;
    }

    public String toString() {
        return this.getChildElementXML();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static interface ContentBuilder {
        public void addTagContent();
    }

    private class VCardWriter {
        private final StringBuffer sb;

        VCardWriter(StringBuffer sb) {
            this.sb = sb;
        }

        public void write() {
            this.appendTag("vCard", "xmlns", "vcard-temp", VCard.this.hasContent(), new ContentBuilder(){

                public void addTagContent() {
                    VCardWriter.this.buildActualContent();
                }
            });
        }

        private void buildActualContent() {
            if (VCard.this.hasNameField()) {
                this.appendFN();
                this.appendN();
            }
            this.appendOrganization();
            this.appendGenericFields();
            this.appendEmail(VCard.this.emailWork, "WORK");
            this.appendEmail(VCard.this.emailHome, "HOME");
            this.appendPhones(VCard.this.workPhones, "WORK");
            this.appendPhones(VCard.this.homePhones, "HOME");
            this.appendAddress(VCard.this.workAddr, "WORK");
            this.appendAddress(VCard.this.homeAddr, "HOME");
        }

        private void appendEmail(final String email, final String type) {
            if (email != null) {
                this.appendTag("EMAIL", true, new ContentBuilder(){

                    public void addTagContent() {
                        VCardWriter.this.appendEmptyTag(type);
                        VCardWriter.this.appendEmptyTag("INTERNET");
                        VCardWriter.this.appendEmptyTag("PREF");
                        VCardWriter.this.appendTag("USERID", email);
                    }
                });
            }
        }

        private void appendPhones(Map phones, final String code) {
            Iterator it = phones.entrySet().iterator();
            while (it.hasNext()) {
                final Map.Entry entry = it.next();
                this.appendTag("TEL", true, new ContentBuilder(){

                    public void addTagContent() {
                        VCardWriter.this.appendEmptyTag(entry.getKey());
                        VCardWriter.this.appendEmptyTag(code);
                        VCardWriter.this.appendTag("NUMBER", (String)entry.getValue());
                    }
                });
            }
        }

        private void appendAddress(final Map addr, final String code) {
            if (addr.size() > 0) {
                this.appendTag("ADR", true, new ContentBuilder(){

                    public void addTagContent() {
                        VCardWriter.this.appendEmptyTag(code);
                        Iterator it = addr.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            VCardWriter.this.appendTag((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                });
            }
        }

        private void appendEmptyTag(Object tag) {
            this.sb.append('<').append(tag).append("/>");
        }

        private void appendGenericFields() {
            Iterator it = VCard.this.otherSimpleFields.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.appendTag(entry.getKey().toString(), (String)entry.getValue());
            }
        }

        private void appendOrganization() {
            if (VCard.this.hasOrganizationFields()) {
                this.appendTag("ORG", true, new ContentBuilder(){

                    public void addTagContent() {
                        VCardWriter.this.appendTag("ORGNAME", VCard.this.organization);
                        VCardWriter.this.appendTag("ORGUNIT", VCard.this.organizationUnit);
                    }
                });
            }
        }

        private void appendField(String tag) {
            String value = (String)VCard.this.otherSimpleFields.get(tag);
            this.appendTag(tag, value);
        }

        private void appendFN() {
            ContentBuilder contentBuilder = new ContentBuilder(){

                public void addTagContent() {
                    if (VCard.this.firstName != null) {
                        VCardWriter.this.sb.append(VCard.this.firstName + ' ');
                    }
                    if (VCard.this.middleName != null) {
                        VCardWriter.this.sb.append(VCard.this.middleName + ' ');
                    }
                    if (VCard.this.lastName != null) {
                        VCardWriter.this.sb.append(VCard.this.lastName);
                    }
                }
            };
            this.appendTag("FN", true, contentBuilder);
        }

        private void appendN() {
            this.appendTag("N", true, new ContentBuilder(){

                public void addTagContent() {
                    VCardWriter.this.appendTag("FAMILY", VCard.this.lastName);
                    VCardWriter.this.appendTag("GIVEN", VCard.this.firstName);
                    VCardWriter.this.appendTag("MIDDLE", VCard.this.middleName);
                }
            });
        }

        private void appendTag(String tag, String attr, String attrValue, boolean hasContent, ContentBuilder builder) {
            this.sb.append('<').append(tag);
            if (attr != null) {
                this.sb.append(' ').append(attr).append('=').append('\'').append(attrValue).append('\'');
            }
            if (hasContent) {
                this.sb.append('>');
                builder.addTagContent();
                this.sb.append("</").append(tag).append(">\n");
            } else {
                this.sb.append("/>\n");
            }
        }

        private void appendTag(String tag, boolean hasContent, ContentBuilder builder) {
            this.appendTag(tag, null, null, hasContent, builder);
        }

        private void appendTag(String tag, final String tagText) {
            if (tagText == null) {
                return;
            }
            ContentBuilder contentBuilder = new ContentBuilder(){

                public void addTagContent() {
                    VCardWriter.this.sb.append(tagText.trim());
                }
            };
            this.appendTag(tag, true, contentBuilder);
        }
    }
}

