/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector;

import net.sf.uadetector.ReadableOperatingSystem;

public final class OperatingSystem
implements ReadableOperatingSystem {
    public static final OperatingSystem EMPTY = new OperatingSystem("unknown", "unknown", "", "", "");
    private final String family;
    private final String name;
    private final String producer;
    private final String producerUrl;
    private final String url;

    public OperatingSystem(String family, String name, String producer, String producerUrl, String url) {
        if (producer == null) {
            throw new IllegalArgumentException("Argument 'producer' must not be null");
        }
        if (producerUrl == null) {
            throw new IllegalArgumentException("Argument 'producerUrl' must not be null");
        }
        if (family == null) {
            throw new IllegalArgumentException("Argument 'family' must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' must not be null");
        }
        if (url == null) {
            throw new IllegalArgumentException("Argument 'url' must not be null");
        }
        this.producer = producer;
        this.producerUrl = producerUrl;
        this.family = family;
        this.name = name;
        this.url = url;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperatingSystem other = (OperatingSystem)obj;
        if (!this.family.equals(other.family)) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!this.producer.equals(other.producer)) {
            return false;
        }
        if (!this.producerUrl.equals(other.producerUrl)) {
            return false;
        }
        return this.url.equals(other.url);
    }

    @Override
    public String getFamily() {
        return this.family;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProducer() {
        return this.producer;
    }

    @Override
    public String getProducerUrl() {
        return this.producerUrl;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.family.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.producer.hashCode();
        result = 31 * result + this.producerUrl.hashCode();
        result = 31 * result + this.url.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OperatingSystem [family=");
        builder.append(this.family);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", producer=");
        builder.append(this.producer);
        builder.append(", producerUrl=");
        builder.append(this.producerUrl);
        builder.append(", url=");
        builder.append(this.url);
        builder.append("]");
        return builder.toString();
    }
}

