/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter;

import java.util.LinkedList;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;

public class BufferedReportEmitter
extends ContentEmitterAdapter {
    LinkedList events = new LinkedList();
    protected IContentEmitter emitter;

    public BufferedReportEmitter(IContentEmitter emitter) {
        this.emitter = emitter;
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    public void flush() throws BirtException {
        if (this.emitter instanceof BufferedReportEmitter) {
            ((BufferedReportEmitter)this.emitter).events.addAll(this.events);
        } else {
            for (BufferedNode node : this.events) {
                if (node.start) {
                    ContentEmitterUtil.startContent(node.content, this.emitter);
                    continue;
                }
                ContentEmitterUtil.endContent(node.content, this.emitter);
            }
        }
        this.events.clear();
    }

    public void startContent(IContent content) {
        this.events.add(new BufferedNode(content, true));
    }

    public void endContent(IContent content) {
        this.events.add(new BufferedNode(content, false));
    }

    public static class BufferedNode {
        boolean start;
        protected IContent content;

        BufferedNode(IContent content, boolean start) {
            this.content = content;
            this.start = start;
        }

        public IContent getContent() {
            return this.content;
        }

        public boolean isStart() {
            return this.start;
        }
    }
}

