/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.replication.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.net.ServerSocketFactory;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.replication.net.ReplicationMessage;
import org.apache.derby.impl.store.replication.net.SlaveAddress;
import org.apache.derby.impl.store.replication.net.SocketConnection;

public class ReplicationMessageReceive {
    private final SlaveAddress slaveAddress;
    private ServerSocket serverSocket;
    private SocketConnection socketConn;
    private static final int DEFAULT_PING_TIMEOUT = 5000;
    private Thread pingThread = null;
    private boolean killPingThread = false;
    private boolean connectionConfirmed = false;
    private final Object sendPingSemaphore = new Object();
    private final Object receivePongSemaphore = new Object();

    public ReplicationMessageReceive(SlaveAddress slaveAddress, String string) {
        this.slaveAddress = slaveAddress;
        Monitor.logTextMessage("R011", string, slaveAddress.getHostAddress().getHostName(), String.valueOf(slaveAddress.getPortNumber()));
    }

    public void initConnection(int n, long l, String string) throws PrivilegedActionException, IOException, StandardException, ClassNotFoundException {
        if (this.serverSocket == null) {
            this.serverSocket = this.createServerSocket();
        }
        this.serverSocket.setSoTimeout(n);
        Socket socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                return ReplicationMessageReceive.this.serverSocket.accept();
            }
        });
        this.socketConn = new SocketConnection(socket);
        this.parseAndAckVersion(this.readMessage(), string);
        this.parseAndAckInstant(this.readMessage(), l, string);
        this.killPingThread = false;
        this.pingThread = new SlavePingThread(string);
        this.pingThread.setDaemon(true);
        this.pingThread.start();
    }

    private ServerSocket createServerSocket() throws PrivilegedActionException {
        return (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws IOException, StandardException {
                ServerSocketFactory serverSocketFactory = ServerSocketFactory.getDefault();
                return serverSocketFactory.createServerSocket(ReplicationMessageReceive.this.slaveAddress.getPortNumber(), 0, ReplicationMessageReceive.this.slaveAddress.getHostAddress());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void tearDown() throws IOException {
        Object object = this.sendPingSemaphore;
        synchronized (object) {
            this.killPingThread = true;
            this.sendPingSemaphore.notify();
        }
        try {
            if (this.socketConn != null) {
                this.socketConn.tearDown();
            }
            Object var4_3 = null;
            if (this.serverSocket == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.serverSocket == null) throw throwable;
            this.serverSocket.close();
            throw throwable;
        }
        this.serverSocket.close();
    }

    private void parseAndAckVersion(ReplicationMessage replicationMessage, String string) throws IOException, StandardException {
        long l;
        ReplicationMessage replicationMessage2 = null;
        if (replicationMessage.getType() != 0) {
            String string2 = String.valueOf(0);
            String string3 = String.valueOf(replicationMessage.getType());
            this.handleUnexpectedMessage(string, string2, string3);
        }
        if ((l = ((Long)replicationMessage.getMessage()).longValue()) != 1L) {
            replicationMessage2 = new ReplicationMessage(12, new String[]{"XRE02"});
            this.sendMessage(replicationMessage2);
            throw StandardException.newException("XRE02");
        }
        replicationMessage2 = new ReplicationMessage(11, "UID OK");
        this.sendMessage(replicationMessage2);
    }

    private void parseAndAckInstant(ReplicationMessage replicationMessage, long l, String string) throws IOException, StandardException {
        long l2;
        ReplicationMessage replicationMessage2 = null;
        if (replicationMessage.getType() != 1) {
            String string2 = String.valueOf(1);
            String string3 = String.valueOf(replicationMessage.getType());
            this.handleUnexpectedMessage(string, string2, string3);
        }
        if ((l2 = ((Long)replicationMessage.getMessage()).longValue()) != l) {
            Object[] objectArray = new String[]{string, String.valueOf(LogCounter.getLogFileNumber(l2)), String.valueOf(LogCounter.getLogFilePosition(l2)), String.valueOf(LogCounter.getLogFileNumber(l)), String.valueOf(LogCounter.getLogFilePosition(l)), "XRE05"};
            replicationMessage2 = new ReplicationMessage(12, objectArray);
            this.sendMessage(replicationMessage2);
            throw StandardException.newException("XRE05", objectArray);
        }
        replicationMessage2 = new ReplicationMessage(11, "Instant OK");
        this.sendMessage(replicationMessage2);
    }

    private void handleUnexpectedMessage(String string, String string2, String string3) throws StandardException, IOException {
        Object[] objectArray = new String[]{string, string2, string3, "XRE12"};
        ReplicationMessage replicationMessage = new ReplicationMessage(12, objectArray);
        this.sendMessage(replicationMessage);
        throw StandardException.newException("XRE12", objectArray);
    }

    public void sendMessage(ReplicationMessage replicationMessage) throws IOException {
        this.checkSocketConnection();
        this.socketConn.writeMessage(replicationMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationMessage readMessage() throws ClassNotFoundException, IOException {
        this.checkSocketConnection();
        ReplicationMessage replicationMessage = (ReplicationMessage)this.socketConn.readMessage();
        if (replicationMessage.getType() == 14) {
            Object object = this.receivePongSemaphore;
            synchronized (object) {
                this.connectionConfirmed = true;
                this.receivePongSemaphore.notify();
            }
            return this.readMessage();
        }
        return replicationMessage;
    }

    private void checkSocketConnection() throws IOException {
        if (this.socketConn == null) {
            throw new IOException("R012");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isConnectedToMaster() {
        Object object = this.receivePongSemaphore;
        synchronized (object) {
            this.connectionConfirmed = false;
            Object object2 = this.sendPingSemaphore;
            synchronized (object2) {
                this.sendPingSemaphore.notify();
            }
            try {
                this.receivePongSemaphore.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.connectionConfirmed;
    }

    private class SlavePingThread
    extends Thread {
        private final ReplicationMessage pingMsg;

        SlavePingThread(String string) {
            super("derby.slave.ping-" + string);
            this.pingMsg = new ReplicationMessage(13, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!ReplicationMessageReceive.this.killPingThread) {
                    Object object = ReplicationMessageReceive.this.sendPingSemaphore;
                    synchronized (object) {
                        ReplicationMessageReceive.this.sendPingSemaphore.wait();
                    }
                    if (!ReplicationMessageReceive.this.killPingThread) {
                        ReplicationMessageReceive.this.sendMessage(this.pingMsg);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

