/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.servlet;

import com.liferay.util.Encryptor;
import com.liferay.util.EncryptorException;
import com.liferay.util.Validator;
import java.security.Key;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class EncryptedServletRequest
extends HttpServletRequestWrapper {
    private Map _params = new HashMap();
    private Key _key;

    public String getParameter(String name) {
        String[] values = (String[])this._params.get(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this._params);
    }

    public String[] getParameterValues(String name) {
        return (String[])this._params.get(name);
    }

    public EncryptedServletRequest(HttpServletRequest req, Key key) {
        super(req);
        this._key = key;
        Enumeration enu = this.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            String[] values = super.getParameterValues(name);
            int i = 0;
            while (i < values.length) {
                if (Validator.isNotNull(values[i])) {
                    try {
                        values[i] = Encryptor.decrypt(this._key, values[i]);
                    }
                    catch (EncryptorException ee) {
                        values[i] = "";
                    }
                }
                ++i;
            }
            this._params.put(name, values);
        }
    }
}

