/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.util.GetterUtil;
import com.liferay.util.StringUtil;
import com.liferay.util.Validator;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class LDAPUtil {
    public static String getAttributeValue(Attributes attrs, String id) throws NamingException {
        return LDAPUtil.getAttributeValue(attrs, id, "");
    }

    public static String getAttributeValue(Attributes attrs, String id, String defaultValue) throws NamingException {
        try {
            Attribute attr = attrs.get(id);
            Object obj = attr.get();
            return obj.toString();
        }
        catch (NullPointerException npe) {
            return defaultValue;
        }
    }

    public static String getFullProviderURL(String baseURL, String baseDN) {
        return baseURL + '/' + baseDN;
    }

    public static String[] splitFullName(String fullName) {
        String firstName = "";
        String lastName = "";
        String middleName = "";
        if (Validator.isNotNull(fullName)) {
            String[] name = StringUtil.split(fullName, " ");
            firstName = name[0];
            lastName = name[name.length - 1];
            middleName = "";
            if (name.length > 2) {
                int i = 1;
                while (i < name.length - 1) {
                    if (!Validator.isNull(name[i].trim())) {
                        if (i != 1) {
                            middleName = middleName + ' ';
                        }
                        middleName = middleName + name[i].trim();
                    }
                    ++i;
                }
            }
        } else {
            lastName = firstName = GetterUtil.getString(firstName, lastName);
        }
        return new String[]{firstName, middleName, lastName};
    }
}

