/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshvnc;

import com.sshtools.common.configuration.SshToolsConnectionProfile;

public class SshVNCOptions
implements Cloneable {
    private int[] encodings = new int[20];
    private int nEncodings;
    private int preferredEncoding;
    private int compressLevel;
    private int cursorUpdates;
    private int jpegQuality;
    private int screenSizePolicy;
    private boolean useCopyRect;
    private boolean eightBitColors;
    private boolean requestCursorUpdates;
    private boolean ignoreCursorUpdates;
    private boolean reverseMouseButtons2And3;
    private boolean viewOnly;
    private boolean shareDesktop;
    private String encryptedPassword;

    public SshVNCOptions() {
        this(null);
    }

    public SshVNCOptions(SshToolsConnectionProfile sshToolsConnectionProfile) {
        this.setFromProfile(sshToolsConnectionProfile);
    }

    public boolean isReverseMouseButtons2And3() {
        return this.reverseMouseButtons2And3;
    }

    public boolean isViewOnly() {
        return this.viewOnly;
    }

    public boolean isShareDesktop() {
        return this.shareDesktop;
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public int[] getEncodings() {
        return this.encodings;
    }

    public int getNumberOfEncodings() {
        return this.nEncodings;
    }

    public int getCompressLevel() {
        return this.compressLevel;
    }

    public int getJPEGQuality() {
        return this.jpegQuality;
    }

    public boolean isUseCopyRect() {
        return this.useCopyRect;
    }

    public void setEightBitColors(boolean bl) {
        this.eightBitColors = bl;
    }

    public boolean isEightBitColors() {
        return this.eightBitColors;
    }

    public boolean isRequestCursorUpdates() {
        return this.requestCursorUpdates;
    }

    public void setRequestCursorUpdates(boolean bl) {
        this.requestCursorUpdates = bl;
    }

    public boolean isIgnoreCursorUpdates() {
        return this.ignoreCursorUpdates;
    }

    public int getScreenSizePolicy() {
        return this.screenSizePolicy;
    }

    public void setEncodings() {
        this.nEncodings = 0;
        if (this.useCopyRect) {
            this.encodings[this.nEncodings++] = 1;
        }
        boolean bl = this.preferredEncoding == 6 || this.preferredEncoding == 7;
        this.encodings[this.nEncodings++] = this.preferredEncoding;
        if (this.preferredEncoding != 5) {
            this.encodings[this.nEncodings++] = 5;
        }
        if (this.preferredEncoding != 7) {
            this.encodings[this.nEncodings++] = 7;
        }
        if (this.preferredEncoding != 6) {
            this.encodings[this.nEncodings++] = 6;
        }
        if (this.preferredEncoding != 4) {
            this.encodings[this.nEncodings++] = 4;
        }
        if (this.preferredEncoding != 2) {
            this.encodings[this.nEncodings++] = 2;
        }
        if (bl) {
            if (this.compressLevel >= 1 && this.compressLevel <= 9) {
                this.encodings[this.nEncodings++] = -256 + this.compressLevel;
            } else {
                this.compressLevel = -1;
            }
        }
        if (this.preferredEncoding == 7 && !this.eightBitColors) {
            if (this.jpegQuality >= 0 && this.jpegQuality <= 9) {
                this.encodings[this.nEncodings++] = -32 + this.jpegQuality;
            } else {
                this.jpegQuality = -1;
            }
        }
        boolean bl2 = this.requestCursorUpdates = this.cursorUpdates != 2;
        if (this.requestCursorUpdates) {
            this.encodings[this.nEncodings++] = -240;
            this.encodings[this.nEncodings++] = -239;
            boolean bl3 = this.ignoreCursorUpdates = this.cursorUpdates == 1;
            if (!this.ignoreCursorUpdates) {
                this.encodings[this.nEncodings++] = -232;
            }
        }
        this.encodings[this.nEncodings++] = -224;
        this.encodings[this.nEncodings++] = -223;
    }

    public void setFromProfile(SshToolsConnectionProfile sshToolsConnectionProfile) {
        this.preferredEncoding = sshToolsConnectionProfile == null ? 7 : sshToolsConnectionProfile.getApplicationPropertyInt("PREFERRED_ENCODING", 7);
        this.useCopyRect = sshToolsConnectionProfile == null ? true : sshToolsConnectionProfile.getApplicationPropertyBoolean("USE_COPY_RECT", true);
        this.compressLevel = sshToolsConnectionProfile == null ? 0 : sshToolsConnectionProfile.getApplicationPropertyInt("COMPRESS_LEVEL", 0);
        this.jpegQuality = sshToolsConnectionProfile == null ? 7 : sshToolsConnectionProfile.getApplicationPropertyInt("JPEG_QUALITY", 7);
        this.cursorUpdates = sshToolsConnectionProfile == null ? 0 : sshToolsConnectionProfile.getApplicationPropertyInt("CURSOR_UPDATES", 0);
        this.screenSizePolicy = sshToolsConnectionProfile == null ? 0 : sshToolsConnectionProfile.getApplicationPropertyInt("VNC_SCREEN_SIZE", 0);
        this.eightBitColors = sshToolsConnectionProfile == null ? false : sshToolsConnectionProfile.getApplicationPropertyBoolean("EIGHT_BIT_COLORS", false);
        this.reverseMouseButtons2And3 = sshToolsConnectionProfile == null ? false : sshToolsConnectionProfile.getApplicationPropertyBoolean("REVERSE_MOUSE_BUTTONS_2_AND_3", false);
        this.viewOnly = sshToolsConnectionProfile == null ? false : sshToolsConnectionProfile.getApplicationPropertyBoolean("VIEW_ONLY", false);
        this.shareDesktop = sshToolsConnectionProfile == null ? false : sshToolsConnectionProfile.getApplicationPropertyBoolean("SHARE_DESKTOP", false);
        this.encryptedPassword = sshToolsConnectionProfile == null ? "" : sshToolsConnectionProfile.getApplicationProperty("ENCRYPTED_VNC_PASSWORD", "");
        this.setEncodings();
    }

    public Object clone() {
        SshVNCOptions sshVNCOptions = new SshVNCOptions();
        sshVNCOptions.encodings = this.encodings;
        sshVNCOptions.nEncodings = this.nEncodings;
        sshVNCOptions.preferredEncoding = this.preferredEncoding;
        sshVNCOptions.compressLevel = this.compressLevel;
        sshVNCOptions.cursorUpdates = this.cursorUpdates;
        sshVNCOptions.jpegQuality = this.jpegQuality;
        sshVNCOptions.useCopyRect = this.useCopyRect;
        sshVNCOptions.eightBitColors = this.eightBitColors;
        sshVNCOptions.requestCursorUpdates = this.requestCursorUpdates;
        sshVNCOptions.ignoreCursorUpdates = this.ignoreCursorUpdates;
        sshVNCOptions.reverseMouseButtons2And3 = this.reverseMouseButtons2And3;
        sshVNCOptions.viewOnly = this.viewOnly;
        sshVNCOptions.shareDesktop = this.shareDesktop;
        sshVNCOptions.screenSizePolicy = this.screenSizePolicy;
        return sshVNCOptions;
    }
}

