/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPair;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshKeyPairFactory {
    private static Map pks;
    private static String defaultAlgorithm;
    private static Log log;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$SshKeyPairFactory;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssKeyPair;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$rsa$SshRsaKeyPair;

    protected SshKeyPairFactory() {
    }

    public static void initialize() {
    }

    public static String getDefaultPublicKey() {
        return defaultAlgorithm;
    }

    public static List getSupportedKeys() {
        return new ArrayList(pks.keySet());
    }

    public static SshKeyPair newInstance(String string) throws AlgorithmNotSupportedException {
        try {
            return (SshKeyPair)((Class)pks.get(string)).newInstance();
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(string + " is not supported!");
        }
    }

    public static boolean supportsKey(String string) {
        return pks.containsKey(string);
    }

    public static SshPrivateKey decodePrivateKey(byte[] byArray) throws InvalidSshKeyException, AlgorithmNotSupportedException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (SshKeyPairFactory.supportsKey(string)) {
                SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string);
                return sshKeyPair.decodePrivateKey(byArray);
            }
            throw new AlgorithmNotSupportedException(string + " is not supported");
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException(iOException.getMessage());
        }
    }

    public static SshPublicKey decodePublicKey(byte[] byArray) throws InvalidSshKeyException, AlgorithmNotSupportedException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (SshKeyPairFactory.supportsKey(string)) {
                SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string);
                return sshKeyPair.decodePublicKey(byArray);
            }
            throw new AlgorithmNotSupportedException(string + " is not supported");
        }
        catch (IOException iOException) {
            throw new InvalidSshKeyException(iOException.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        log = LogFactory.getLog(class$com$sshtools$j2ssh$transport$publickey$SshKeyPairFactory == null ? (class$com$sshtools$j2ssh$transport$publickey$SshKeyPairFactory = SshKeyPairFactory.class$("com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory")) : class$com$sshtools$j2ssh$transport$publickey$SshKeyPairFactory);
        pks = new HashMap();
        log.info("Loading public key algorithms");
        pks.put("ssh-dss", class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssKeyPair == null ? (class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssKeyPair = SshKeyPairFactory.class$("com.sshtools.j2ssh.transport.publickey.dsa.SshDssKeyPair")) : class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssKeyPair);
        pks.put("ssh-rsa", class$com$sshtools$j2ssh$transport$publickey$rsa$SshRsaKeyPair == null ? (class$com$sshtools$j2ssh$transport$publickey$rsa$SshRsaKeyPair = SshKeyPairFactory.class$("com.sshtools.j2ssh.transport.publickey.rsa.SshRsaKeyPair")) : class$com$sshtools$j2ssh$transport$publickey$rsa$SshRsaKeyPair);
        defaultAlgorithm = "ssh-dss";
    }
}

