/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.zip;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ZipReader
implements Serializable {
    private static final int _BUFFER = 2048;
    private ZipInputStream _zis;
    private HashMap _entries;
    private byte[] _data;

    public String getEntryAsString(String name) throws Exception {
        byte[] byteArray = this.getEntryAsByteArray(name);
        if (byteArray != null) {
            return new String(byteArray);
        }
        return null;
    }

    public byte[] getEntryAsByteArray(String name) throws Exception {
        if (this._entries.containsKey(name)) {
            return (byte[])this._entries.get(name);
        }
        ZipEntry entry = null;
        while ((entry = this._zis.getNextEntry()) != null) {
            int count;
            String currentName = entry.getName();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((count = this._zis.read(this._data, 0, 2048)) != -1) {
                baos.write(this._data, 0, count);
            }
            byte[] byteArray = baos.toByteArray();
            this._entries.put(currentName, byteArray);
            if (!currentName.equals(name)) continue;
            return byteArray;
        }
        return null;
    }

    private final /* synthetic */ void this() {
        this._entries = new HashMap();
        this._data = new byte[2048];
    }

    public ZipReader(File file) throws Exception {
        this.this();
        this._zis = new ZipInputStream(new FileInputStream(file));
    }

    public ZipReader(InputStream stream) {
        this.this();
        this._zis = new ZipInputStream(stream);
    }
}

