/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.xml.descriptor;

import com.liferay.util.xml.AttributeComparator;
import com.liferay.util.xml.ElementComparator;
import com.liferay.util.xml.descriptor.XMLDescriptor;
import java.util.Comparator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public class StrictXMLDescriptor
implements XMLDescriptor {
    private static final String[] _ROOT_ORDERED_CHILDREN = new String[0];

    public boolean areEqual(Element el1, Element el2) {
        return this._compare(el1, el2) == 0;
    }

    public boolean canHandleType(String doctype, Document root) {
        return false;
    }

    public boolean canJoinChildren(Element element) {
        return false;
    }

    public String[] getRootChildrenOrder() {
        return _ROOT_ORDERED_CHILDREN;
    }

    private final int _compare(Object obj1, Object obj2) {
        String el2Text;
        String el2Name;
        Element el1 = (Element)obj1;
        Element el2 = (Element)obj2;
        String el1Name = el1.getName();
        if (!el1Name.equals(el2Name = el2.getName())) {
            return el1Name.compareTo(el2Name);
        }
        String el1Text = el1.getTextTrim();
        if (!el1Text.equals(el2Text = el2.getTextTrim())) {
            return el1Text.compareTo(el2Text);
        }
        int attributeComparison = this._compareAttributes(el1, el2);
        if (attributeComparison != 0) {
            return attributeComparison;
        }
        int childrenComparison = this._compareChildren(el1, el2);
        if (childrenComparison != 0) {
            return childrenComparison;
        }
        return 0;
    }

    private final int _compareAttributes(Element el1, Element el2) {
        List el1Attrs = el1.attributes();
        List el2Attrs = el2.attributes();
        if (el1Attrs.size() < el2Attrs.size()) {
            return -1;
        }
        if (el1Attrs.size() > el2Attrs.size()) {
            return 1;
        }
        int i = 0;
        while (i < el1Attrs.size()) {
            Attribute attr = (Attribute)el1Attrs.get(i);
            int value = this._contains(el2Attrs, attr, new AttributeComparator());
            if (value != 0) {
                return value;
            }
            ++i;
        }
        return -1;
    }

    private final int _compareChildren(Element el1, Element el2) {
        List el1Children = el1.elements();
        List el2Children = el2.elements();
        if (el1Children.size() < el2Children.size()) {
            return -1;
        }
        if (el1Children.size() > el2Children.size()) {
            return 1;
        }
        int i = 0;
        while (i < el1Children.size()) {
            Element el = (Element)el1Children.get(i);
            int value = this._contains(el2Children, el, new ElementComparator());
            if (value != 0) {
                return value;
            }
            ++i;
        }
        return -1;
    }

    private final int _contains(List list, Object obj, Comparator comparator) {
        int firstValue = -1;
        int i = 0;
        while (i < list.size()) {
            Object o = list.get(i);
            int value = comparator.compare(obj, o);
            if (i == 0) {
                firstValue = value;
            }
            if (value == 0) {
                return 0;
            }
            ++i;
        }
        return firstValue;
    }
}

