/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.poi;

import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class XLSTextStripper {
    private String _text;

    public String getText() {
        return this._text;
    }

    public XLSTextStripper(InputStream in) {
        try {
            StringBuffer sb = new StringBuffer();
            HSSFWorkbook workbook = new HSSFWorkbook(in);
            int numOfSheets = workbook.getNumberOfSheets();
            int i = 0;
            while (i < numOfSheets) {
                HSSFSheet sheet = workbook.getSheetAt(i);
                Iterator rowIterator = sheet.rowIterator();
                while (rowIterator.hasNext()) {
                    HSSFRow row = (HSSFRow)rowIterator.next();
                    Iterator cellIterator = row.cellIterator();
                    while (cellIterator.hasNext()) {
                        HSSFCell cell = (HSSFCell)cellIterator.next();
                        String cellStringValue = null;
                        if (cell.getCellType() == 4) {
                            boolean booleanValue = cell.getBooleanCellValue();
                            cellStringValue = Boolean.toString(booleanValue);
                        } else if (cell.getCellType() == 0) {
                            double doubleValue = cell.getNumericCellValue();
                            cellStringValue = Double.toString(doubleValue);
                        } else if (cell.getCellType() == 1) {
                            cellStringValue = cell.getStringCellValue();
                        }
                        if (cellStringValue == null) continue;
                        sb.append(cellStringValue);
                        sb.append("\t");
                    }
                    sb.append("\n");
                }
                ++i;
            }
            this._text = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

