/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.mail;

import com.liferay.portal.kernel.mail.MailMessage;
import com.liferay.util.GetterUtil;
import com.liferay.util.JNDIUtil;
import com.liferay.util.Validator;
import com.liferay.util.mail.LiferayMimeMessage;
import com.liferay.util.mail.MailEngineException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MailEngine {
    public static final String MAIL_SESSION = "java:comp/env/mail/MailSession";
    private static final String _TEXT_HTML = "text/html;charset=\"UTF-8\"";
    private static final String _TEXT_PLAIN = "text/plain;charset=\"UTF-8\"";
    private static Log _log;
    static /* synthetic */ Class class$com$liferay$util$mail$MailEngine;

    public static Session getSession() throws NamingException {
        return MailEngine.getSession(false);
    }

    public static Session getSession(boolean cache) throws NamingException {
        Session session = (Session)JNDIUtil.lookup(new InitialContext(), MAIL_SESSION, cache);
        session.setDebug(_log.isDebugEnabled());
        if (_log.isDebugEnabled()) {
            session.getProperties().list(System.out);
        }
        return session;
    }

    public static void send(MailMessage mailMessage) throws MailEngineException {
        MailEngine.send(mailMessage.getFrom(), mailMessage.getTo(), mailMessage.getCC(), mailMessage.getBCC(), mailMessage.getSubject(), mailMessage.getBody(), mailMessage.isHTMLFormat(), mailMessage.getReplyTo(), mailMessage.getMessageId(), mailMessage.getInReplyTo());
    }

    public static void send(String from, String to, String subject, String body) throws MailEngineException {
        try {
            MailEngine.send(new InternetAddress(from), new InternetAddress(to), subject, body);
        }
        catch (AddressException ae) {
            throw new MailEngineException(ae);
        }
    }

    public static void send(InternetAddress from, InternetAddress to, String subject, String body) throws MailEngineException {
        MailEngine.send(from, new InternetAddress[]{to}, null, null, subject, body, false, null, null, null);
    }

    public static void send(InternetAddress from, InternetAddress to, String subject, String body, boolean htmlFormat) throws MailEngineException {
        MailEngine.send(from, new InternetAddress[]{to}, null, null, subject, body, htmlFormat, null, null, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, String subject, String body) throws MailEngineException {
        MailEngine.send(from, to, null, null, subject, body, false, null, null, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, String subject, String body, boolean htmlFormat) throws MailEngineException {
        MailEngine.send(from, to, null, null, subject, body, htmlFormat, null, null, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, InternetAddress[] cc, String subject, String body) throws MailEngineException {
        MailEngine.send(from, to, cc, null, subject, body, false, null, null, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, InternetAddress[] cc, String subject, String body, boolean htmlFormat) throws MailEngineException {
        MailEngine.send(from, to, cc, null, subject, body, htmlFormat, null, null, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, InternetAddress[] cc, InternetAddress[] bcc, String subject, String body) throws MailEngineException {
        MailEngine.send(from, to, cc, bcc, subject, body, false, null, null, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, InternetAddress[] cc, InternetAddress[] bcc, String subject, String body, boolean htmlFormat, InternetAddress[] replyTo, String messageId, String inReplyTo) throws MailEngineException {
        long start = 0L;
        if (_log.isDebugEnabled()) {
            start = System.currentTimeMillis();
            _log.debug((Object)("From: " + from));
            _log.debug((Object)("To: " + to));
            _log.debug((Object)("CC: " + cc));
            _log.debug((Object)("BCC: " + bcc));
            _log.debug((Object)("Subject: " + subject));
            _log.debug((Object)("Body: " + body));
            _log.debug((Object)("HTML Format: " + htmlFormat));
            _log.debug((Object)("Reply to: " + replyTo));
            _log.debug((Object)("Message ID: " + messageId));
            _log.debug((Object)("In Reply To: " + inReplyTo));
        }
        try {
            Session session = MailEngine.getSession();
            LiferayMimeMessage msg = new LiferayMimeMessage(session);
            msg.setFrom((Address)from);
            msg.setRecipients(Message.RecipientType.TO, (Address[])to);
            if (cc != null) {
                msg.setRecipients(Message.RecipientType.CC, (Address[])cc);
            }
            if (bcc != null) {
                msg.setRecipients(Message.RecipientType.BCC, (Address[])bcc);
            }
            msg.setSubject(subject);
            if (htmlFormat) {
                msg.setContent(body, _TEXT_HTML);
            } else {
                msg.setContent(body, _TEXT_PLAIN);
            }
            msg.setSentDate(new Date());
            if (replyTo != null) {
                msg.setReplyTo((Address[])replyTo);
            }
            if (messageId != null) {
                msg.setHeader("Message-ID", messageId);
            }
            if (inReplyTo != null) {
                msg.setHeader("In-Reply-To", inReplyTo);
            }
            MailEngine._send(session, (Message)msg);
        }
        catch (SendFailedException sfe) {
            _log.error((Object)sfe);
        }
        catch (Exception e) {
            throw new MailEngineException(e);
        }
        if (_log.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            _log.debug((Object)("Sending mail takes " + (end - start) + " ms"));
        }
    }

    public static void send(byte[] msgByteArray) throws MailEngineException {
        try {
            Session session = MailEngine.getSession();
            MimeMessage msg = new MimeMessage(session, (InputStream)new ByteArrayInputStream(msgByteArray));
            MailEngine._send(session, (Message)msg);
        }
        catch (Exception e) {
            throw new MailEngineException(e);
        }
    }

    private static final void _send(Session session, Message msg) throws MessagingException {
        boolean smtpAuth = GetterUtil.getBoolean(session.getProperty("mail.smtp.auth"), false);
        String smtpHost = session.getProperty("mail.smtp.host");
        String user = session.getProperty("mail.smtp.user");
        String password = session.getProperty("mail.smtp.password");
        if (smtpAuth && Validator.isNotNull(user) && Validator.isNotNull(password)) {
            Transport transport = session.getTransport("smtp");
            transport.connect(smtpHost, user, password);
            transport.sendMessage(msg, msg.getAllRecipients());
            transport.close();
        } else {
            Transport.send((Message)msg);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Class clazz = class$com$liferay$util$mail$MailEngine;
        if (clazz == null) {
            clazz = class$com$liferay$util$mail$MailEngine = MailEngine.class("[Lcom.liferay.util.mail.MailEngine;", false);
        }
        _log = LogFactory.getLog((Class)clazz);
    }
}

