/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.util.Randomizer;
import com.liferay.util.Validator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;

public class StringUtil {
    public static String add(String s, String add) {
        return StringUtil.add(s, add, ",");
    }

    public static String add(String s, String add, String delimiter) {
        return StringUtil.add(s, add, delimiter, false);
    }

    public static String add(String s, String add, String delimiter, boolean allowDuplicates) {
        if (add == null || delimiter == null) {
            return null;
        }
        if (s == null) {
            s = "";
        }
        if (allowDuplicates || !StringUtil.contains(s, add, delimiter)) {
            StringBuffer sb = new StringBuffer();
            sb.append(s);
            if (Validator.isNull(s) || s.endsWith(delimiter)) {
                sb.append(add);
                sb.append(delimiter);
            } else {
                sb.append(delimiter);
                sb.append(add);
                sb.append(delimiter);
            }
            s = sb.toString();
        }
        return s;
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        int i = 0;
        while (i < bytes.length) {
            String hex = Integer.toHexString(256 + (bytes[i] & 0xFF)).substring(1);
            if (hex.length() < 2) {
                sb.append("0");
            }
            sb.append(hex);
            ++i;
        }
        return sb.toString();
    }

    public static boolean contains(String s, String text) {
        return StringUtil.contains(s, text, ",");
    }

    public static boolean contains(String s, String text, String delimiter) {
        if (s == null || text == null || delimiter == null) {
            return false;
        }
        StringBuffer sb = null;
        if (!s.endsWith(delimiter)) {
            sb = new StringBuffer();
            sb.append(s);
            sb.append(delimiter);
            s = sb.toString();
        }
        sb = new StringBuffer();
        sb.append(delimiter);
        sb.append(text);
        sb.append(delimiter);
        String dtd = sb.toString();
        int pos = s.indexOf(dtd);
        if (pos == -1) {
            sb = new StringBuffer();
            sb.append(text);
            sb.append(delimiter);
            String td = sb.toString();
            return s.startsWith(td);
        }
        return true;
    }

    public static int count(String s, String text) {
        if (s == null || text == null) {
            return 0;
        }
        int count = 0;
        int pos = s.indexOf(text);
        while (pos != -1) {
            pos = s.indexOf(text, pos + text.length());
            ++count;
        }
        return count;
    }

    public static boolean endsWith(String s, char end) {
        return StringUtil.startsWith(s, new Character(end).toString());
    }

    public static boolean endsWith(String s, String end) {
        if (s == null || end == null) {
            return false;
        }
        if (end.length() > s.length()) {
            return false;
        }
        String temp = s.substring(s.length() - end.length(), s.length());
        return temp.equalsIgnoreCase(end);
    }

    public static String extractChars(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (Validator.isChar(c[i])) {
                sb.append(c[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String extractDigits(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (Validator.isDigit(c[i])) {
                sb.append(c[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String extractFirst(String s, String delimiter) {
        if (s == null) {
            return null;
        }
        String[] array = StringUtil.split(s, delimiter);
        if (array.length > 0) {
            return array[0];
        }
        return null;
    }

    public static String extractLast(String s, String delimiter) {
        if (s == null) {
            return null;
        }
        String[] array = StringUtil.split(s, delimiter);
        if (array.length > 0) {
            return array[array.length - 1];
        }
        return null;
    }

    public static String highlight(String s, String keywords) {
        return StringUtil.highlight(s, keywords, "<b>", "</b>");
    }

    public static String highlight(String s, String keywords, String highlight1, String highlight2) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(" ");
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase(keywords)) {
                sb.append(highlight1);
                sb.append(token);
                sb.append(highlight2);
            } else {
                sb.append(token);
            }
            if (!st.hasMoreTokens()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String lowerCase(String s) {
        if (s == null) {
            return null;
        }
        return s.toLowerCase();
    }

    public static String merge(List list) {
        return StringUtil.merge(list, ",");
    }

    public static String merge(List list, String delimiter) {
        return StringUtil.merge(list.toArray(new String[list.size()]), delimiter);
    }

    public static String merge(String[] array) {
        return StringUtil.merge(array, ",");
    }

    public static String merge(String[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            sb.append(array[i].trim());
            if (i + 1 != array.length) {
                sb.append(delimiter);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String randomize(String s) {
        return Randomizer.getInstance().randomize(s);
    }

    public static String read(ClassLoader classLoader, String name) throws IOException {
        return StringUtil.read(classLoader, name, false);
    }

    public static String read(ClassLoader classLoader, String name, boolean all) throws IOException {
        if (all) {
            StringBuffer sb = new StringBuffer();
            Enumeration<URL> enu = classLoader.getResources(name);
            while (enu.hasMoreElements()) {
                URL url = enu.nextElement();
                InputStream is = url.openStream();
                String s = StringUtil.read(is);
                if (s != null) {
                    sb.append(s);
                    sb.append("\n");
                }
                is.close();
            }
            return sb.toString().trim();
        }
        InputStream is = classLoader.getResourceAsStream(name);
        String s = StringUtil.read(is);
        is.close();
        return s;
    }

    public static String read(InputStream is) throws IOException {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line).append('\n');
        }
        br.close();
        return sb.toString().trim();
    }

    public static String remove(String s, String remove) {
        return StringUtil.remove(s, remove, ",");
    }

    public static String remove(String s, String remove, String delimiter) {
        if (s == null || remove == null || delimiter == null) {
            return null;
        }
        if (Validator.isNotNull(s) && !s.endsWith(delimiter)) {
            s = s + delimiter;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(delimiter);
        sb.append(remove);
        sb.append(delimiter);
        String drd = sb.toString();
        sb = new StringBuffer();
        sb.append(remove);
        sb.append(delimiter);
        String rd = sb.toString();
        while (StringUtil.contains(s, remove, delimiter)) {
            int y;
            int x;
            int pos = s.indexOf(drd);
            if (pos == -1) {
                if (!s.startsWith(rd)) continue;
                x = remove.length() + delimiter.length();
                y = s.length();
                s = s.substring(x, y);
                continue;
            }
            x = pos + remove.length() + delimiter.length();
            y = s.length();
            sb = new StringBuffer();
            sb.append(s.substring(0, pos));
            sb.append(s.substring(x, y));
            s = sb.toString();
        }
        return s;
    }

    public static String replace(String s, char oldSub, char newSub) {
        return StringUtil.replace(s, oldSub, new Character(newSub).toString());
    }

    public static String replace(String s, char oldSub, String newSub) {
        if (s == null || newSub == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (c[i] == oldSub) {
                sb.append(newSub);
            } else {
                sb.append(c[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String replace(String s, String oldSub, String newSub) {
        if (s == null || oldSub == null || newSub == null) {
            return null;
        }
        int y = s.indexOf(oldSub);
        if (y >= 0) {
            StringBuffer sb = new StringBuffer();
            int length = oldSub.length();
            int x = 0;
            while (x <= y) {
                sb.append(s.substring(x, y));
                sb.append(newSub);
                x = y + length;
                y = s.indexOf(oldSub, x);
            }
            sb.append(s.substring(x));
            return sb.toString();
        }
        return s;
    }

    public static String replace(String s, String[] oldSubs, String[] newSubs) {
        if (s == null || oldSubs == null || newSubs == null) {
            return null;
        }
        if (oldSubs.length != newSubs.length) {
            return s;
        }
        int i = 0;
        while (i < oldSubs.length) {
            s = StringUtil.replace(s, oldSubs[i], newSubs[i]);
            ++i;
        }
        return s;
    }

    public static String reverse(String s) {
        if (s == null) {
            return null;
        }
        char[] c = s.toCharArray();
        char[] reverse = new char[c.length];
        int i = 0;
        while (i < c.length) {
            reverse[i] = c[c.length - i - 1];
            ++i;
        }
        return new String(reverse);
    }

    public static String shorten(String s) {
        return StringUtil.shorten(s, 20);
    }

    public static String shorten(String s, int length) {
        return StringUtil.shorten(s, length, "...");
    }

    public static String shorten(String s, String suffix) {
        return StringUtil.shorten(s, 20, suffix);
    }

    public static String shorten(String s, int length, String suffix) {
        if (s == null || suffix == null) {
            return null;
        }
        if (s.length() > length) {
            int j = length;
            while (j >= 0) {
                if (Character.isWhitespace(s.charAt(j))) {
                    length = j;
                    break;
                }
                --j;
            }
            StringBuffer sb = new StringBuffer();
            sb.append(s.substring(0, length));
            sb.append(suffix);
            s = sb.toString();
        }
        return s;
    }

    public static String[] split(String s) {
        return StringUtil.split(s, ",");
    }

    public static String[] split(String s, String delimiter) {
        if (s == null || delimiter == null) {
            return new String[0];
        }
        if (!(s = s.trim()).endsWith(delimiter)) {
            StringBuffer sb = new StringBuffer();
            sb.append(s);
            sb.append(delimiter);
            s = sb.toString();
        }
        if (s.equals(delimiter)) {
            return new String[0];
        }
        ArrayList<String> nodeValues = new ArrayList<String>();
        if (delimiter.equals("\n") || delimiter.equals("\r")) {
            try {
                BufferedReader br = new BufferedReader(new StringReader(s));
                String line = null;
                while ((line = br.readLine()) != null) {
                    nodeValues.add(line);
                }
                br.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        } else {
            int offset = 0;
            int pos = s.indexOf(delimiter, offset);
            while (pos != -1) {
                nodeValues.add(new String(s.substring(offset, pos)));
                offset = pos + delimiter.length();
                pos = s.indexOf(delimiter, offset);
            }
        }
        return nodeValues.toArray(new String[nodeValues.size()]);
    }

    public static boolean[] split(String s, String delimiter, boolean x) {
        String[] array = StringUtil.split(s, delimiter);
        boolean[] newArray = new boolean[array.length];
        int i = 0;
        while (i < array.length) {
            boolean value = x;
            try {
                value = Boolean.valueOf(array[i]);
            }
            catch (Exception e) {
                // empty catch block
            }
            newArray[i] = value;
            ++i;
        }
        return newArray;
    }

    public static double[] split(String s, String delimiter, double x) {
        String[] array = StringUtil.split(s, delimiter);
        double[] newArray = new double[array.length];
        int i = 0;
        while (i < array.length) {
            double value = x;
            try {
                value = Double.parseDouble(array[i]);
            }
            catch (Exception e) {
                // empty catch block
            }
            newArray[i] = value;
            ++i;
        }
        return newArray;
    }

    public static float[] split(String s, String delimiter, float x) {
        String[] array = StringUtil.split(s, delimiter);
        float[] newArray = new float[array.length];
        int i = 0;
        while (i < array.length) {
            float value = x;
            try {
                value = Float.parseFloat(array[i]);
            }
            catch (Exception e) {
                // empty catch block
            }
            newArray[i] = value;
            ++i;
        }
        return newArray;
    }

    public static int[] split(String s, String delimiter, int x) {
        String[] array = StringUtil.split(s, delimiter);
        int[] newArray = new int[array.length];
        int i = 0;
        while (i < array.length) {
            int value = x;
            try {
                value = Integer.parseInt(array[i]);
            }
            catch (Exception e) {
                // empty catch block
            }
            newArray[i] = value;
            ++i;
        }
        return newArray;
    }

    public static long[] split(String s, String delimiter, long x) {
        String[] array = StringUtil.split(s, delimiter);
        long[] newArray = new long[array.length];
        int i = 0;
        while (i < array.length) {
            long value = x;
            try {
                value = Long.parseLong(array[i]);
            }
            catch (Exception e) {
                // empty catch block
            }
            newArray[i] = value;
            ++i;
        }
        return newArray;
    }

    public static short[] split(String s, String delimiter, short x) {
        String[] array = StringUtil.split(s, delimiter);
        short[] newArray = new short[array.length];
        int i = 0;
        while (i < array.length) {
            short value = x;
            try {
                value = Short.parseShort(array[i]);
            }
            catch (Exception e) {
                // empty catch block
            }
            newArray[i] = value;
            ++i;
        }
        return newArray;
    }

    public static boolean startsWith(String s, char begin) {
        return StringUtil.startsWith(s, new Character(begin).toString());
    }

    public static boolean startsWith(String s, String start) {
        if (s == null || start == null) {
            return false;
        }
        if (start.length() > s.length()) {
            return false;
        }
        String temp = s.substring(0, start.length());
        return temp.equalsIgnoreCase(start);
    }

    public static String trimLeading(String s) {
        int i = 0;
        while (i < s.length()) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return s.substring(i, s.length());
            }
            ++i;
        }
        return "";
    }

    public static String trimTrailing(String s) {
        int i = s.length() - 1;
        while (i >= 0) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return s.substring(0, i + 1);
            }
            --i;
        }
        return "";
    }

    public static String upperCase(String s) {
        if (s == null) {
            return null;
        }
        return s.toUpperCase();
    }

    public static String wrap(String text) {
        return StringUtil.wrap(text, 80, "\n");
    }

    public static String wrap(String text, int width, String lineSeparator) {
        if (text == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(new StringReader(text));
            String s = "";
            while ((s = br.readLine()) != null) {
                if (s.length() == 0) {
                    sb.append(lineSeparator);
                    continue;
                }
                String[] tokens = s.split(" ");
                boolean firstWord = true;
                int curLineLength = 0;
                int i = 0;
                while (i < tokens.length) {
                    if (!firstWord) {
                        sb.append(" ");
                        ++curLineLength;
                    }
                    if (firstWord) {
                        sb.append(lineSeparator);
                    }
                    sb.append(tokens[i]);
                    if ((curLineLength += tokens[i].length()) >= width) {
                        firstWord = true;
                        curLineLength = 0;
                    } else {
                        firstWord = false;
                    }
                    ++i;
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return sb.toString();
    }
}

