/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.util.StringUtil;
import com.liferay.util.UnicodeFormatter;
import com.liferay.util.Validator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class PropertiesUtil {
    public static void copyProperties(Properties from, Properties to) {
        Iterator<Map.Entry<Object, Object>> itr = from.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Object, Object> entry = itr.next();
            to.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static Properties fromMap(Map map) {
        if (map instanceof Properties) {
            return (Properties)map;
        }
        Properties p = new Properties();
        Iterator itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) continue;
            p.setProperty(key, value);
        }
        return p;
    }

    public static void fromProperties(Properties p, Map map) {
        map.clear();
        Iterator<Map.Entry<Object, Object>> itr = p.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Object, Object> entry = itr.next();
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static Properties load(String s) throws IOException {
        Properties p = new Properties();
        PropertiesUtil.load(p, s);
        return p;
    }

    public static void load(Properties p, String s) throws IOException {
        if (Validator.isNotNull(s)) {
            s = UnicodeFormatter.toString(s);
            s = StringUtil.replace(s, "\\u003d", "=");
            s = StringUtil.replace(s, "\\u000a", "\n");
            p.load(new ByteArrayInputStream(s.getBytes()));
            ArrayList<?> propertyNames = Collections.list(p.propertyNames());
            int i = 0;
            while (i < propertyNames.size()) {
                String key = (String)propertyNames.get(i);
                String value = p.getProperty(key);
                if (value != null) {
                    value = value.trim();
                    p.setProperty(key, value);
                }
                ++i;
            }
        }
    }

    public static void merge(Properties p1, Properties p2) {
        Enumeration<?> enu = p2.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            String value = p2.getProperty(key);
            p1.setProperty(key, value);
        }
    }

    public static String list(Map map) {
        Properties props = PropertiesUtil.fromMap(map);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        props.list(ps);
        return baos.toString();
    }

    public static void list(Map map, PrintStream out) {
        Properties props = PropertiesUtil.fromMap(map);
        props.list(out);
    }

    public static void list(Map map, PrintWriter out) {
        Properties props = PropertiesUtil.fromMap(map);
        props.list(out);
    }

    public static String toString(Properties p) {
        StringBuffer sb = new StringBuffer();
        Enumeration<?> enu = p.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            sb.append(key);
            sb.append("=");
            sb.append(p.getProperty(key));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void trimKeys(Properties p) {
        Enumeration<?> enu = p.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            String value = p.getProperty(key);
            String trimmedKey = key.trim();
            if (key.equals(trimmedKey)) continue;
            p.remove(key);
            p.setProperty(trimmedKey, value);
        }
    }
}

