/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.util.StringUtil;

public class Html {
    public static final String AMPERSAND = "&amp;";
    private static final char[] _TAG_SCRIPT = new char[]{'s', 'c', 'r', 'i', 'p', 't'};

    public static String escape(String text) {
        return Html.escape(text, true);
    }

    public static String escape(String text, boolean stripBlankSpaces) {
        if (text == null) {
            return null;
        }
        int pos = text.indexOf("& ");
        if (pos != -1) {
            text = StringUtil.replace(text, "& ", "&amp; ");
        }
        StringBuffer sb = new StringBuffer(text.length());
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '\'': {
                    sb.append("&#39;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case ',': {
                    sb.append("&#44;");
                    break;
                }
                case '\r': {
                    if (stripBlankSpaces) break;
                }
                case '\n': {
                    if (stripBlankSpaces) break;
                }
                case '\t': {
                    if (stripBlankSpaces) break;
                }
                default: {
                    if (c > '\u00ff') {
                        sb.append("&#").append((int)c).append(";");
                        break;
                    }
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String formatTo(String text) {
        return Html.escape(text, true);
    }

    public static String formatFrom(String text) {
        if (text == null) {
            return null;
        }
        text = StringUtil.replace(text, "&lt;", "<");
        text = StringUtil.replace(text, "&gt;", ">");
        text = StringUtil.replace(text, "&#34;", "\"");
        text = StringUtil.replace(text, "&#38;", "&");
        text = StringUtil.replace(text, "&#42;", "*");
        text = StringUtil.replace(text, "&#47;", "/");
        text = StringUtil.replace(text, "&#58;", ":");
        text = StringUtil.replace(text, "&#63;", "?");
        return text;
    }

    public static String fromInputSafe(String text) {
        return StringUtil.replace(text, AMPERSAND, "&");
    }

    public static String stripBetween(String text, String tag) {
        StringBuffer sb = new StringBuffer();
        String tagBegin = "<" + tag;
        String tagEnd = "</" + tag + '>';
        int x = 0;
        int y = text.indexOf(tagBegin);
        while (y != -1) {
            sb.append(text.substring(x, y));
            x = text.indexOf(tagEnd, y) + tagEnd.length();
            y = text.indexOf(tagBegin, x);
        }
        if (y == -1) {
            sb.append(text.substring(x, text.length()));
        }
        return sb.toString();
    }

    public static String stripComments(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(text.length());
        int x = 0;
        int y = text.indexOf("<!--");
        while (y != -1) {
            sb.append(text.substring(x, y));
            x = text.indexOf("-->", y) + 3;
            y = text.indexOf("<!--", x);
        }
        if (y == -1) {
            sb.append(text.substring(x, text.length()));
        }
        return sb.toString();
    }

    public static String stripHtml(String text) {
        if (text == null) {
            return null;
        }
        text = Html.stripComments(text);
        StringBuffer sb = new StringBuffer(text.length());
        int x = 0;
        int y = text.indexOf("<");
        while (y != -1) {
            sb.append(text.substring(x, y));
            boolean scriptFound = Html._isScriptTag(text, y + 1);
            if (scriptFound) {
                int pos = y + _TAG_SCRIPT.length;
                if ((pos = text.indexOf(">", pos)) >= 0 && text.charAt(pos - 1) != '/') {
                    while ((pos = text.indexOf("</", pos)) >= 0) {
                        if (Html._isScriptTag(text, pos + 2)) {
                            y = pos;
                            break;
                        }
                        pos += 2;
                    }
                }
            }
            if ((x = text.indexOf(">", y) + 1) < y) break;
            y = text.indexOf("<", x);
        }
        if (y == -1) {
            sb.append(text.substring(x, text.length()));
        }
        return sb.toString();
    }

    public static String toInputSafe(String text) {
        return StringUtil.replace(text, "&", AMPERSAND);
    }

    private static final boolean _isScriptTag(String text, int start) {
        int pos = start;
        if (pos + _TAG_SCRIPT.length + 1 <= text.length()) {
            char item;
            int i = 0;
            while (i < _TAG_SCRIPT.length) {
                if (Character.toLowerCase(item = text.charAt(pos++)) != _TAG_SCRIPT[i]) {
                    return false;
                }
                ++i;
            }
            item = text.charAt(pos);
            return Character.isLetter(item) ^ true;
        }
        return false;
    }
}

