/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.germinus.easyconf.ComponentConfiguration;
import com.germinus.easyconf.ComponentProperties;
import com.germinus.easyconf.EasyConf;
import com.liferay.util.CollectionFactory;
import com.liferay.util.Validator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ExtPropertiesLoader {
    private static Map _propsPool = CollectionFactory.getSyncHashMap();
    private static final String _COMPANY_ID_SEPARATOR = "_COMPANY_ID_";
    private ComponentConfiguration _conf;

    public static ExtPropertiesLoader getInstance(String name) {
        ExtPropertiesLoader props = (ExtPropertiesLoader)_propsPool.get(name);
        if (props == null) {
            props = new ExtPropertiesLoader(name);
            _propsPool.put(name, props);
        }
        return props;
    }

    public static ExtPropertiesLoader getInstance(String name, String companyId) {
        String key = name + _COMPANY_ID_SEPARATOR + companyId;
        ExtPropertiesLoader props = (ExtPropertiesLoader)_propsPool.get(key);
        if (props == null) {
            props = new ExtPropertiesLoader(name, companyId);
            _propsPool.put(key, props);
        }
        return props;
    }

    public boolean containsKey(String key) {
        return this.getComponentProperties().containsKey(key);
    }

    public String get(String key) {
        return this.getComponentProperties().getString(key);
    }

    public void set(String key, String value) {
        this.getComponentProperties().setProperty(key, (Object)value);
    }

    public String[] getArray(String key) {
        String[] array = this.getComponentProperties().getStringArray(key);
        if (array == null || array.length == 1 && Validator.isNull(array[0])) {
            array = new String[]{};
        }
        return array;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        ComponentProperties componentProps = this.getComponentProperties();
        Enumeration<?> enu = componentProps.getProperties().propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            props.setProperty(key, componentProps.getString(key));
        }
        return props;
    }

    public ComponentProperties getComponentProperties() {
        return this._conf.getProperties();
    }

    private final void _printSources(String name) {
        this._printSources(name, null);
    }

    private final void _printSources(String name, String companyId) {
        List sources = this.getComponentProperties().getLoadedSources();
        int i = sources.size() - 1;
        while (i >= 0) {
            String source = (String)sources.get(i);
            String info = "Loading " + source;
            if (companyId != null) {
                info = info + " for " + companyId;
            }
            System.out.println(info);
            --i;
        }
    }

    private ExtPropertiesLoader(String name) {
        this._conf = EasyConf.getConfiguration((String)name);
        this._printSources(name);
    }

    private ExtPropertiesLoader(String name, String companyId) {
        this._conf = EasyConf.getConfiguration((String)companyId, (String)name);
        this._printSources(name, companyId);
    }
}

