/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.quartz.utils.DirtyFlagMap;

public class JobDataMap
extends DirtyFlagMap
implements Serializable {
    private static final long serialVersionUID = -6939901990106713909L;
    private boolean allowsTransientData = false;

    public JobDataMap() {
        super(15);
    }

    public JobDataMap(Map map) {
        this();
        this.putAll(map);
    }

    public void setAllowsTransientData(boolean allowsTransientData) {
        if (this.containsTransientData() && !allowsTransientData) {
            throw new IllegalStateException("Cannot set property 'allowsTransientData' to 'false' when data map contains non-serializable objects.");
        }
        this.allowsTransientData = allowsTransientData;
    }

    public boolean getAllowsTransientData() {
        return this.allowsTransientData;
    }

    public boolean containsTransientData() {
        if (!this.getAllowsTransientData()) {
            return false;
        }
        String[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            Object o = super.get(keys[i]);
            if (o instanceof Serializable) continue;
            return true;
        }
        return false;
    }

    public void removeTransientData() {
        if (!this.getAllowsTransientData()) {
            return;
        }
        String[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            Object o = super.get(keys[i]);
            if (o instanceof Serializable) continue;
            this.remove(keys[i]);
        }
    }

    public void putAll(Map map) {
        Iterator itr = map.keySet().iterator();
        while (itr.hasNext()) {
            Object key = itr.next();
            Object val = map.get(key);
            this.put(key, val);
        }
    }

    public void put(String key, int value) {
        super.put(key, new Integer(value));
    }

    public void put(String key, long value) {
        super.put(key, new Long(value));
    }

    public void put(String key, float value) {
        super.put(key, new Float(value));
    }

    public void put(String key, double value) {
        super.put(key, new Double(value));
    }

    public void put(String key, boolean value) {
        super.put(key, new Boolean(value));
    }

    public void put(String key, char value) {
        super.put(key, new Character(value));
    }

    public void put(String key, String value) {
        super.put(key, value);
    }

    public void putAsString(String key, boolean value) {
        String strValue = new Boolean(value).toString();
        super.put(key, strValue);
    }

    public void putAsString(String key, Boolean value) {
        String strValue = value.toString();
        super.put(key, strValue);
    }

    public void putAsString(String key, char value) {
        String strValue = new Character(value).toString();
        super.put(key, strValue);
    }

    public void putAsString(String key, Character value) {
        String strValue = value.toString();
        super.put(key, strValue);
    }

    public void putAsString(String key, double value) {
        String strValue = new Double(value).toString();
        super.put(key, strValue);
    }

    public void putAsString(String key, Double value) {
        String strValue = value.toString();
        super.put(key, strValue);
    }

    public void putAsString(String key, float value) {
        String strValue = new Float(value).toString();
        super.put(key, strValue);
    }

    public void putAsString(String key, Float value) {
        String strValue = value.toString();
        super.put(key, strValue);
    }

    public void putAsString(String key, int value) {
        String strValue = new Integer(value).toString();
        super.put(key, strValue);
    }

    public void putAsString(String key, Integer value) {
        String strValue = value.toString();
        super.put(key, strValue);
    }

    public void putAsString(String key, long value) {
        String strValue = new Long(value).toString();
        super.put(key, strValue);
    }

    public void putAsString(String key, Long value) {
        String strValue = value.toString();
        super.put(key, strValue);
    }

    public Object put(Object key, Object value) {
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("Keys in map must be Strings.");
        }
        return super.put(key, value);
    }

    public int getInt(String key) {
        Object obj = this.get(key);
        try {
            return (Integer)obj;
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not an Integer.");
        }
    }

    public long getLong(String key) {
        Object obj = this.get(key);
        try {
            return (Long)obj;
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a Long.");
        }
    }

    public float getFloat(String key) {
        Object obj = this.get(key);
        try {
            return ((Float)obj).floatValue();
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a Float.");
        }
    }

    public double getDouble(String key) {
        Object obj = this.get(key);
        try {
            return (Double)obj;
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a Double.");
        }
    }

    public boolean getBoolean(String key) {
        Object obj = this.get(key);
        try {
            return (Boolean)obj;
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a Boolean.");
        }
    }

    public char getChar(String key) {
        Object obj = this.get(key);
        try {
            return ((Character)obj).charValue();
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a Character.");
        }
    }

    public String getString(String key) {
        Object obj = this.get(key);
        try {
            return (String)obj;
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a String.");
        }
    }

    public int getIntFromString(String key) {
        Object obj = this.get(key);
        return new Integer((String)obj);
    }

    public Integer getIntegerFromString(String key) {
        Object obj = this.get(key);
        return new Integer((String)obj);
    }

    public boolean getBooleanValueFromString(String key) {
        Object obj = this.get(key);
        return new Boolean((String)obj);
    }

    public Boolean getBooleanFromString(String key) {
        Object obj = this.get(key);
        return new Boolean((String)obj);
    }

    public char getCharFromString(String key) {
        Object obj = this.get(key);
        return ((String)obj).charAt(0);
    }

    public Character getCharacterFromString(String key) {
        Object obj = this.get(key);
        return new Character(((String)obj).charAt(0));
    }

    public double getDoubleValueFromString(String key) {
        Object obj = this.get(key);
        return new Double((String)obj);
    }

    public Double getDoubleFromString(String key) {
        Object obj = this.get(key);
        return new Double((String)obj);
    }

    public float getFloatValueFromString(String key) {
        Object obj = this.get(key);
        return new Float((String)obj).floatValue();
    }

    public Float getFloatFromString(String key) {
        Object obj = this.get(key);
        return new Float((String)obj);
    }

    public long getLongValueFromString(String key) {
        Object obj = this.get(key);
        return new Long((String)obj);
    }

    public Long getLongFromString(String key) {
        Object obj = this.get(key);
        return new Long((String)obj);
    }

    public String[] getKeys() {
        return this.keySet().toArray(new String[this.size()]);
    }
}

