/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce;

import java.math.BigInteger;
import java.security.spec.ECFieldFp;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import org.bouncycastle.math.ec.ECFieldElement;

public class ECPointUtil {
    public static ECPoint decodePoint(EllipticCurve ellipticCurve, byte[] byArray) {
        ECPoint eCPoint = null;
        switch (byArray[0]) {
            case 2: 
            case 3: {
                int n;
                int n2 = byArray[0] & 1;
                byte[] byArray2 = new byte[byArray.length - 1];
                System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
                BigInteger bigInteger = ((ECFieldFp)ellipticCurve.getField()).getP();
                ECFieldElement.Fp fp = new ECFieldElement.Fp(bigInteger, new BigInteger(1, byArray2));
                ECFieldElement.Fp fp2 = new ECFieldElement.Fp(bigInteger, ellipticCurve.getA());
                ECFieldElement.Fp fp3 = new ECFieldElement.Fp(bigInteger, ellipticCurve.getB());
                ECFieldElement eCFieldElement = ((ECFieldElement)fp).multiply(((ECFieldElement)fp).square()).add(((ECFieldElement)fp).multiply(fp2).add(fp3));
                BigInteger bigInteger2 = eCFieldElement.sqrt().toBigInteger();
                if (bigInteger2 == null) {
                    throw new RuntimeException("Invalid point compression");
                }
                int n3 = n = bigInteger2.testBit(0) ? 0 : 1;
                if (n == n2) {
                    eCPoint = new ECPoint(fp.toBigInteger(), bigInteger2);
                    break;
                }
                eCPoint = new ECPoint(fp.toBigInteger(), bigInteger.subtract(bigInteger2));
                break;
            }
            case 4: {
                byte[] byArray3 = new byte[(byArray.length - 1) / 2];
                byte[] byArray4 = new byte[(byArray.length - 1) / 2];
                System.arraycopy(byArray, 1, byArray3, 0, byArray3.length);
                System.arraycopy(byArray, byArray3.length + 1, byArray4, 0, byArray4.length);
                eCPoint = new ECPoint(new BigInteger(1, byArray3), new BigInteger(1, byArray4));
                break;
            }
            default: {
                throw new RuntimeException("Invalid point encoding 0x" + Integer.toString(byArray[0], 16));
            }
        }
        return eCPoint;
    }
}

