/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.lucene;

import com.liferay.util.StringUtil;

public class KeywordsUtil {
    public static final String[] SPECIAL = new String[]{"+", "-", "&&", "||", "!", "(", ")", "{", "}", "[", "]", "^", "\"", "~", "*", "?", ":", "\\"};

    public static String escape(String text) {
        int i = SPECIAL.length - 1;
        while (i >= 0) {
            text = StringUtil.replace(text, SPECIAL[i], "\\" + SPECIAL[i]);
            --i;
        }
        return text;
    }

    public static String toFuzzy(String keywords) {
        if (keywords == null) {
            return null;
        }
        if (!keywords.endsWith("~")) {
            keywords = keywords + '~';
        }
        return keywords;
    }

    public static String toWildcard(String keywords) {
        if (keywords == null) {
            return null;
        }
        if (!keywords.endsWith("*")) {
            keywords = keywords + '*';
        }
        return keywords;
    }
}

