/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.util.StringUtil;
import com.liferay.util.Validator;
import java.text.NumberFormat;
import java.util.Locale;

public class TextFormatter {
    public static final int A = 0;
    public static final int B = 1;
    public static final int C = 2;
    public static final int D = 3;
    public static final int E = 4;
    public static final int F = 5;
    public static final int G = 6;
    public static final int H = 7;
    public static final int I = 8;
    public static final int J = 9;

    public static String format(String s, int style) {
        if (Validator.isNull(s)) {
            return null;
        }
        s = s.trim();
        if (style == 0) {
            return TextFormatter._formatA(s);
        }
        if (style == 1) {
            return TextFormatter._formatB(s);
        }
        if (style == 2) {
            return TextFormatter._formatC(s);
        }
        if (style == 3) {
            return TextFormatter._formatD(s);
        }
        if (style == 4) {
            return TextFormatter._formatE(s);
        }
        if (style == 5) {
            return TextFormatter._formatF(s);
        }
        if (style == 6) {
            return TextFormatter._formatG(s);
        }
        if (style == 7) {
            return TextFormatter._formatH(s);
        }
        if (style == 8) {
            return TextFormatter._formatI(s);
        }
        if (style == 9) {
            return TextFormatter._formatJ(s);
        }
        return s;
    }

    public static String formatKB(double size, Locale locale) {
        NumberFormat nf = NumberFormat.getInstance(locale);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        return nf.format(size / 1024.0);
    }

    public static String formatKB(int size, Locale locale) {
        return TextFormatter.formatKB((double)size, locale);
    }

    public static String formatName(String name) {
        if (Validator.isNull(name)) {
            return name;
        }
        char[] c = name.toLowerCase().trim().toCharArray();
        if (c.length > 0) {
            c[0] = Character.toUpperCase(c[0]);
        }
        int i = 0;
        while (i < c.length) {
            if (c[i] == ' ') {
                c[i + 1] = Character.toUpperCase(c[i + 1]);
            }
            ++i;
        }
        return new String(c);
    }

    public static String formatPlural(String s) {
        if (Validator.isNull(s)) {
            return s;
        }
        s = s.endsWith("y") ? s.substring(0, s.length() - 1) + "ies" : s + 's';
        return s;
    }

    private static final String _formatA(String s) {
        return StringUtil.replace(s.toUpperCase(), ' ', '_');
    }

    private static final String _formatB(String s) {
        return StringUtil.replace(s.toLowerCase(), ' ', "");
    }

    private static final String _formatC(String s) {
        return StringUtil.replace(s.toLowerCase(), ' ', '_');
    }

    private static final String _formatD(String s) {
        return StringUtil.replace(s, ' ', "");
    }

    private static final String _formatE(String s) {
        return s.toLowerCase();
    }

    private static final String _formatF(String s) {
        s = StringUtil.replace(s, ' ', "");
        s = Character.toLowerCase(s.charAt(0)) + s.substring(1, s.length());
        return s;
    }

    private static final String _formatG(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1, s.length());
    }

    private static final String _formatH(String s) {
        StringBuffer sb = new StringBuffer();
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (Character.isUpperCase(c[i])) {
                sb.append(" ").append(Character.toLowerCase(c[i]));
            } else {
                sb.append(c[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    private static final String _formatI(String s) {
        if (s.length() == 1) {
            return s.toLowerCase();
        }
        if (Character.isUpperCase(s.charAt(0)) && Character.isLowerCase(s.charAt(1))) {
            return Character.toLowerCase(s.charAt(0)) + s.substring(1, s.length());
        }
        StringBuffer sb = new StringBuffer();
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (i + 1 != c.length && Character.isLowerCase(c[i + 1])) {
                sb.append(s.substring(i, c.length));
                break;
            }
            sb.append(Character.toLowerCase(c[i]));
            ++i;
        }
        return sb.toString();
    }

    private static final String _formatJ(String s) {
        StringBuffer sb = new StringBuffer();
        s = StringUtil.replace(s, "-", " ");
        s = StringUtil.replace(s, "_", " ");
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (i == 0 || c[i - 1] == ' ') {
                sb.append(Character.toUpperCase(c[i]));
            } else {
                sb.append(Character.toLowerCase(c[i]));
            }
            ++i;
        }
        return sb.toString();
    }
}

