/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.util.GetterUtil;
import com.liferay.util.StringUtil;
import com.liferay.util.SystemProperties;
import com.liferay.util.Validator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.portlet.ActionRequest;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Http {
    public static final String FILE_ENCODING = "file.encoding";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String HTTP_WITH_SLASH = "http://";
    public static final String HTTPS_WITH_SLASH = "https://";
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    public static final String LIFERAY_PROXY_HOST;
    public static final int LIFERAY_PROXY_PORT;
    public static final String PROXY_HOST;
    public static final int PROXY_PORT;
    public static final String PROXY_AUTH_TYPE;
    public static final String PROXY_USERNAME;
    public static final String PROXY_PASSWORD;
    public static final String PROXY_NTLM_DOMAIN;
    public static final String PROXY_NTLM_HOST;
    public static final int TIMEOUT;
    private static Log _log;
    static /* synthetic */ Class class$com$liferay$util$Http;

    public static String addParameter(String url, String name, String value) {
        if (url == null) {
            return null;
        }
        if (url.indexOf("?") == -1) {
            url = url + '?';
        }
        if (!url.endsWith("?") && !url.endsWith("&")) {
            url = url + '&';
        }
        return url + name + '=' + Http.encodeURL(value);
    }

    public static String decodeURL(String url) {
        if (url == null) {
            return null;
        }
        try {
            return URLDecoder.decode(url, SystemProperties.get(FILE_ENCODING));
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            return "";
        }
    }

    public static String encodeURL(String url) {
        if (url == null) {
            return null;
        }
        try {
            return URLEncoder.encode(url, SystemProperties.get(FILE_ENCODING));
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            return "";
        }
    }

    public static String getCompleteURL(HttpServletRequest req) {
        StringBuffer completeURL = req.getRequestURL();
        if (completeURL == null) {
            completeURL = new StringBuffer();
        }
        if (req.getQueryString() != null) {
            completeURL.append("?");
            completeURL.append(req.getQueryString());
        }
        return completeURL.toString();
    }

    public static String getParameter(String url, String name) {
        return Http.getParameter(url, name, true);
    }

    public static String getParameter(String url, String name, boolean escaped) {
        if (Validator.isNull(url) || Validator.isNull(name)) {
            return "";
        }
        String[] parts = StringUtil.split(url, "?");
        if (parts.length == 2) {
            String[] params = null;
            params = escaped ? StringUtil.split(parts[1], "&amp;") : StringUtil.split(parts[1], "&");
            int i = 0;
            while (i < params.length) {
                String[] kvp = StringUtil.split(params[i], "=");
                if (kvp.length == 2 && kvp[0].equals(name)) {
                    return kvp[1];
                }
                ++i;
            }
        }
        return "";
    }

    public static Map getParameterMap(String queryString) {
        String key;
        LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
        if (Validator.isNull(queryString)) {
            return parameterMap;
        }
        StringTokenizer st = new StringTokenizer(queryString, "&");
        while (st.hasMoreTokens()) {
            ArrayList<String> values;
            String token = st.nextToken();
            if (!Validator.isNotNull(token)) continue;
            String[] kvp = StringUtil.split(token, "=");
            key = kvp[0];
            String value = "";
            if (kvp.length > 1) {
                value = kvp[1];
            }
            if ((values = (ArrayList<String>)parameterMap.get(key)) == null) {
                values = new ArrayList<String>();
                parameterMap.put(key, values);
            }
            values.add(value);
        }
        Iterator itr = parameterMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            key = (String)entry.getKey();
            List values = (List)entry.getValue();
            parameterMap.put(key, values.toArray(new String[0]));
        }
        return parameterMap;
    }

    public static String getProtocol(boolean secure) {
        if (!secure) {
            return HTTP;
        }
        return HTTPS;
    }

    public static String getProtocol(HttpServletRequest req) {
        return Http.getProtocol(req.isSecure());
    }

    public static String getProtocol(ActionRequest req) {
        return Http.getProtocol(req.isSecure());
    }

    public static String getProtocol(RenderRequest req) {
        return Http.getProtocol(req.isSecure());
    }

    public static String getRequestURL(HttpServletRequest req) {
        return req.getRequestURL().toString();
    }

    public static String parameterMapToString(Map parameterMap) {
        return Http.parameterMapToString(parameterMap, true);
    }

    public static String parameterMapToString(Map parameterMap, boolean addQuestion) {
        StringBuffer sb = new StringBuffer();
        if (parameterMap.size() > 0) {
            if (addQuestion) {
                sb.append("?");
            }
            Iterator itr = parameterMap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                String name = (String)entry.getKey();
                String[] values = (String[])entry.getValue();
                int i = 0;
                while (i < values.length) {
                    sb.append(name);
                    sb.append("=");
                    sb.append(Http.encodeURL(values[i]));
                    sb.append("&");
                    ++i;
                }
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String protocolize(String url, boolean secure) {
        if (secure) {
            if (url.startsWith(HTTP_WITH_SLASH)) {
                return StringUtil.replace(url, HTTP_WITH_SLASH, HTTPS_WITH_SLASH);
            }
        } else if (url.startsWith(HTTPS_WITH_SLASH)) {
            return StringUtil.replace(url, HTTPS_WITH_SLASH, HTTP_WITH_SLASH);
        }
        return url;
    }

    public static String protocolize(String url, HttpServletRequest req) {
        return Http.protocolize(url, req.isSecure());
    }

    public static String protocolize(String url, ActionRequest req) {
        return Http.protocolize(url, req.isSecure());
    }

    public static String protocolize(String url, RenderRequest req) {
        return Http.protocolize(url, req.isSecure());
    }

    public static void submit(String location) throws IOException {
        Http.submit(location, null);
    }

    public static void submit(String location, Cookie[] cookies) throws IOException {
        Http.submit(location, cookies, false);
    }

    public static void submit(String location, boolean post) throws IOException {
        Http.submit(location, null, post);
    }

    public static void submit(String location, Cookie[] cookies, boolean post) throws IOException {
        Http.URLtoByteArray(location, cookies, post);
    }

    public static void submit(String location, Cookie[] cookies, Map parts, boolean post) throws IOException {
        Http.URLtoByteArray(location, cookies, parts, post);
    }

    public static byte[] URLtoByteArray(String location) throws IOException {
        return Http.URLtoByteArray(location, null);
    }

    public static byte[] URLtoByteArray(String location, Cookie[] cookies) throws IOException {
        return Http.URLtoByteArray(location, cookies, false);
    }

    public static byte[] URLtoByteArray(String location, boolean post) throws IOException {
        return Http.URLtoByteArray(location, null, post);
    }

    public static byte[] URLtoByteArray(String location, Cookie[] cookies, boolean post) throws IOException {
        return Http.URLtoByteArray(location, cookies, null, post);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] URLtoByteArray(String location, Cookie[] cookies, Map parts, boolean post) throws IOException {
        byte[] byArray;
        PostMethod method;
        byte[] byteArray;
        block29: {
            HttpClient client;
            block27: {
                byteArray = null;
                method = null;
                client = new HttpClient((HttpConnectionManager)new SimpleHttpConnectionManager());
                if (location != null) break block27;
                byte[] byArray2 = byteArray;
                Object var7_10 = null;
                try {
                    if (method != null) {
                        method.releaseConnection();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return byArray2;
            }
            if (!location.startsWith(HTTP_WITH_SLASH) && !location.startsWith(HTTPS_WITH_SLASH)) {
                location = HTTP_WITH_SLASH + location;
            }
            HostConfiguration hostConfig = new HostConfiguration();
            hostConfig.setHost(new URI(location));
            if (Validator.isNotNull(PROXY_HOST) && PROXY_PORT > 0) {
                hostConfig.setProxy(PROXY_HOST, PROXY_PORT);
                if (Validator.isNotNull(PROXY_USERNAME)) {
                    UsernamePasswordCredentials credentials = null;
                    if (PROXY_AUTH_TYPE.equals("username-password")) {
                        credentials = new UsernamePasswordCredentials(PROXY_USERNAME, PROXY_PASSWORD);
                    } else if (PROXY_AUTH_TYPE.equals("ntlm")) {
                        credentials = new NTCredentials(PROXY_USERNAME, PROXY_PASSWORD, PROXY_NTLM_HOST, PROXY_NTLM_DOMAIN);
                        ArrayList<String> authPrefs = new ArrayList<String>();
                        authPrefs.add("NTLM");
                        authPrefs.add("Basic");
                        authPrefs.add("Digest");
                        client.getParams().setParameter("http.auth.scheme-priority", authPrefs);
                    }
                    client.getState().setProxyCredentials(new AuthScope(PROXY_HOST, PROXY_PORT, null), (Credentials)credentials);
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Location is " + location));
            }
            client.setHostConfiguration(hostConfig);
            client.setConnectionTimeout(TIMEOUT);
            client.setTimeout(TIMEOUT);
            if (cookies != null && cookies.length > 0) {
                HttpState state = new HttpState();
                state.addCookies(cookies);
                state.setCookiePolicy(0);
                client.setState(state);
            }
            if (post) {
                method = new PostMethod(location);
                if (parts != null && parts.size() > 0) {
                    ArrayList<StringPart> partsList = new ArrayList<StringPart>();
                    Iterator itr = parts.entrySet().iterator();
                    while (itr.hasNext()) {
                        Map.Entry entry = itr.next();
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        if (value == null) continue;
                        partsList.add(new StringPart(key, value));
                    }
                    PostMethod postMethod = method;
                    MultipartRequestEntity requestEntity = new MultipartRequestEntity((Part[])partsList.toArray(new StringPart[0]), method.getParams());
                    postMethod.setRequestEntity((RequestEntity)requestEntity);
                }
            } else {
                method = new GetMethod(location);
            }
            client.executeMethod((HttpMethod)method);
            Header locationHeader = method.getResponseHeader("location");
            if (locationHeader == null) break block29;
            byte[] byArray3 = Http.URLtoByteArray(locationHeader.getValue(), cookies, post);
            Object var7_11 = null;
            try {
                if (method != null) {
                    method.releaseConnection();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return byArray3;
        }
        try {
            InputStream is = method.getResponseBodyAsStream();
            if (is != null) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] bytes = new byte[512];
                int i = is.read(bytes, 0, 512);
                while (i != -1) {
                    buffer.write(bytes, 0, i);
                    i = is.read(bytes, 0, 512);
                }
                byteArray = buffer.toByteArray();
                is.close();
                buffer.close();
            }
            byArray = byteArray;
            Object var7_12 = null;
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            try {
                if (method != null) {
                    method.releaseConnection();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            if (method != null) {
                method.releaseConnection();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return byArray;
    }

    public static String URLtoString(String location) throws IOException {
        return Http.URLtoString(location, null);
    }

    public static String URLtoString(String location, Cookie[] cookies) throws IOException {
        return Http.URLtoString(location, cookies, false);
    }

    public static String URLtoString(String location, boolean post) throws IOException {
        return Http.URLtoString(location, null, post);
    }

    public static String URLtoString(String location, Cookie[] cookies, boolean post) throws IOException {
        return new String(Http.URLtoByteArray(location, cookies, post));
    }

    public static String URLtoString(String location, Cookie[] cookies, Map parts, boolean post) throws IOException {
        return new String(Http.URLtoByteArray(location, cookies, parts, post));
    }

    public static String URLtoString(URL url) throws IOException {
        String xml = null;
        if (url != null) {
            URLConnection con = url.openConnection();
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setRequestProperty("User-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)");
            InputStream is = con.getInputStream();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] bytes = new byte[512];
            int i = is.read(bytes, 0, 512);
            while (i != -1) {
                buffer.write(bytes, 0, i);
                i = is.read(bytes, 0, 512);
            }
            xml = new String(buffer.toByteArray());
            is.close();
            buffer.close();
        }
        return xml;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = class$com$liferay$util$Http;
        if (clazz == null) {
            clazz = class$com$liferay$util$Http = Http.class("[Lcom.liferay.util.Http;", false);
        }
        LIFERAY_PROXY_HOST = GetterUtil.getString(SystemProperties.get(stringBuffer.append(clazz.getName()).append(".proxy.host").toString()));
        StringBuffer stringBuffer2 = new StringBuffer();
        Class clazz2 = class$com$liferay$util$Http;
        if (clazz2 == null) {
            clazz2 = class$com$liferay$util$Http = Http.class("[Lcom.liferay.util.Http;", false);
        }
        LIFERAY_PROXY_PORT = GetterUtil.getInteger(SystemProperties.get(stringBuffer2.append(clazz2.getName()).append(".proxy.port").toString()));
        PROXY_HOST = GetterUtil.getString(SystemProperties.get("http.proxyHost"), LIFERAY_PROXY_HOST);
        PROXY_PORT = GetterUtil.getInteger(SystemProperties.get("http.proxyPort"), LIFERAY_PROXY_PORT);
        StringBuffer stringBuffer3 = new StringBuffer();
        Class clazz3 = class$com$liferay$util$Http;
        if (clazz3 == null) {
            clazz3 = class$com$liferay$util$Http = Http.class("[Lcom.liferay.util.Http;", false);
        }
        PROXY_AUTH_TYPE = GetterUtil.getString(SystemProperties.get(stringBuffer3.append(clazz3.getName()).append(".proxy.auth.type").toString()));
        StringBuffer stringBuffer4 = new StringBuffer();
        Class clazz4 = class$com$liferay$util$Http;
        if (clazz4 == null) {
            clazz4 = class$com$liferay$util$Http = Http.class("[Lcom.liferay.util.Http;", false);
        }
        PROXY_USERNAME = GetterUtil.getString(SystemProperties.get(stringBuffer4.append(clazz4.getName()).append(".proxy.username").toString()));
        StringBuffer stringBuffer5 = new StringBuffer();
        Class clazz5 = class$com$liferay$util$Http;
        if (clazz5 == null) {
            clazz5 = class$com$liferay$util$Http = Http.class("[Lcom.liferay.util.Http;", false);
        }
        PROXY_PASSWORD = GetterUtil.getString(SystemProperties.get(stringBuffer5.append(clazz5.getName()).append(".proxy.password").toString()));
        StringBuffer stringBuffer6 = new StringBuffer();
        Class clazz6 = class$com$liferay$util$Http;
        if (clazz6 == null) {
            clazz6 = class$com$liferay$util$Http = Http.class("[Lcom.liferay.util.Http;", false);
        }
        PROXY_NTLM_DOMAIN = GetterUtil.getString(SystemProperties.get(stringBuffer6.append(clazz6.getName()).append(".proxy.ntlm.domain").toString()));
        StringBuffer stringBuffer7 = new StringBuffer();
        Class clazz7 = class$com$liferay$util$Http;
        if (clazz7 == null) {
            clazz7 = class$com$liferay$util$Http = Http.class("[Lcom.liferay.util.Http;", false);
        }
        PROXY_NTLM_HOST = GetterUtil.getString(SystemProperties.get(stringBuffer7.append(clazz7.getName()).append(".proxy.ntlm.host").toString()));
        StringBuffer stringBuffer8 = new StringBuffer();
        Class clazz8 = class$com$liferay$util$Http;
        if (clazz8 == null) {
            clazz8 = class$com$liferay$util$Http = Http.class("[Lcom.liferay.util.Http;", false);
        }
        TIMEOUT = GetterUtil.getInteger(SystemProperties.get(stringBuffer8.append(clazz8.getName()).append(".timeout").toString()), 5000);
        Class clazz9 = class$com$liferay$util$Http;
        if (clazz9 == null) {
            clazz9 = class$com$liferay$util$Http = Http.class("[Lcom.liferay.util.Http;", false);
        }
        _log = LogFactory.getLog((Class)clazz9);
    }
}

