/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.util.StringUtil;
import java.text.DateFormat;
import java.util.Date;

public class GetterUtil {
    public static final boolean DEFAULT_BOOLEAN = false;
    public static final double DEFAULT_DOUBLE = 0.0;
    public static final float DEFAULT_FLOAT = 0.0f;
    public static final int DEFAULT_INTEGER = 0;
    public static final long DEFAULT_LONG = 0L;
    public static final short DEFAULT_SHORT = 0;
    public static final String DEFAULT_STRING = "";
    public static String[] BOOLEANS = new String[]{"true", "t", "y", "on", "1"};

    public static boolean getBoolean(String value) {
        return GetterUtil.getBoolean(value, false);
    }

    public static boolean getBoolean(String value, boolean defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static Date getDate(String value, DateFormat df) {
        return GetterUtil.getDate(value, df, new Date());
    }

    public static Date getDate(String value, DateFormat df, Date defaultValue) {
        return GetterUtil.get(value, df, defaultValue);
    }

    public static double getDouble(String value) {
        return GetterUtil.getDouble(value, 0.0);
    }

    public static double getDouble(String value, double defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static float getFloat(String value) {
        return GetterUtil.getFloat(value, 0.0f);
    }

    public static float getFloat(String value, float defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static int getInteger(String value) {
        return GetterUtil.getInteger(value, 0);
    }

    public static int getInteger(String value, int defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static long getLong(String value) {
        return GetterUtil.getLong(value, 0L);
    }

    public static long getLong(String value, long defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static short getShort(String value) {
        return GetterUtil.getShort(value, (short)0);
    }

    public static short getShort(String value, short defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static String getString(String value) {
        return GetterUtil.getString(value, DEFAULT_STRING);
    }

    public static String getString(String value, String defaultValue) {
        return GetterUtil.get(value, defaultValue);
    }

    public static boolean get(String value, boolean defaultValue) {
        if (value != null) {
            try {
                value = value.trim();
                return value.equalsIgnoreCase(BOOLEANS[0]) || value.equalsIgnoreCase(BOOLEANS[1]) || value.equalsIgnoreCase(BOOLEANS[2]) || value.equalsIgnoreCase(BOOLEANS[3]) || value.equalsIgnoreCase(BOOLEANS[4]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Date get(String value, DateFormat df, Date defaultValue) {
        try {
            Date date = df.parse(value.trim());
            if (date != null) {
                return date;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static double get(String value, double defaultValue) {
        try {
            return Double.parseDouble(GetterUtil._trim(value));
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static float get(String value, float defaultValue) {
        try {
            return Float.parseFloat(GetterUtil._trim(value));
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static int get(String value, int defaultValue) {
        try {
            return Integer.parseInt(GetterUtil._trim(value));
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static long get(String value, long defaultValue) {
        try {
            return Long.parseLong(GetterUtil._trim(value));
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static short get(String value, short defaultValue) {
        try {
            return Short.parseShort(GetterUtil._trim(value));
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static String get(String value, String defaultValue) {
        if (value != null) {
            value = value.trim();
            value = StringUtil.replace(value, "\r\n", "\n");
            return value;
        }
        return defaultValue;
    }

    private static final String _trim(String value) {
        if (value != null) {
            value = value.trim();
            StringBuffer sb = new StringBuffer();
            char[] charArray = value.toCharArray();
            int i = 0;
            while (i < charArray.length) {
                if (Character.isDigit(charArray[i]) || charArray[i] == '-' && i == 0 || charArray[i] == '.') {
                    sb.append(charArray[i]);
                }
                ++i;
            }
            value = sb.toString();
        }
        return value;
    }
}

