/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.util.FileComparator;
import com.liferay.util.StringUtil;
import com.liferay.util.Validator;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class FileUtil {
    public static void copyDirectory(String sourceDirName, String destinationDirName) {
        FileUtil.copyDirectory(new File(sourceDirName), new File(destinationDirName));
    }

    public static void copyDirectory(File source, File destination) {
        if (source.exists() && source.isDirectory()) {
            if (!destination.exists()) {
                destination.mkdirs();
            }
            File[] fileArray = source.listFiles();
            int i = 0;
            while (i < fileArray.length) {
                if (fileArray[i].isDirectory()) {
                    FileUtil.copyDirectory(fileArray[i], new File(destination.getPath() + File.separator + fileArray[i].getName()));
                } else {
                    FileUtil.copyFile(fileArray[i], new File(destination.getPath() + File.separator + fileArray[i].getName()));
                }
                ++i;
            }
        }
    }

    public static void copyFile(String source, String destination) {
        FileUtil.copyFile(source, destination, false);
    }

    public static void copyFile(String source, String destination, boolean lazy) {
        FileUtil.copyFile(new File(source), new File(destination), lazy);
    }

    public static void copyFile(File source, File destination) {
        FileUtil.copyFile(source, destination, false);
    }

    public static void copyFile(File source, File destination, boolean lazy) {
        if (!source.exists()) {
            return;
        }
        if (lazy) {
            String oldContent = null;
            try {
                oldContent = FileUtil.read(source);
            }
            catch (Exception e) {
                return;
            }
            String newContent = null;
            try {
                newContent = FileUtil.read(destination);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (oldContent == null || !oldContent.equals(newContent)) {
                FileUtil.copyFile(source, destination, false);
            }
        } else {
            if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
                destination.getParentFile().mkdirs();
            }
            try {
                FileChannel srcChannel = new FileInputStream(source).getChannel();
                FileChannel dstChannel = new FileOutputStream(destination).getChannel();
                dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                srcChannel.close();
                dstChannel.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static boolean delete(String file) {
        return FileUtil.delete(new File(file));
    }

    public static boolean delete(File file) {
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    public static void deltree(String directory) {
        FileUtil.deltree(new File(directory));
    }

    public static void deltree(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            File[] fileArray = directory.listFiles();
            int i = 0;
            while (i < fileArray.length) {
                if (fileArray[i].isDirectory()) {
                    FileUtil.deltree(fileArray[i]);
                } else {
                    fileArray[i].delete();
                }
                ++i;
            }
            directory.delete();
        }
    }

    public static boolean exists(String fileName) {
        return FileUtil.exists(new File(fileName));
    }

    public static boolean exists(File file) {
        return file.exists();
    }

    public static byte[] getBytes(File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        FileInputStream in = new FileInputStream(file);
        byte[] bytes = FileUtil.getBytes(in, (int)file.length());
        in.close();
        return bytes;
    }

    public static byte[] getBytes(InputStream in) throws IOException {
        return FileUtil.getBytes(in, -1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getBytes(InputStream in, int bufferSize) throws IOException {
        ByteArrayOutputStream out;
        block6: {
            out = null;
            out = bufferSize <= 0 ? new ByteArrayOutputStream() : new ByteArrayOutputStream(bufferSize);
            boolean createBuffered = false;
            try {
                if (!(in instanceof BufferedInputStream)) {
                    in = new BufferedInputStream(in);
                    createBuffered = true;
                }
                int c = in.read();
                while (c != -1) {
                    out.write(c);
                    c = in.read();
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (createBuffered) {
                    in.close();
                }
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (!createBuffered) break block6;
            }
            in.close();
        }
        out.close();
        return out.toByteArray();
    }

    public static String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int pos = fileName.lastIndexOf(".");
        if (pos != -1) {
            return fileName.substring(pos + 1, fileName.length());
        }
        return null;
    }

    public static String getPath(String fullFileName) {
        String shortFileName;
        int pos = fullFileName.lastIndexOf("/");
        if (pos == -1) {
            pos = fullFileName.lastIndexOf("\\");
        }
        if (Validator.isNull(shortFileName = fullFileName.substring(0, pos))) {
            return "/";
        }
        return shortFileName;
    }

    public static String getShortFileName(String fullFileName) {
        int pos = fullFileName.lastIndexOf("/");
        if (pos == -1) {
            pos = fullFileName.lastIndexOf("\\");
        }
        String shortFileName = fullFileName.substring(pos + 1, fullFileName.length());
        return shortFileName;
    }

    public static String[] listDirs(String fileName) throws IOException {
        return FileUtil.listDirs(new File(fileName));
    }

    public static String[] listDirs(File file) throws IOException {
        ArrayList<String> dirs = new ArrayList<String>();
        File[] fileArray = file.listFiles();
        int i = 0;
        while (i < fileArray.length) {
            if (fileArray[i].isDirectory()) {
                dirs.add(fileArray[i].getName());
            }
            ++i;
        }
        return dirs.toArray(new String[0]);
    }

    public static String[] listFiles(String fileName) throws IOException {
        if (Validator.isNull(fileName)) {
            return new String[0];
        }
        return FileUtil.listFiles(new File(fileName));
    }

    public static String[] listFiles(File file) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        File[] fileArray = file.listFiles();
        int i = 0;
        while (fileArray != null && i < fileArray.length) {
            if (fileArray[i].isFile()) {
                files.add(fileArray[i].getName());
            }
            ++i;
        }
        return files.toArray(new String[0]);
    }

    public static void mkdirs(String pathName) {
        File file = new File(pathName);
        file.mkdirs();
    }

    public static boolean move(String sourceFileName, String destinationFileName) {
        return FileUtil.move(new File(sourceFileName), new File(destinationFileName));
    }

    public static boolean move(File source, File destination) {
        if (!source.exists()) {
            return false;
        }
        destination.delete();
        return source.renameTo(destination);
    }

    public static String read(String fileName) throws IOException {
        return FileUtil.read(new File(fileName));
    }

    public static String read(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        byte[] bytes = new byte[fis.available()];
        fis.read(bytes);
        fis.close();
        String s = new String(bytes);
        return StringUtil.replace(s, "\r\n", "\n");
    }

    public static File[] sortFiles(File[] files) {
        Arrays.sort(files, new FileComparator());
        ArrayList<File> directoryList = new ArrayList<File>();
        ArrayList<File> fileList = new ArrayList<File>();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                directoryList.add(files[i]);
            } else {
                fileList.add(files[i]);
            }
            ++i;
        }
        directoryList.addAll(fileList);
        return directoryList.toArray(new File[0]);
    }

    public static String replaceSeparator(String fileName) {
        return StringUtil.replace(fileName, "\\", "/");
    }

    public static List toList(Reader reader) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(reader);
            String line = null;
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    public static List toList(String fileName) {
        try {
            return FileUtil.toList(new FileReader(fileName));
        }
        catch (IOException ioe) {
            return new ArrayList();
        }
    }

    public static Properties toProperties(FileInputStream fis) {
        Properties props = new Properties();
        try {
            props.load(fis);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props;
    }

    public static Properties toProperties(String fileName) {
        try {
            return FileUtil.toProperties(new FileInputStream(fileName));
        }
        catch (IOException ioe) {
            return new Properties();
        }
    }

    public static void write(String fileName, String s) throws IOException {
        FileUtil.write(new File(fileName), s);
    }

    public static void write(String fileName, String s, boolean lazy) throws IOException {
        FileUtil.write(new File(fileName), s, lazy);
    }

    public static void write(String pathName, String fileName, String s) throws IOException {
        FileUtil.write(new File(pathName, fileName), s);
    }

    public static void write(String pathName, String fileName, String s, boolean lazy) throws IOException {
        FileUtil.write(new File(pathName, fileName), s, lazy);
    }

    public static void write(File file, String s) throws IOException {
        FileUtil.write(file, s, false);
    }

    public static void write(File file, String s, boolean lazy) throws IOException {
        String content;
        if (file.getParent() != null) {
            FileUtil.mkdirs(file.getParent());
        }
        if (file.exists() && (content = FileUtil.read(file)).equals(s)) {
            return;
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.flush();
        bw.write(s);
        bw.close();
    }

    public static void write(String fileName, byte[] byteArray) throws IOException {
        FileUtil.write(new File(fileName), byteArray);
    }

    public static void write(File file, byte[] byteArray) throws IOException {
        if (file.getParent() != null) {
            FileUtil.mkdirs(file.getParent());
        }
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(byteArray);
        fos.close();
    }
}

