/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Stack;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.Map;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class CSH {
    private static Hashtable comps;
    private static final boolean debug = false;

    private static void debug(Object object) {
    }

    private static void dispatchEvent(Object object, AWTEvent aWTEvent) {
        if (object instanceof Component) {
            ((Component)object).dispatchEvent(aWTEvent);
        } else if (object instanceof MenuComponent) {
            ((MenuComponent)object).dispatchEvent(aWTEvent);
        }
    }

    private static Component findComponentAt(Container container, int n2, int n3) {
        if (!container.contains(n2, n3)) {
            return null;
        }
        int n4 = container.getComponentCount();
        Component[] componentArray = container.getComponents();
        int n5 = 0;
        while (n5 < n4) {
            Component component = componentArray[n5];
            if (component != null) {
                Point point = component.getLocation();
                if ((component = component instanceof Container ? CSH.findComponentAt((Container)component, n2 - point.x, n3 - point.y) : component.locate(n2 - point.x, n3 - point.y)) != null && component.isVisible()) {
                    return component;
                }
            }
            ++n5;
        }
        return container;
    }

    private static Object getDeepestObjectAt(Object object, int n2, int n3) {
        Component component;
        if (object != null && object instanceof Container && (component = CSH.findComponentAt((Container)object, n2, n3)) != null && component != object) {
            if (component instanceof JRootPane) {
                JLayeredPane jLayeredPane = ((JRootPane)component).getLayeredPane();
                Rectangle rectangle = jLayeredPane.getBounds();
                component = (Component)CSH.getDeepestObjectAt(jLayeredPane, n2 - rectangle.x, n3 - rectangle.y);
                if (component != null) {
                    return component;
                }
            } else {
                return component;
            }
        }
        return object;
    }

    public static String getHelpIDString(Component component) {
        Serializable serializable;
        String string = null;
        if (component instanceof JComponent) {
            string = (String)((JComponent)component).getClientProperty("HelpID");
        } else if (comps != null && (serializable = (Hashtable)comps.get(component)) != null) {
            string = (String)((Hashtable)serializable).get("HelpID");
        }
        if (string != null) {
            return string;
        }
        serializable = component.getParent();
        if (serializable != null) {
            return CSH.getHelpIDString((Component)serializable);
        }
        return null;
    }

    public static String getHelpIDString(MenuItem menuItem) {
        Object object;
        String string = null;
        if (comps != null && (object = (Hashtable)comps.get(menuItem)) != null) {
            string = (String)((Hashtable)object).get("HelpID");
        }
        if (string != null) {
            return string;
        }
        object = menuItem.getParent();
        if (object != null && object instanceof MenuItem) {
            return CSH.getHelpIDString((MenuItem)object);
        }
        return null;
    }

    public static HelpSet getHelpSet(Component component) {
        Serializable serializable;
        String string = null;
        HelpSet helpSet = null;
        if (component instanceof JComponent) {
            string = (String)((JComponent)component).getClientProperty("HelpID");
            if (string != null) {
                helpSet = (HelpSet)((JComponent)component).getClientProperty("HelpSet");
            }
        } else if (comps != null && (serializable = (Hashtable)comps.get(component)) != null && (string = (String)((Hashtable)serializable).get("HelpID")) != null) {
            helpSet = (HelpSet)((Hashtable)serializable).get("HelpSet");
        }
        if (string != null) {
            return helpSet;
        }
        serializable = component.getParent();
        if (serializable != null) {
            return CSH.getHelpSet((Component)serializable);
        }
        return null;
    }

    public static HelpSet getHelpSet(MenuItem menuItem) {
        Object object;
        String string = null;
        HelpSet helpSet = null;
        if (comps != null && (object = (Hashtable)comps.get(menuItem)) != null && (string = (String)((Hashtable)object).get("HelpID")) != null) {
            helpSet = (HelpSet)((Hashtable)object).get("HelpSet");
        }
        if (string != null) {
            return helpSet;
        }
        object = menuItem.getParent();
        if (object != null && object instanceof MenuItem) {
            return CSH.getHelpSet((MenuItem)object);
        }
        return null;
    }

    public static void setHelpIDString(Component component, String string) {
        if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty("HelpID", string);
        } else {
            Hashtable<String, String> hashtable;
            if (comps == null) {
                comps = new Hashtable(5);
            }
            if ((hashtable = (Hashtable<String, String>)comps.get(component)) != null) {
                if (string != null) {
                    hashtable.put("HelpID", string);
                } else {
                    hashtable.remove(string);
                }
            } else if (string != null) {
                hashtable = new Hashtable<String, String>(2);
                hashtable.put("HelpID", string);
                comps.put(component, hashtable);
            }
        }
    }

    public static void setHelpIDString(MenuItem menuItem, String string) {
        Hashtable<String, String> hashtable;
        if (comps == null) {
            comps = new Hashtable(5);
        }
        if ((hashtable = (Hashtable<String, String>)comps.get(menuItem)) != null) {
            if (string != null) {
                hashtable.put("HelpID", string);
            } else {
                hashtable.remove(string);
            }
        } else if (string != null) {
            hashtable = new Hashtable<String, String>(2);
            hashtable.put("HelpID", string);
            comps.put(menuItem, hashtable);
        }
    }

    public static void setHelpSet(Component component, HelpSet helpSet) {
        if (component == null) {
            throw new IllegalArgumentException("Invalid Component");
        }
        if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty("HelpSet", helpSet);
        } else {
            Hashtable<String, HelpSet> hashtable;
            if (comps == null) {
                comps = new Hashtable(5);
            }
            if ((hashtable = (Hashtable<String, HelpSet>)comps.get(component)) != null) {
                if (helpSet != null) {
                    hashtable.put("HelpSet", helpSet);
                } else {
                    hashtable.remove(helpSet);
                }
            } else if (helpSet != null) {
                hashtable = new Hashtable<String, HelpSet>(2);
                hashtable.put("HelpSet", helpSet);
                comps.put(component, hashtable);
            }
        }
    }

    public static void setHelpSet(MenuItem menuItem, HelpSet helpSet) {
        Hashtable<String, HelpSet> hashtable;
        if (comps == null) {
            comps = new Hashtable(5);
        }
        if ((hashtable = (Hashtable<String, HelpSet>)comps.get(menuItem)) != null) {
            if (helpSet != null) {
                hashtable.put("HelpSet", helpSet);
            } else {
                hashtable.remove(helpSet);
            }
        } else if (helpSet != null) {
            hashtable = new Hashtable<String, HelpSet>(2);
            hashtable.put("HelpSet", helpSet);
            comps.put(menuItem, hashtable);
        }
    }

    public static Object trackCSEvents() {
        block30: {
            boolean bl2 = true;
            try {
                EventQueue eventQueue;
                if (!Thread.currentThread().getClass().getName().endsWith("EventDispatchThread")) break block30;
                try {
                    eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                }
                catch (Exception exception) {
                    return null;
                }
                if (eventQueue == null) {
                    return null;
                }
                while (true) {
                    Serializable serializable;
                    AWTEvent aWTEvent = eventQueue.getNextEvent();
                    Object object = aWTEvent.getSource();
                    try {
                        serializable = Class.forName("java.awt.ActiveEvent");
                        if (serializable != null && ((Class)serializable).isInstance(aWTEvent)) {
                            Method method = null;
                            Class[] classArray = new Class[]{};
                            Object[] objectArray = new Object[]{};
                            method = ((Class)serializable).getMethod("dispatch", classArray);
                            if (method != null) {
                                method.invoke((Object)aWTEvent, objectArray);
                                continue;
                            }
                        }
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                    if (object instanceof Component) {
                        if (aWTEvent instanceof InputEvent) {
                            if (aWTEvent instanceof KeyEvent) {
                                serializable = (KeyEvent)aWTEvent;
                                if (((KeyEvent)serializable).getKeyCode() == 3) {
                                    ((InputEvent)serializable).consume();
                                    return null;
                                }
                                CSH.dispatchEvent(object, aWTEvent);
                                continue;
                            }
                            if (aWTEvent instanceof MouseEvent) {
                                serializable = (MouseEvent)aWTEvent;
                                int n2 = ((AWTEvent)serializable).getID();
                                if (n2 == 500 || n2 == 501 || n2 == 502) {
                                    if (n2 == 500) {
                                        if (bl2) {
                                            bl2 = false;
                                            CSH.dispatchEvent(object, aWTEvent);
                                            continue;
                                        }
                                        ((InputEvent)serializable).consume();
                                        return CSH.getDeepestObjectAt(object, ((MouseEvent)serializable).getX(), ((MouseEvent)serializable).getY());
                                    }
                                    ((InputEvent)serializable).consume();
                                    continue;
                                }
                                ((InputEvent)serializable).consume();
                                continue;
                            }
                            CSH.dispatchEvent(object, aWTEvent);
                            continue;
                        }
                        CSH.dispatchEvent(object, aWTEvent);
                        continue;
                    }
                    if (object instanceof MenuComponent) {
                        if (object instanceof MenuItem) {
                            if (!(aWTEvent instanceof InputEvent)) continue;
                            if (aWTEvent instanceof KeyEvent) {
                                serializable = (KeyEvent)aWTEvent;
                                if (((KeyEvent)serializable).getKeyCode() == 3) {
                                    ((InputEvent)serializable).consume();
                                    return null;
                                }
                                CSH.dispatchEvent(object, aWTEvent);
                                continue;
                            }
                            if (aWTEvent instanceof MouseEvent) {
                                serializable = (MouseEvent)aWTEvent;
                                int n3 = ((AWTEvent)serializable).getID();
                                if (n3 == 500 || n3 == 501 || n3 == 502) {
                                    if (n3 == 500) {
                                        if (bl2) {
                                            bl2 = false;
                                            CSH.dispatchEvent(object, aWTEvent);
                                            continue;
                                        }
                                        ((InputEvent)serializable).consume();
                                        return CSH.getDeepestObjectAt(object, ((MouseEvent)serializable).getX(), ((MouseEvent)serializable).getY());
                                    }
                                    ((InputEvent)serializable).consume();
                                    continue;
                                }
                                ((InputEvent)serializable).consume();
                                continue;
                            }
                            CSH.dispatchEvent(object, aWTEvent);
                            continue;
                        }
                        CSH.dispatchEvent(object, aWTEvent);
                        continue;
                    }
                    System.err.println("unable to dispatch event: " + aWTEvent);
                }
            }
            catch (InterruptedException interruptedException) {
                CSH.debug("InterrupedExeception");
            }
        }
        CSH.debug("Fall Through code");
        return null;
    }

    public static class DisplayHelpFromFocus
    implements ActionListener {
        private HelpBroker hb;

        public DisplayHelpFromFocus(HelpBroker helpBroker) {
            if (helpBroker == null) {
                throw new NullPointerException("hb");
            }
            this.hb = helpBroker;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            Component component2 = (Component)actionEvent.getSource();
            try {
                component = (Window)SwingUtilities.getAncestorOfClass(Class.forName("java.awt.Window"), component2);
                if (this.hb instanceof DefaultHelpBroker) {
                    ((DefaultHelpBroker)this.hb).setActivationWindow((Window)component);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
            if ((component = SwingUtilities.findFocusOwner(component2)) == null) {
                component = component2;
            }
            String string = CSH.getHelpIDString(component);
            HelpSet helpSet = CSH.getHelpSet(component);
            if (helpSet == null) {
                helpSet = this.hb.getHelpSet();
            }
            try {
                Map.ID iD = Map.ID.create(string, helpSet);
                if (iD == null) {
                    iD = helpSet.getHomeID();
                }
                this.hb.setCurrentID(iD);
                this.hb.setDisplayed(true);
            }
            catch (Exception exception) {}
        }
    }

    public static class DisplayHelpAfterTracking
    implements ActionListener {
        private HelpBroker hb;
        private Hashtable cursors;
        private Stack cursorStack;

        public DisplayHelpAfterTracking(HelpBroker helpBroker) {
            if (helpBroker == null) {
                throw new NullPointerException("hb");
            }
            this.hb = helpBroker;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2 = actionEvent.getSource();
            Component component = null;
            Cursor cursor = (Cursor)UIManager.get("HelpOnItemCursor");
            if (cursor == null) {
                return;
            }
            if (object2 instanceof Component) {
                component = this.getTopComponentForComponent((Component)object2);
            } else if (object2 instanceof MenuItem) {
                component = this.getTopComponentForMenuItem((MenuItem)object2);
            } else {
                return;
            }
            if (cursor != null && component != null) {
                this.setCursor(component, cursor);
            }
            Object object3 = CSH.trackCSEvents();
            Component component2 = (Component)actionEvent.getSource();
            try {
                object = (Window)SwingUtilities.getAncestorOfClass(Class.forName("java.awt.Window"), component2);
                if (this.hb instanceof DefaultHelpBroker) {
                    ((DefaultHelpBroker)this.hb).setActivationWindow((Window)object);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
            object = null;
            HelpSet helpSet = null;
            if (object3 != null && object3 instanceof Component) {
                object = CSH.getHelpIDString((Component)object3);
                helpSet = CSH.getHelpSet((Component)object3);
            } else if (object3 != null && object3 instanceof MenuItem) {
                object = CSH.getHelpIDString((MenuItem)object3);
                helpSet = CSH.getHelpSet((MenuItem)object3);
            }
            if (helpSet == null) {
                helpSet = this.hb.getHelpSet();
            }
            try {
                Map.ID iD = Map.ID.create((String)object, helpSet);
                if (iD == null) {
                    iD = helpSet.getHomeID();
                }
                this.hb.setCurrentID(iD);
                this.hb.setDisplayed(true);
            }
            catch (Exception exception) {}
            if (cursor != null && component != null) {
                this.resetAndRestoreCursors(component);
            }
        }

        private Component getTopComponentForComponent(Component component) {
            Component component2;
            Component component3 = component;
            if (component instanceof MenuElement) {
                component3 = component instanceof JPopupMenu ? ((JPopupMenu)component).getInvoker() : ((MenuElement)((Object)component)).getComponent();
            }
            if ((component2 = component3.getParent()) instanceof MenuElement) {
                component2 = component2 instanceof JPopupMenu ? ((JPopupMenu)component2).getInvoker() : ((MenuElement)((Object)component2)).getComponent();
            }
            while (component2 != null) {
                component3 = component2;
                if (!((component2 = component3.getParent()) instanceof MenuElement)) continue;
                component2 = component2 instanceof JPopupMenu ? ((JPopupMenu)component2).getInvoker() : ((MenuElement)((Object)component2)).getComponent();
            }
            return component3;
        }

        private Component getTopComponentForMenuItem(MenuItem menuItem) {
            MenuContainer menuContainer;
            MenuContainer menuContainer2 = menuContainer = menuItem.getParent();
            while (menuContainer2 != null) {
                if (menuContainer2 instanceof Component) break;
                menuContainer = menuContainer2;
                menuContainer2 = ((MenuComponent)((Object)menuContainer)).getParent();
            }
            if (menuContainer2 == null) {
                return null;
            }
            Component component = this.getTopComponentForComponent((Component)menuContainer2);
            return component;
        }

        private void resetAndRestoreCursors(Component component) {
            CSH.debug("resetAndRestoreCursors");
            this.cursorStack = new Stack();
            this.restoreCursors(component);
            this.cursors = null;
            this.cursorStack = null;
        }

        private void restoreCursors(Component component) {
            boolean bl2 = false;
            Cursor cursor = (Cursor)this.cursors.get(component);
            if (cursor != null) {
                this.cursorStack.push(cursor);
                component.setCursor(cursor);
                CSH.debug("restored cursor " + cursor + " on " + component);
                bl2 = true;
            } else if (!this.cursorStack.empty()) {
                component.setCursor((Cursor)this.cursorStack.peek());
                CSH.debug("restored cursor " + (Cursor)this.cursorStack.peek() + " on " + component);
            }
            if (component instanceof Container) {
                Container container = (Container)component;
                int n2 = container.getComponentCount();
                Component[] componentArray = container.getComponents();
                int n3 = 0;
                while (n3 < n2) {
                    Component component2 = componentArray[n3];
                    if (component != null) {
                        this.restoreCursors(component2);
                    }
                    ++n3;
                }
            }
            if (bl2) {
                this.cursorStack.pop();
            }
        }

        private void setAndStoreCursors(Component component, Cursor cursor) {
            boolean bl2 = false;
            Cursor cursor2 = component.getCursor();
            if (this.cursorStack.empty()) {
                this.cursorStack.push(cursor2);
                this.cursors.put(component, cursor2);
                bl2 = true;
                CSH.debug("store cursor " + cursor2 + " on " + component);
            } else if (cursor2 != (Cursor)this.cursorStack.peek()) {
                this.cursorStack.push(cursor2);
                this.cursors.put(component, cursor2);
                bl2 = true;
                CSH.debug("store cursor " + cursor2 + " on " + component);
            }
            if (component instanceof Container) {
                Container container = (Container)component;
                int n2 = container.getComponentCount();
                Component[] componentArray = container.getComponents();
                int n3 = 0;
                while (n3 < n2) {
                    Component component2 = componentArray[n3];
                    if (component != null) {
                        this.setAndStoreCursors(component2, cursor);
                    }
                    ++n3;
                }
            }
            component.setCursor(cursor);
            CSH.debug("set cursor on " + component);
            if (bl2) {
                this.cursorStack.pop();
            }
        }

        private void setCursor(Component component, Cursor cursor) {
            CSH.debug("setCursors");
            this.cursors = new Hashtable();
            this.cursorStack = new Stack();
            this.setAndStoreCursors(component, cursor);
        }
    }

    public static class DisplayHelpFromSource
    implements ActionListener {
        private HelpBroker hb;

        public DisplayHelpFromSource(HelpBroker helpBroker) {
            if (helpBroker == null) {
                throw new NullPointerException("hb");
            }
            this.hb = helpBroker;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            Object object3;
            Object object4 = actionEvent.getSource();
            if (object4 instanceof Component) {
                object3 = (Component)actionEvent.getSource();
                if (object3 instanceof JMenuItem) {
                    while (object3 instanceof JMenuItem) {
                        object2 = ((Component)object3).getParent();
                        if (!(object2 instanceof JPopupMenu)) break;
                        object3 = ((JPopupMenu)object2).getInvoker();
                    }
                }
                try {
                    object2 = (Window)SwingUtilities.getAncestorOfClass(Class.forName("java.awt.Window"), (Component)object3);
                    CSH.debug("owner = " + object2);
                    if (this.hb instanceof DefaultHelpBroker) {
                        ((DefaultHelpBroker)this.hb).setActivationWindow((Window)object2);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else if (object4 instanceof MenuItem) {
                block26: {
                    object3 = (MenuItem)actionEvent.getSource();
                    object2 = null;
                    while (true) {
                        if ((object = ((MenuComponent)object3).getParent()) instanceof Menu) {
                            object3 = (MenuItem)object;
                            continue;
                        }
                        if (object instanceof MenuBar) {
                            try {
                                object2 = (Window)SwingUtilities.getAncestorOfClass(Class.forName("java.awt.Window"), (Component)((MenuBar)object).getParent());
                            }
                            catch (ClassNotFoundException classNotFoundException) {}
                            break block26;
                        }
                        if (object instanceof Frame) {
                            object2 = (Window)object;
                            break block26;
                        }
                        if (object instanceof Component) break;
                    }
                    try {
                        object2 = (Window)SwingUtilities.getAncestorOfClass(Class.forName("java.awt.Window"), (Component)object);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                CSH.debug("owner = " + object2);
                if (this.hb instanceof DefaultHelpBroker) {
                    ((DefaultHelpBroker)this.hb).setActivationWindow((Window)object2);
                }
            }
            object3 = null;
            object2 = null;
            if (object4 instanceof Component) {
                object = (Component)object4;
                object3 = CSH.getHelpIDString((Component)object);
                object2 = CSH.getHelpSet((Component)object);
            } else if (object4 instanceof MenuItem) {
                object = (MenuItem)object4;
                object3 = CSH.getHelpIDString((MenuItem)object);
                object2 = CSH.getHelpSet((MenuItem)object);
            } else {
                return;
            }
            if (object2 == null) {
                object2 = this.hb.getHelpSet();
            }
            try {
                object = Map.ID.create((String)object3, (HelpSet)object2);
                if (object == null) {
                    object = ((HelpSet)object2).getHomeID();
                }
                this.hb.setCurrentID((Map.ID)object);
                this.hb.setDisplayed(true);
            }
            catch (Exception exception) {
                System.err.println("trouble in HelpActionListener");
                exception.printStackTrace();
            }
        }
    }
}

