/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.network;

import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.internal.ssl.Provider;
import edu.sdsc.secureftp.Constants;
import edu.sdsc.secureftp.data.Data;
import edu.sdsc.secureftp.data.HostInfo;
import edu.sdsc.secureftp.data.SecureFtpTrustManager;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.network.BasicFtp;
import edu.sdsc.secureftp.network.FtpServerInfo;
import edu.sdsc.secureftp.network.exception.FtpConnectException;
import edu.sdsc.secureftp.network.exception.FtpException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.Security;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SSLFtp
extends BasicFtp
implements Constants {
    private int defaultPort = 990;
    private String securityType = "Implicit SSL";
    private SSLSocket cmdSocket = null;
    private SSLContext context = null;
    private boolean sslData = false;
    private KeyManager[] kmArray;
    private SecureFtpTrustManager[] tmArray;

    public SSLFtp(Data data, Data data2) throws Exception {
        super(data, data2);
        Security.addProvider(new Provider());
        this.clientData.initFtpKeyStore();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
        keyManagerFactory.init(this.clientData.getFtpKeyStore().getKeyStore(), Constants.KEYSTORE_PASSWORD);
        this.kmArray = keyManagerFactory.getKeyManagers();
        this.tmArray = new SecureFtpTrustManager[]{new SecureFtpTrustManager(this.clientData)};
        this.context = SSLContext.getInstance("TLS", "SunJSSE");
    }

    public synchronized void connect() throws FtpException, UnknownHostException, ConnectException {
        int n2;
        HostInfo hostInfo = this.clientData.getHostInfo();
        this.clientData.setCertificateCheck(true);
        try {
            n2 = Integer.parseInt((String)hostInfo.get("port"));
        }
        catch (NullPointerException nullPointerException) {
            throw new FtpException(new LString("port_number_needed.msg", "Port number needed").getString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new FtpException(new LString("port_specified_incorrect.msg", "Port specified is not a number").getString());
        }
        this.usePasv = this.getBooleanParam(hostInfo, "pasv");
        debug.println("use PASV mode: " + this.usePasv, 3);
        this.sslData = this.getBooleanParam(hostInfo, "ssldata");
        debug.println("use SSL for data channel: " + this.sslData);
        try {
            this.clientData.getSSLInit().join();
            this.context.init(this.kmArray, this.tmArray, this.clientData.getSSLInit().getRandom());
        }
        catch (InterruptedException interruptedException) {
        }
        catch (KeyManagementException keyManagementException) {}
        try {
            String string = (String)hostInfo.get("hostname");
            SSLSocketFactory sSLSocketFactory = this.context.getSocketFactory();
            this.cmdSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n2);
            this.cmdWriter = new PrintWriter(this.cmdSocket.getOutputStream(), true);
            this.cmdReader = new BufferedReader(new InputStreamReader(this.cmdSocket.getInputStream()));
        }
        catch (IOException iOException) {
            throw new FtpException(iOException.getMessage());
        }
        this.setTimeout(30000);
        this.recvCmd();
        this.setTimeout(0);
        if (this.replyCode == 120) {
            this.recvCmd();
        }
        if (this.replyCode != 220) {
            throw new FtpConnectException(this.replyMessage);
        }
        this.isConnected = true;
        this.listFormat = FtpServerInfo.lookupListStyleByBanner(this.replyMessage);
        if (this.listFormat == 0) {
            this.listFormat = 1;
        }
        debug.println("FTP list style = " + this.listFormat);
        this.clientData.setCertificateCheck(false);
    }

    protected ServerSocket createDataServerSocket(int n2) throws IOException {
        if (this.sslData) {
            SSLServerSocket sSLServerSocket = (SSLServerSocket)this.context.getServerSocketFactory().createServerSocket(n2);
            sSLServerSocket.setUseClientMode(true);
            return sSLServerSocket;
        }
        return new ServerSocket(n2);
    }

    protected Socket createDataSocket(String string, int n2) throws IOException {
        if (this.sslData) {
            return this.context.getSocketFactory().createSocket(string, n2);
        }
        return new Socket(string, n2);
    }

    protected synchronized void enableDataEncryption(boolean bl2) throws FtpException {
        String string = bl2 ? "P" : "C";
        this.sendCmd("PBSZ 0");
        this.recvCmd();
        this.sendCmd("PROT " + string);
        this.recvCmd();
    }

    private boolean getBooleanParam(HostInfo hostInfo, String string) {
        try {
            return (Boolean)hostInfo.get(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public String getSecurityType() {
        return this.securityType;
    }

    protected synchronized void setTimeout(int n2) {
        try {
            this.cmdSocket.setSoTimeout(n2);
        }
        catch (SocketException socketException) {}
    }

    public synchronized void setupDataConnection() throws FtpException {
        this.enableDataEncryption(this.sslData);
    }
}

