/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.network;

import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import edu.sdsc.secureftp.Constants;
import edu.sdsc.secureftp.data.Data;
import edu.sdsc.secureftp.data.HostInfo;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.network.FtpServerInfo;
import edu.sdsc.secureftp.network.exception.FtpAbortException;
import edu.sdsc.secureftp.network.exception.FtpBadLoginException;
import edu.sdsc.secureftp.network.exception.FtpConnectException;
import edu.sdsc.secureftp.network.exception.FtpConnectionLostException;
import edu.sdsc.secureftp.network.exception.FtpException;
import edu.sdsc.secureftp.network.exception.FtpGetException;
import edu.sdsc.secureftp.network.exception.FtpListException;
import edu.sdsc.secureftp.network.exception.FtpNeedAccountException;
import edu.sdsc.secureftp.network.exception.FtpNeedPasswordException;
import edu.sdsc.secureftp.network.exception.FtpNoSuchFileException;
import edu.sdsc.secureftp.network.exception.FtpNotADirectoryException;
import edu.sdsc.secureftp.network.exception.FtpPassException;
import edu.sdsc.secureftp.network.exception.FtpPutException;
import edu.sdsc.secureftp.network.exception.FtpPwdException;
import edu.sdsc.secureftp.network.exception.FtpUserException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class BasicFtp
implements Constants {
    private int defaultPort = 21;
    private String securityType = new LString("no_security.label", "None").getString();
    Data clientData;
    Data serverData;
    Socket cmdSocket;
    PrintWriter cmdWriter;
    BufferedReader cmdReader;
    String dataAddr;
    int dataPort;
    Socket dataSocket;
    ServerSocket dataServerSocket;
    InputStream dataInput;
    OutputStream dataOutput;
    boolean usePasv;
    char transferType;
    String remoteDir;
    int listFormat;
    boolean isConnected;
    int replyCode;
    String replyMessage;
    Perl5Compiler compiler;
    Perl5Matcher matcher;

    public BasicFtp(Data data, Data data2) {
        this.clientData = data;
        this.serverData = data2;
        this.cmdSocket = null;
        this.dataSocket = null;
        this.dataAddr = null;
        this.dataPort = -1;
        this.remoteDir = null;
        this.replyCode = -1;
        this.replyMessage = null;
        this.usePasv = false;
        this.transferType = (char)63;
        this.listFormat = 0;
        this.compiler = new Perl5Compiler();
        this.matcher = new Perl5Matcher();
        this.isConnected = false;
    }

    public void abort() throws FtpAbortException, FtpException {
        this.sendCmd("ABOR");
        this.closeDataConnection();
        this.recvCmd();
        if (this.replyCode == 426 || this.replyCode == 550) {
            try {
                this.recvCmd();
            }
            catch (Exception exception) {}
            if (this.replyCode / 200 != 1) {
                throw new FtpAbortException(this.replyMessage);
            }
        } else if (this.replyCode == 226) {
            this.recvCmd();
            if (this.replyCode / 200 != 1) {
                throw new FtpAbortException(this.replyMessage);
            }
        } else if (this.replyCode != 225) {
            throw new FtpException(this.replyMessage);
        }
    }

    public synchronized void acct(String string) throws FtpException {
        if (string == null || string.trim().equals("")) {
            return;
        }
        this.sendCmd("ACCT " + string, "ACCT **********");
        this.recvCmd();
        if (this.replyCode != 202 && this.replyCode != 230) {
            throw new FtpException(this.replyMessage);
        }
    }

    public synchronized void ascii() throws FtpException {
        this.type('A');
    }

    public synchronized void ascii(boolean bl2) throws FtpException {
        if (bl2 && this.transferType == 'A') {
            return;
        }
        this.ascii();
    }

    public synchronized void binary() throws FtpException {
        this.type('I');
    }

    public synchronized void binary(boolean bl2) throws FtpException {
        if (bl2 && this.transferType == 'I') {
            return;
        }
        this.binary();
    }

    public synchronized void cdup() throws FtpException {
        this.sendCmd("CDUP");
        this.recvCmd();
        if (this.replyCode != 250) {
            throw new FtpException(this.replyMessage);
        }
    }

    public synchronized void chdir(String string) throws FtpException {
        if (string == null || string.trim().equals("")) {
            return;
        }
        this.sendCmd("CWD " + string);
        this.recvCmd();
        if (this.replyCode != 250) {
            if (this.replyCode == 550) {
                if (this.replyMessage.toLowerCase().indexOf("not a directory") >= 0 || this.replyMessage.toLowerCase().indexOf("directory name is invalid") >= 0) {
                    throw new FtpNotADirectoryException(this.replyMessage);
                }
                if (this.replyMessage.toLowerCase().indexOf("no such") >= 0) {
                    throw new FtpNoSuchFileException(this.replyMessage);
                }
                throw new FtpException(this.replyMessage);
            }
            throw new FtpException(this.replyMessage);
        }
    }

    protected synchronized void cleanup() {
        try {
            this.cmdReader.close();
            this.cmdWriter.close();
            this.cmdSocket.close();
        }
        catch (Exception exception) {}
    }

    private synchronized void closeDataConnection() {
        try {
            this.dataInput.close();
            this.dataOutput.close();
            this.dataSocket.close();
        }
        catch (Exception exception) {}
    }

    public synchronized void connect() throws FtpException, UnknownHostException, ConnectException {
        HostInfo hostInfo = this.clientData.getHostInfo();
        int n2 = Integer.parseInt((String)hostInfo.get("port"));
        this.usePasv = (Boolean)hostInfo.get("pasv");
        debug.println("use PASV mode: " + this.usePasv, 4);
        try {
            this.cmdSocket = new Socket((String)hostInfo.get("hostname"), n2);
            this.cmdWriter = new PrintWriter(this.cmdSocket.getOutputStream(), false);
            this.cmdReader = new BufferedReader(new InputStreamReader(this.cmdSocket.getInputStream()));
        }
        catch (IOException iOException) {
            throw new FtpException(iOException.getMessage());
        }
        this.setTimeout(30000);
        this.recvCmd();
        this.setTimeout(0);
        if (this.replyCode == 120) {
            this.recvCmd();
        }
        if (this.replyCode != 220) {
            throw new FtpConnectException(this.replyMessage);
        }
        this.isConnected = true;
        this.clientData.startConnection(this.securityType);
        this.listFormat = FtpServerInfo.lookupListStyleByBanner(this.replyMessage);
        if (this.listFormat == 0) {
            this.listFormat = 1;
        }
        debug.println("FTP list style = " + this.listFormat);
    }

    protected ServerSocket createDataServerSocket(int n2) throws IOException {
        return new ServerSocket(n2);
    }

    protected Socket createDataSocket(String string, int n2) throws IOException {
        return new Socket(string, n2);
    }

    public synchronized void delete(String string) throws FtpException {
        if (string == null || string.trim().equals("")) {
            return;
        }
        this.sendCmd("DELE " + string);
        this.recvCmd();
        if (this.replyCode != 250) {
            throw new FtpException(this.replyMessage);
        }
    }

    public synchronized void disconnect() {
        try {
            this.isConnected = false;
            this.quit();
            this.cleanup();
        }
        catch (Exception exception) {}
    }

    public synchronized void get(String string, OutputStream outputStream, long l2) throws FtpException, IOException {
        if (string == null || string.trim().equals("") || outputStream == null) {
            return;
        }
        this.setupDataConnection();
        if (this.usePasv) {
            this.pasv();
        } else {
            this.port();
        }
        this.sendCmd("RETR " + string);
        this.recvCmd();
        if (this.replyCode / 100 != 1) {
            if (this.replyCode == 532) {
                throw new FtpNeedAccountException(new LString("need_account_name.msg", "Need account name").getString());
            }
            throw new FtpGetException(this.replyMessage);
        }
        if (!this.usePasv) {
            this.portAccept();
        }
        if (this.transferType == 'A') {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.dataInput));
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                printWriter.print(String.valueOf(string2) + "\r\n");
                this.clientData.updateFileTransfer(string2.length() + 1);
            }
            printWriter.flush();
        } else {
            int n2;
            byte[] byArray = new byte[1024];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.dataInput);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            while ((n2 = bufferedInputStream.read(byArray, 0, byArray.length)) >= 0) {
                bufferedOutputStream.write(byArray, 0, n2);
                this.clientData.updateFileTransfer(n2);
            }
            bufferedOutputStream.flush();
        }
        this.closeDataConnection();
        this.recvCmd();
        if (this.replyCode / 200 != 1) {
            throw new FtpGetException(this.replyMessage);
        }
    }

    public Data getClientData() {
        return this.clientData;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public String getDirName() {
        return this.remoteDir;
    }

    public String getSecurityType() {
        return this.securityType;
    }

    public Data getServerData() {
        return this.serverData;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public synchronized void list() throws FtpException {
        boolean bl2 = false;
        boolean bl3 = false;
        this.ascii(true);
        this.setupDataConnection();
        if (this.usePasv) {
            this.pasv();
        } else {
            this.port();
        }
        if (this.listFormat == 0) {
            this.sendCmd("NLST");
        } else {
            this.sendCmd("LIST");
        }
        this.recvCmd();
        if (this.replyCode != 125 && this.replyCode != 150) {
            throw new FtpListException(this.replyMessage);
        }
        if (!this.usePasv) {
            this.portAccept();
        }
        this.clientData.startDirEntry();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.dataInput));
            int n2 = 0;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf(": Permission denied") >= 0) {
                    debug.println("Permission denied for listing directory");
                    bl3 = true;
                    break;
                }
                if (n2 != 0 || !string.trim().startsWith("total")) {
                    Pattern pattern;
                    String string2 = null;
                    String string3 = null;
                    String string4 = null;
                    String string5 = null;
                    if (this.listFormat == 1) {
                        pattern = this.compiler.compile("^(\\S+).*\\s+(\\d+)\\s+(\\S+\\s+\\d+\\s+[\\d:]+) (.+)$");
                        if (this.matcher.contains(string, pattern)) {
                            string2 = this.matcher.getMatch().group(1);
                            string4 = this.matcher.getMatch().group(2);
                            string5 = this.matcher.getMatch().group(3);
                            string3 = this.matcher.getMatch().group(4);
                        } else {
                            if (!bl2) {
                                debug.println("Failed to parse as Unix list style");
                            }
                            this.listFormat = 0;
                            bl2 = true;
                        }
                    } else if (this.listFormat == 2) {
                        pattern = this.compiler.compile("^(\\S+\\s+\\S+)\\s+(\\S+)\\s+(.+)$");
                        if (this.matcher.contains(string, pattern)) {
                            string5 = this.matcher.getMatch().group(1);
                            string4 = this.matcher.getMatch().group(2);
                            string3 = this.matcher.getMatch().group(3);
                            if (string4.trim().equals("<DIR>")) {
                                string2 = "d";
                                string4 = null;
                            } else {
                                string2 = "-";
                            }
                        } else {
                            if (!bl2) {
                                debug.println("Failed to parse as Windows list style");
                            }
                            this.listFormat = 0;
                            bl2 = true;
                        }
                    } else {
                        string3 = string;
                    }
                    this.clientData.addDirEntry(string2, string3, string4, string5);
                }
                ++n2;
            }
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new FtpException("Pattern exception.  Report this bug.");
        }
        catch (IOException iOException) {
            throw new FtpException(iOException.getMessage());
        }
        this.clientData.endDirEntry();
        this.closeDataConnection();
        this.recvCmd();
        if (this.replyCode != 226 && this.replyCode != 250) {
            throw new FtpListException(this.replyMessage);
        }
        if (bl3) {
            throw new FtpListException(new LString("permission_denied.msg", "Permission denied").getString());
        }
        if (bl2) {
            this.list();
        }
    }

    public synchronized void login() throws FtpException {
        HostInfo hostInfo = this.clientData.getHostInfo();
        String string = (String)hostInfo.get("username");
        String string2 = (String)hostInfo.get("password");
        String string3 = (String)hostInfo.get("account");
        try {
            this.user(string);
        }
        catch (FtpNeedAccountException ftpNeedAccountException) {
            if (string3 == null || string3.equals("")) {
                throw ftpNeedAccountException;
            }
            this.acct(string3);
        }
        catch (FtpNeedPasswordException ftpNeedPasswordException) {
            if (string2 == null || string2.equals("")) {
                throw ftpNeedPasswordException;
            }
            try {
                this.pass(string2);
            }
            catch (FtpNeedAccountException ftpNeedAccountException) {
                if (string3 == null || string3.equals("")) {
                    throw ftpNeedAccountException;
                }
                this.acct(string3);
            }
        }
    }

    public synchronized void mkdir(String string) throws FtpException {
        if (string == null || string.trim().equals("")) {
            return;
        }
        this.sendCmd("MKD " + string);
        this.recvCmd();
        if (this.replyCode != 257) {
            throw new FtpException(this.replyMessage);
        }
    }

    public synchronized void pass(String string) throws FtpException {
        if (string == null || string.trim().equals("")) {
            return;
        }
        this.sendCmd("PASS " + string, "PASS **********");
        this.recvCmd();
        if (this.replyCode != 202 && this.replyCode != 230) {
            if (this.replyCode == 332) {
                throw new FtpNeedAccountException(new LString("need_account_for_login.msg", "Need account for login").getString());
            }
            if (this.replyCode == 530) {
                throw new FtpBadLoginException();
            }
            throw new FtpPassException(this.replyMessage);
        }
    }

    public synchronized void pasv() throws FtpException {
        this.sendCmd("PASV");
        this.recvCmd();
        if (this.replyCode != 227) {
            throw new FtpException(this.replyMessage);
        }
        String string = this.replyMessage;
        try {
            Pattern pattern = this.compiler.compile("(\\d+,\\d+,\\d+,\\d+),(\\d+),(\\d+)");
            if (!this.matcher.contains(this.replyMessage, pattern)) {
                throw new FtpException("Unexpected response after sending PASV");
            }
            this.dataAddr = this.matcher.getMatch().group(1).replace(',', '.');
            this.dataPort = Integer.parseInt(this.matcher.getMatch().group(2)) << 8 | Integer.parseInt(this.matcher.getMatch().group(3));
            debug.println("data addr = " + this.dataAddr);
            debug.println("data port = " + this.dataPort);
        }
        catch (MalformedPatternException malformedPatternException) {
            debug.println("pattern exception: " + malformedPatternException.getMessage());
            throw new FtpException("Pattern exception in PASV.  Report this bug.");
        }
        catch (Exception exception) {
            debug.println("Exception parsing pasv response: " + exception.getMessage());
            throw new FtpException("Unexpected response after sending PASV");
        }
        try {
            this.dataSocket = this.createDataSocket(this.dataAddr, this.dataPort);
            this.dataInput = this.dataSocket.getInputStream();
            this.dataOutput = this.dataSocket.getOutputStream();
        }
        catch (IOException iOException) {
            throw new FtpException(iOException.getMessage());
        }
    }

    public synchronized void port() throws FtpException {
        int n2;
        String string;
        try {
            this.dataServerSocket = this.createDataServerSocket(0);
            this.dataServerSocket.getInetAddress();
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostAddress().replace('.', ',');
            n2 = this.dataServerSocket.getLocalPort();
        }
        catch (UnknownHostException unknownHostException) {
            throw new FtpException(unknownHostException.getMessage());
        }
        catch (IOException iOException) {
            throw new FtpException(iOException.getMessage());
        }
        int n3 = n2 >> 8;
        int n4 = n2 & 0xFF;
        this.sendCmd("PORT " + string + ',' + n3 + ',' + n4);
        this.recvCmd();
        if (this.replyCode != 200) {
            throw new FtpException(this.replyMessage);
        }
    }

    public synchronized void portAccept() throws FtpException {
        try {
            this.dataSocket = this.dataServerSocket.accept();
            this.dataServerSocket.close();
            this.dataInput = this.dataSocket.getInputStream();
            this.dataOutput = this.dataSocket.getOutputStream();
        }
        catch (IOException iOException) {
            throw new FtpException(iOException.getMessage());
        }
    }

    public synchronized void put(String string, InputStream inputStream, long l2) throws FtpException, IOException {
        if (string == null || string.trim().equals("") || inputStream == null) {
            return;
        }
        this.setupDataConnection();
        if (this.usePasv) {
            this.pasv();
        } else {
            this.port();
        }
        this.sendCmd("STOR " + string);
        this.recvCmd();
        if (this.replyCode / 100 != 1) {
            if (this.replyCode == 532) {
                throw new FtpNeedAccountException(new LString("need_account_name.msg", "Need account name").getString());
            }
            throw new FtpPutException(this.replyMessage);
        }
        if (!this.usePasv) {
            this.portAccept();
        }
        if (this.transferType == 'A') {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(this.dataOutput));
            while ((string2 = bufferedReader.readLine()) != null) {
                printWriter.print(String.valueOf(string2) + "\r\n");
                this.clientData.updateFileTransfer(string2.length() + 1);
            }
            printWriter.flush();
        } else {
            int n2;
            byte[] byArray = new byte[1024];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.dataOutput);
            while ((n2 = bufferedInputStream.read(byArray, 0, byArray.length)) >= 0) {
                bufferedOutputStream.write(byArray, 0, n2);
                this.clientData.updateFileTransfer(n2);
            }
            bufferedOutputStream.flush();
        }
        this.closeDataConnection();
        this.recvCmd();
        if (this.replyCode / 200 != 1) {
            throw new FtpPutException(this.replyMessage);
        }
    }

    public synchronized void pwd() throws FtpPwdException, FtpException {
        int n2;
        this.sendCmd("PWD");
        this.recvCmd();
        if (this.replyCode != 257) {
            throw new FtpPwdException(this.replyMessage);
        }
        String string = this.replyMessage;
        int n3 = string.indexOf(34);
        if (n3 >= 0) {
            n2 = string.indexOf(34, n3 + 1);
            if (n2 < 0) {
                throw new FtpPwdException("Could not find end of directory string");
            }
        } else {
            throw new FtpPwdException("Could not find start of directory string");
        }
        this.remoteDir = string.substring(n3 + 1, n2);
    }

    public synchronized void quit() throws FtpException {
        this.sendCmd("QUIT");
        this.recvCmd(1000);
        if (this.replyCode != 221) {
            throw new FtpException(this.replyMessage);
        }
    }

    protected synchronized void recvCmd() throws FtpException {
        StringWriter stringWriter = new StringWriter();
        this.replyCode = -1;
        this.replyMessage = null;
        this.recvWrite(stringWriter);
        String string = stringWriter.toString();
        this.serverData.setResponse(string);
        debug.println("RECV: " + string, 2);
        try {
            this.replyMessage = string.substring(4).trim();
        }
        catch (Exception exception) {
            this.replyMessage = "";
        }
        if (this.replyCode == 421) {
            this.isConnected = false;
            this.cleanup();
            throw new FtpConnectionLostException(new LString("connection_closed.msg", "Connection closed by server.").getString());
        }
    }

    protected synchronized void recvCmd(int n2) throws FtpException {
        this.setTimeout(n2);
        try {
            this.recvCmd();
        }
        catch (FtpException ftpException) {
            this.setTimeout(0);
            throw ftpException;
        }
        this.setTimeout(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void recvWrite(Writer writer) throws FtpException {
        try {
            PrintWriter printWriter = new PrintWriter(writer, false);
            String string = this.cmdReader.readLine();
            if (string == null) {
                return;
            }
            printWriter.print(String.valueOf(string) + "\r\n");
            printWriter.flush();
            try {
                this.replyCode = Integer.parseInt(string.substring(0, 3));
            }
            catch (NumberFormatException numberFormatException) {
                throw new FtpException(new LString("unrecogonized_response.msg", "Unrecognized response from server").getString());
            }
            if (string.charAt(3) != '-') {
                return;
            }
            while (true) {
                if ((string = this.cmdReader.readLine()) == null) {
                    return;
                }
                printWriter.print(String.valueOf(string) + "\r\n");
                printWriter.flush();
                if (string.length() <= 3) continue;
                try {
                    int n2 = Integer.parseInt(string.substring(0, 3));
                    if (string.charAt(3) != ' ' || n2 != this.replyCode) continue;
                    return;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            debug.println("read interrupted: " + interruptedIOException.getMessage());
            throw new FtpException(interruptedIOException.getMessage());
        }
        catch (IOException iOException) {
            this.isConnected = false;
            debug.println("io exception: " + iOException.getMessage());
            throw new FtpConnectionLostException(new LString("connection_lost.msg", "Connection lost.").getString());
        }
    }

    public synchronized void rename(String string, String string2) throws FtpException {
        if (string == null || string.trim().equals("") || string2 == null || string2.trim().equals("")) {
            return;
        }
        this.sendCmd("RNFR " + string);
        this.recvCmd();
        if (this.replyCode != 350) {
            throw new FtpException(this.replyMessage);
        }
        this.sendCmd("RNTO " + string2);
        this.recvCmd();
        if (this.replyCode != 250) {
            if (this.replyCode == 532) {
                throw new FtpNeedAccountException(new LString("need_account_name.msg", "Need account name").getString());
            }
            throw new FtpException(this.replyMessage);
        }
    }

    public synchronized void rmdir(String string) throws FtpException {
        if (string == null || string.trim().equals("")) {
            return;
        }
        this.sendCmd("RMD " + string);
        this.recvCmd();
        if (this.replyCode != 250) {
            throw new FtpException(this.replyMessage);
        }
    }

    protected synchronized void sendCmd(String string) throws FtpException {
        this.cmdWriter.print(String.valueOf(string) + "\r\n");
        if (this.cmdWriter.checkError()) {
            this.isConnected = false;
            throw new FtpConnectionLostException(new LString("connection_lost.msg", "Connection lost.").getString());
        }
        debug.println("SENT: " + string, 2);
        this.serverData.setCommand(string);
    }

    protected synchronized void sendCmd(String string, String string2) {
        this.cmdWriter.print(String.valueOf(string) + "\r\n");
        this.cmdWriter.flush();
        debug.println("SENT: " + string2, 2);
        this.serverData.setCommand(string2);
    }

    protected synchronized void setTimeout(int n2) {
        try {
            this.cmdSocket.setSoTimeout(n2);
        }
        catch (SocketException socketException) {}
    }

    public synchronized void setupDataConnection() throws FtpException {
    }

    public synchronized long size(String string) throws FtpException {
        long l2 = -1L;
        if (string == null || string.trim().equals("")) {
            return -1L;
        }
        this.sendCmd("SIZE " + string);
        this.recvCmd();
        try {
            if (this.replyCode / 200 == 1) {
                l2 = Long.parseLong(this.replyMessage.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return l2;
    }

    public synchronized String syst() throws FtpException {
        this.sendCmd("SYST");
        this.recvCmd();
        if (this.replyCode / 200 == 1) {
            return this.replyMessage;
        }
        return null;
    }

    public synchronized void type(char c10) throws FtpException {
        this.sendCmd("TYPE " + c10);
        this.recvCmd();
        if (this.replyCode != 200) {
            throw new FtpException(this.replyMessage);
        }
        this.transferType = c10;
    }

    public synchronized void user(String string) throws FtpException {
        if (string == null || string.trim().equals("")) {
            return;
        }
        this.sendCmd("USER " + string);
        this.recvCmd();
        if (this.replyCode != 230) {
            if (this.replyCode == 331) {
                LString lString = new LString("need_password_for_user.msg", "Need password for user [^0]");
                lString.replace(0, string);
                throw new FtpNeedPasswordException(lString.getString());
            }
            if (this.replyCode == 332) {
                throw new FtpNeedAccountException(new LString("need_account_for_login.msg", "Need account for login").getString());
            }
            if (this.replyCode == 530) {
                throw new FtpUserException(this.replyMessage);
            }
            throw new FtpUserException(this.replyMessage);
        }
    }
}

