/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.data.Data;
import edu.sdsc.secureftp.data.FtpThread;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.TransferStatusDialog;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

class TransferProgressThread
extends Thread {
    TransferStatusDialog parent;
    FtpThread transfer;
    Data stats;
    Runnable getMin;
    Runnable getMax;
    Runnable setValue;
    Runnable paintString;
    Runnable dontPaintString;
    int minValue;
    int maxValue;
    int value;

    public TransferProgressThread(TransferStatusDialog transferStatusDialog, FtpThread ftpThread, Data data) {
        this.parent = transferStatusDialog;
        this.transfer = ftpThread;
        this.stats = data;
        this.setValue = new Runnable(){

            public void run() {
                JProgressBar jProgressBar = TransferProgressThread.this.parent.getProgressBar();
                jProgressBar.setValue(TransferProgressThread.this.value);
            }
        };
        this.getMin = new Runnable(){

            public void run() {
                JProgressBar jProgressBar = TransferProgressThread.this.parent.getProgressBar();
                TransferProgressThread.this.minValue = jProgressBar.getMinimum();
            }
        };
        this.getMax = new Runnable(){

            public void run() {
                JProgressBar jProgressBar = TransferProgressThread.this.parent.getProgressBar();
                TransferProgressThread.this.maxValue = jProgressBar.getMaximum();
            }
        };
        this.paintString = new Runnable(){

            public void run() {
                JProgressBar jProgressBar = TransferProgressThread.this.parent.getProgressBar();
                jProgressBar.setStringPainted(true);
            }
        };
        this.dontPaintString = new Runnable(){

            public void run() {
                JProgressBar jProgressBar = TransferProgressThread.this.parent.getProgressBar();
                jProgressBar.setStringPainted(false);
            }
        };
    }

    private String formatDataLabel(long l2, long l3) {
        LString lString;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumFractionDigits(1);
        numberFormat.setMaximumFractionDigits(1);
        if (l3 < 0L || l2 > l3) {
            lString = new LString("transferring_data.kbytes.msg", "Transferring [^0] of [^1] KBytes");
            lString.replace(0, numberFormat.format((double)l2 / 1000.0));
            lString.replace(1, "<" + new LString("unknown.msg", "unknown").getString() + ">");
        } else if (l3 < 1000L) {
            lString = new LString("transferring_data.bytes.msg", "Transferring [^0] of [^1] Bytes");
            lString.replace(0, String.valueOf(l2));
            lString.replace(1, String.valueOf(l3));
        } else {
            lString = new LString("transferring_data.kbytes.msg", "Transferring [^0] of [^1] KBytes");
            lString.replace(0, numberFormat.format((double)l2 / 1000.0));
            lString.replace(1, numberFormat.format((double)l3 / 1000.0));
        }
        return lString.getString();
    }

    public void run() {
        while (this.transfer.isAlive()) {
            try {
                SwingUtilities.invokeAndWait(this.getMin);
                SwingUtilities.invokeAndWait(this.getMax);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
            try {
                Thread.sleep(3L);
                this.parent.getFileLabel().setText(this.transfer.getLabelText());
                long l2 = this.stats.getTransferSizeCompleted();
                long l3 = this.stats.getTransferSizeTotal();
                if (l3 <= 0L || l2 > l3) {
                    this.value = this.minValue;
                    SwingUtilities.invokeLater(this.setValue);
                    SwingUtilities.invokeLater(this.dontPaintString);
                } else {
                    double d10 = (double)l2 / (double)l3;
                    this.value = (int)(d10 * (double)this.maxValue);
                    SwingUtilities.invokeLater(this.setValue);
                    SwingUtilities.invokeLater(this.paintString);
                }
                this.parent.getDataLabel().setText(this.formatDataLabel(l2, l3));
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

