/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.ResetStatusThread;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import edu.sdsc.secureftp.gui.ViewSecurityInfoDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class StatusPanel
extends JPanel {
    private SecureFtpApplet parent;
    private JProgressBar progressBar = new JProgressBar(0, 100);
    private JTextField statusTextField = new JTextField(20);
    private JButton securityButton;

    public StatusPanel(SecureFtpApplet secureFtpApplet) {
        this.parent = secureFtpApplet;
        this.buildPanel(false);
    }

    public StatusPanel(SecureFtpApplet secureFtpApplet, boolean bl2) {
        this.parent = secureFtpApplet;
        this.buildPanel(bl2);
    }

    private void buildPanel(boolean bl2) {
        this.setLayout(new BorderLayout());
        this.progressBar.setPreferredSize(new Dimension(60, 20));
        this.progressBar.setBorder(BorderFactory.createEtchedBorder());
        if (bl2) {
            JPanel jPanel = new JPanel();
            jPanel.setPreferredSize(new Dimension(82, 20));
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)this.getSecurityButton(), "West");
            jPanel.add((Component)this.progressBar, "Center");
            this.add((Component)jPanel, "West");
        } else {
            this.add((Component)this.progressBar, "West");
        }
        this.statusTextField.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.statusTextField, "Center");
        this.statusTextField.setEditable(false);
        this.statusTextField.setFont(new Font("Dialog", 0, 9));
    }

    protected void delayedStatusReset(int n2) {
        new ResetStatusThread(this.statusTextField, n2).start();
    }

    protected JProgressBar getProgressBar() {
        return this.progressBar;
    }

    protected JButton getSecurityButton() {
        this.securityButton = this.parent.getServerUtil().isSecure() ? new JButton(new ImageIcon(this.getClass().getResource("images/locked.gif"))) : new JButton(new ImageIcon(this.getClass().getResource("images/unlocked.gif")));
        this.securityButton.setToolTipText(new LString("internal_frame.security.tooltip", "Security").getString());
        this.securityButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                debug.println("security button clicked", 3);
                new ViewSecurityInfoDialog(StatusPanel.this.parent, new LString("security_info.title", "Security information").getString(), true);
                StatusPanel.this.parent.getLocalPanel().requestFocus();
            }
        });
        this.securityButton.setPreferredSize(new Dimension(22, 20));
        this.securityButton.setBorder(BorderFactory.createEtchedBorder());
        return this.securityButton;
    }

    protected void setStatus(String string) {
        this.statusTextField.setText(string);
    }
}

