/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.Constants;
import edu.sdsc.secureftp.data.FileEntry;
import edu.sdsc.secureftp.data.FtpDelete;
import edu.sdsc.secureftp.data.HostInfo;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.ErrorDialog;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.OpenConnectionDialog;
import edu.sdsc.secureftp.gui.PasswordDialog;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import edu.sdsc.secureftp.gui.ServerListThread;
import edu.sdsc.secureftp.gui.ServerStatusThread;
import edu.sdsc.secureftp.network.Proxy;
import edu.sdsc.secureftp.network.exception.FtpBadLoginException;
import edu.sdsc.secureftp.network.exception.FtpCancelException;
import edu.sdsc.secureftp.network.exception.FtpConnectException;
import edu.sdsc.secureftp.network.exception.FtpConnectionLostException;
import edu.sdsc.secureftp.network.exception.FtpException;
import edu.sdsc.secureftp.network.exception.FtpNeedPasswordException;
import edu.sdsc.secureftp.network.exception.FtpNotADirectoryException;
import edu.sdsc.secureftp.network.exception.FtpPwdException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import javax.swing.JButton;

public class ServerUtil
implements Constants {
    private SecureFtpApplet parent;
    private HostInfo hostInfo;
    private ServerListThread listThread;
    private String transferMode = "U";
    private boolean secureConnection = false;
    private JButton securityButton;
    private String socksProxyHost = null;
    private String socksProxyPort = null;
    private boolean value = false;

    public ServerUtil(SecureFtpApplet secureFtpApplet) {
        this.parent = secureFtpApplet;
    }

    protected void cdup() {
        if (this.networkBusy()) {
            return;
        }
        try {
            try {
                this.parent.setNetworkStatus(3);
                this.parent.getFtpNet().cdup();
                this.parent.setNetworkStatus(0);
                this.pwd();
            }
            catch (FtpConnectionLostException ftpConnectionLostException) {
                this.notifyAndCleanUp();
            }
            catch (FtpException ftpException) {
                new ErrorDialog(ftpException.getMessage(), new LString("change_dir_failed.title", "Change directory failed").getString());
            }
            Object var2_2 = null;
            this.parent.setNetworkStatus(0);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.parent.setNetworkStatus(0);
            throw throwable;
        }
        this.list();
    }

    protected void changeDir(String string) throws FtpNotADirectoryException {
        if (this.networkBusy()) {
            return;
        }
        try {
            try {
                this.parent.setNetworkStatus(3);
                this.parent.getFtpNet().chdir(string);
                this.parent.setNetworkStatus(0);
                this.pwd();
            }
            catch (FtpConnectionLostException ftpConnectionLostException) {
                this.notifyAndCleanUp();
            }
            catch (FtpNotADirectoryException ftpNotADirectoryException) {
                throw ftpNotADirectoryException;
            }
            catch (FtpException ftpException) {
                new ErrorDialog(ftpException.getMessage(), new LString("change_dir_failed.title", "Change directory failed").getString());
            }
            Object var3_4 = null;
            this.parent.setNetworkStatus(0);
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.parent.setNetworkStatus(0);
            throw throwable;
        }
        this.list();
    }

    protected void closeConnection() {
        this.parent.getFtpNet().disconnect();
        this.parent.getServerPanel().removeAllRows();
        this.parent.getServerFrame().setTitle("Server");
        this.parent.getServerFrame().setVisible(false);
        this.parent.getServerFrame().dispose();
        this.enableOpenConnectionItems();
    }

    protected void delete(FileEntry[] fileEntryArray) {
        if (this.networkBusy()) {
            return;
        }
        try {
            try {
                this.parent.setNetworkStatus(7);
                new FtpDelete(this.parent, fileEntryArray);
            }
            catch (FtpConnectionLostException ftpConnectionLostException) {
                this.notifyAndCleanUp();
            }
            catch (FtpException ftpException) {
                new ErrorDialog(ftpException.getMessage(), new LString("delete_failed.title", "Delete failed").getString());
            }
            Object var3_3 = null;
            this.parent.setNetworkStatus(0);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.parent.setNetworkStatus(0);
            throw throwable;
        }
        this.list();
    }

    protected void disableAllConnectionItems() {
        this.parent.getMenuBar().disableConnectionMI();
        this.parent.getToolBar().disableConnectionTB();
    }

    protected void disableButtonBar() {
        this.getDeleteButton().setEnabled(true);
        this.getRenameButton().setEnabled(true);
    }

    protected void enableButtonBar() {
        this.getDeleteButton().setEnabled(true);
        this.getRenameButton().setEnabled(true);
    }

    protected void enableCloseConnectionItems() {
        this.parent.getMenuBar().closeConnectionMI();
        this.parent.getToolBar().closeConnectionTB();
    }

    protected void enableOpenConnectionItems() {
        this.parent.getMenuBar().openConnectionMI();
        this.parent.getToolBar().openConnectionTB();
    }

    public boolean fileExists(String string) {
        return this.parent.getServerPanel().getFileType(string) != null;
    }

    private JButton getDeleteButton() {
        return this.parent.getServerFrame().getDeleteButton();
    }

    private JButton getDownloadButton() {
        return this.parent.getServerFrame().getDownloadButton();
    }

    protected HostInfo getHostInfo() {
        return this.hostInfo;
    }

    public String getMode() {
        return this.transferMode;
    }

    private JButton getRenameButton() {
        return this.parent.getServerFrame().getRenameButton();
    }

    public String getSocksProxyHost() {
        debug.println("get socks proxy host = " + this.socksProxyHost, 3);
        return this.socksProxyHost;
    }

    public String getSocksProxyPort() {
        debug.println("get socks proxy port = " + this.socksProxyPort, 3);
        return this.socksProxyPort;
    }

    protected boolean isSecure() {
        return this.secureConnection;
    }

    public void list() {
        this.listThread = new ServerListThread(this);
        this.listThread.start();
    }

    protected void mkdir(String string) {
        if (this.networkBusy()) {
            return;
        }
        try {
            try {
                this.parent.setNetworkStatus(5);
                this.parent.getFtpNet().mkdir(string);
            }
            catch (FtpConnectionLostException ftpConnectionLostException) {
                this.notifyAndCleanUp();
            }
            catch (FtpException ftpException) {
                new ErrorDialog(ftpException.getMessage(), new LString("create_dir_failed.title", "Create directory failed").getString());
            }
            Object var3_3 = null;
            this.parent.setNetworkStatus(0);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.parent.setNetworkStatus(0);
            throw throwable;
        }
    }

    protected boolean needPassword() throws FtpBadLoginException {
        boolean bl2;
        HostInfo hostInfo = this.parent.getLocalData().getHostInfo();
        String string = (String)hostInfo.get("username");
        String string2 = (String)hostInfo.get("hostname");
        char[] cArray = PasswordDialog.getPassword(this.parent, String.valueOf(string) + "@" + string2);
        if (cArray != null) {
            try {
                if (cArray.length == 0) {
                    return this.needPassword();
                }
                this.parent.getFtpNet().pass(new String(cArray));
                bl2 = true;
            }
            catch (FtpBadLoginException ftpBadLoginException) {
                throw ftpBadLoginException;
            }
            catch (FtpException ftpException) {
                new ErrorDialog(ftpException.getMessage());
                bl2 = false;
            }
        } else {
            debug.println("password cancelled");
            bl2 = false;
        }
        return bl2;
    }

    protected boolean networkBusy() {
        return this.networkBusy(new LString("network_busy.in_progress.msg", "Operation in progress.").getString(), true);
    }

    protected boolean networkBusy(String string) {
        return this.networkBusy(string, true);
    }

    protected boolean networkBusy(String string, boolean bl2) {
        int n2 = this.parent.getNetworkStatus();
        switch (n2) {
            case 0: {
                debug.println("STATUS_FREE");
                break;
            }
            case 1: {
                debug.println("STATUS_UPLOAD");
                break;
            }
            case 2: {
                debug.println("STATUS_DOWNLOAD");
                break;
            }
            case 3: {
                debug.println("STATUS_CHANGEDIR");
                break;
            }
            case 4: {
                debug.println("STATUS_LIST");
                break;
            }
            case 5: {
                debug.println("STATUS_MAKEDIR");
                break;
            }
            case 6: {
                debug.println("STATUS_RENAME");
                break;
            }
            case 7: {
                debug.println("STATUS_DELETE");
                break;
            }
            case 8: {
                debug.println("STATUS_PWD");
                break;
            }
            default: {
                debug.println("@@@@@ UNKNOWN STATUS: " + n2);
            }
        }
        if (n2 == 4) {
            try {
                try {
                    this.parent.getFtpNet().abort();
                }
                catch (FtpException ftpException) {
                }
                Object var5_4 = null;
                this.parent.setNetworkStatus(0);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.parent.setNetworkStatus(0);
                throw throwable;
            }
        }
        if (n2 != 0) {
            if (bl2) {
                this.parent.getToolkit().beep();
            }
            this.parent.getServerFrame().setStatus(string);
            return true;
        }
        return false;
    }

    protected boolean networkBusy(boolean bl2) {
        return this.networkBusy(new LString("network_busy.in_progress.msg", "Operation in progress.").getString(), bl2);
    }

    protected void notifyAndCleanUp() {
        LString lString = new LString("connection_lost.msg", "The connection to the server has been lost.");
        new ErrorDialog(lString.getString(), new LString("connection_lost.title", "Connection lost").getString());
        this.parent.getServerFrame().dispose();
        this.enableOpenConnectionItems();
    }

    protected boolean openConnection(String string, String string2, String string3, String string4, boolean bl2, boolean bl3, String string5, String string6) {
        if (string == null || string2 == null || string5 == null) {
            return this.value;
        }
        if (string6 == null) {
            string6 = "";
        }
        this.hostInfo = new HostInfo();
        this.hostInfo.put("hostname", string);
        this.hostInfo.put("port", string2);
        this.hostInfo.put("pasv", new Boolean(bl2));
        this.hostInfo.put("ssldata", new Boolean(bl3));
        this.hostInfo.put("username", string5);
        this.hostInfo.put("password", string6);
        if (string3 == null || string4 == null) {
            Proxy.unsetProxy();
        } else {
            Proxy.setProxy(string3, string4);
        }
        this.parent.getLocalData().setHostInfo(this.hostInfo);
        try {
            this.parent.getFtpNet().connect();
        }
        catch (ConnectException connectException) {
            LString lString = new LString("connection_failed.msg", "Connection Failed: [^0]");
            lString.replace(0, connectException.getMessage());
            new ErrorDialog(lString.getString(), new LString("connection_failed.title", "Connection failed").getString());
            return false;
        }
        catch (UnknownHostException unknownHostException) {
            LString lString = new LString("unknown_host.msg", "Unknown Host: [^0]");
            lString.replace(0, unknownHostException.getMessage());
            new ErrorDialog(lString.getString(), new LString("connection_failed.title", "Connection failed").getString());
            return false;
        }
        catch (FtpConnectException ftpConnectException) {
            LString lString = new LString("connection_failed.msg", "Connection Failed: [^0]");
            lString.replace(0, ftpConnectException.getMessage());
            new ErrorDialog(lString.getString(), new LString("connection_failed.title", "Connection failed").getString());
            return false;
        }
        catch (FtpCancelException ftpCancelException) {
            return false;
        }
        catch (FtpException ftpException) {
            LString lString = new LString("connection_failed.msg", "Connection Failed: [^0]");
            lString.replace(0, ftpException.getMessage());
            new ErrorDialog(lString.getString());
            return false;
        }
        try {
            this.parent.getFtpNet().login();
            this.value = true;
        }
        catch (FtpNeedPasswordException ftpNeedPasswordException) {
            try {
                this.value = this.needPassword();
            }
            catch (FtpBadLoginException ftpBadLoginException) {
                this.value = this.reLogin();
            }
        }
        catch (FtpBadLoginException ftpBadLoginException) {
            this.value = this.reLogin();
        }
        catch (FtpException ftpException) {
            this.value = false;
            debug.println("Exception in login()", 1);
            new ErrorDialog(ftpException.getMessage(), new LString("login_error.title", "Login error").getString());
        }
        return this.value;
    }

    protected void openConnectionDialog() {
        OpenConnectionDialog openConnectionDialog = new OpenConnectionDialog(this.parent);
    }

    public void pwd() throws FtpException {
        if (this.networkBusy()) {
            return;
        }
        try {
            try {
                this.parent.setNetworkStatus(8);
                this.parent.getFtpNet().pwd();
                this.parent.getServerFrame().getDirTextField().setText(this.parent.getFtpNet().getDirName());
            }
            catch (FtpConnectionLostException ftpConnectionLostException) {
                this.notifyAndCleanUp();
            }
            catch (FtpPwdException ftpPwdException) {
                this.parent.getServerFrame().setStatus(ftpPwdException.getMessage());
                this.parent.getServerFrame().getDirTextField().setText("<" + new LString("unknown.msg", "unknown").getString() + ">");
            }
            Object var2_2 = null;
            this.parent.setNetworkStatus(0);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.parent.setNetworkStatus(0);
            throw throwable;
        }
    }

    protected boolean reLogin() {
        HostInfo hostInfo = this.parent.getLocalData().getHostInfo();
        boolean bl2 = false;
        try {
            this.parent.getFtpNet().user((String)hostInfo.get("username"));
            bl2 = true;
        }
        catch (FtpNeedPasswordException ftpNeedPasswordException) {
            try {
                bl2 = this.needPassword();
            }
            catch (FtpBadLoginException ftpBadLoginException) {
                bl2 = this.reLogin();
            }
        }
        catch (FtpException ftpException) {
            new ErrorDialog(ftpException.getMessage());
        }
        return bl2;
    }

    public void rename(String string, String string2) {
        if (this.networkBusy()) {
            return;
        }
        try {
            try {
                this.parent.setNetworkStatus(6);
                this.parent.getFtpNet().rename(string, string2);
            }
            catch (FtpConnectionLostException ftpConnectionLostException) {
                this.notifyAndCleanUp();
            }
            catch (FtpException ftpException) {
                new ErrorDialog(ftpException.getMessage(), new LString("rename_failed.title", "Rename Failed").getString());
            }
            Object var4_4 = null;
            this.parent.setNetworkStatus(0);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.parent.setNetworkStatus(0);
            throw throwable;
        }
    }

    public void runListThread() {
        if (this.networkBusy(false)) {
            return;
        }
        try {
            try {
                this.parent.getServerFrame().getStopButton().setEnabled(true);
                ServerStatusThread serverStatusThread = new ServerStatusThread(this.parent, this.parent.getServerFrame().getStatusPanel(), (int)this.parent.getServerData().getTransferSizeTotal(), new LString("listing_dir.msg", "Listing directory ...").getString());
                serverStatusThread.start();
                this.parent.getServerPanel().clearSelections();
                this.parent.getFtpNet().list();
                this.parent.getServerFrame().getStopButton().setEnabled(false);
                serverStatusThread.done();
            }
            catch (FtpConnectionLostException ftpConnectionLostException) {
                this.notifyAndCleanUp();
            }
            catch (FtpException ftpException) {
                this.parent.getServerFrame().setStatus(new LString("listing_failed.msg", "Listing failed").getString());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                debug.println("index out of bounds");
            }
            Object var2_2 = null;
            this.parent.setNetworkStatus(0);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.parent.setNetworkStatus(0);
            throw throwable;
        }
    }

    protected void setMode(String string) {
        this.transferMode = string;
        debug.println("transfer mode set to: " + string, 3);
    }

    protected void setSecure(boolean bl2) {
        this.secureConnection = bl2;
    }

    protected void setSocksProxyHost(String string) {
        if (string != null && string.trim().equals("")) {
            string = null;
        }
        debug.println("set socks proxy host = " + string, 3);
        this.socksProxyHost = string;
    }

    protected void setSocksProxyPort(String string) {
        if (string != null && string.trim().equals("")) {
            string = null;
        }
        debug.println("set socks proxy port = " + string, 3);
        this.socksProxyPort = string;
    }

    protected void setValue(boolean bl2) {
        this.value = bl2;
    }

    protected void stopList() {
        debug.println("listing stopped", 3);
        this.parent.getServerFrame().setStatus(new LString("listing_cancelled.msg", "Listing cancelled").getString());
        try {
            try {
                this.parent.getFtpNet().abort();
            }
            catch (FtpConnectionLostException ftpConnectionLostException) {
                this.notifyAndCleanUp();
            }
            catch (FtpException ftpException) {
            }
            Object var2_1 = null;
            this.parent.setNetworkStatus(0);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.parent.setNetworkStatus(0);
            throw throwable;
        }
        this.listThread.stop();
    }
}

