/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.Constants;
import edu.sdsc.secureftp.data.Bookmark;
import edu.sdsc.secureftp.data.BookmarkVector;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.AboutBox;
import edu.sdsc.secureftp.gui.AddBookmarkDialog;
import edu.sdsc.secureftp.gui.BookmarkListener;
import edu.sdsc.secureftp.gui.EditBookmarksDialog;
import edu.sdsc.secureftp.gui.ErrorDialog;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.ProxyDialog;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import edu.sdsc.secureftp.gui.Theme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class SecureFtpMenu
extends JMenuBar
implements Constants {
    private JMenu connection;
    private JMenu options;
    private JMenu bookmarks;
    private JMenu mode;
    private JMenu theme;
    private JMenu help;
    private JMenuItem openMI;
    private JMenuItem closeMI;
    private JMenuItem exitMI;
    private JMenuItem autoMI;
    private JMenuItem asciiMI;
    private JMenuItem binaryMI;
    private JMenuItem blueberryThemeMI;
    private JMenuItem cherryThemeMI;
    private JMenuItem limeThemeMI;
    private JMenuItem grapeThemeMI;
    private JMenuItem tangerineThemeMI;
    private JMenuItem otherThemeMI;
    private JMenuItem proxyMI;
    private JMenuItem sessionMI;
    private JMenuItem addBookmarkMI;
    private JMenuItem editBookmarkMI;
    private JMenuItem bookmarkMI;
    private JMenuItem helpMI;
    private JMenuItem aboutMI;
    private ActionListener autoListener;
    private ActionListener asciiListener;
    private ActionListener binaryListener;
    private ActionListener blueberryListener;
    private ActionListener cherryListener;
    private ActionListener limeListener;
    private ActionListener grapeListener;
    private ActionListener tangerineListener;
    private ActionListener otherListener;
    private ButtonGroup modeGroup = new ButtonGroup();
    private ButtonGroup themeGroup = new ButtonGroup();
    private Color selectedColor = null;
    private Vector modeItemVector = new Vector();
    private Vector modeActionVector = new Vector();
    private Vector themeItemVector = new Vector();
    private Vector themeActionVector = new Vector();
    private BookmarkVector bv;
    private SecureFtpApplet parent;

    public SecureFtpMenu(SecureFtpApplet secureFtpApplet) {
        this.parent = secureFtpApplet;
        this.getAccessibleContext().setAccessibleName("Menus");
        this.add(this.getConnectionMenu());
        this.add(this.getOptionsMenu());
        this.add(this.getBookmarksMenu());
        this.add(this.getMyHelpMenu());
        this.openConnectionMI();
        this.setMenuPrefs();
        if (System.getProperty("os.name").startsWith("Mac") && this.parent.isApplication()) {
            System.setProperty("com.apple.macos.useScreenMenuBar", "true");
        }
        this.updateUI();
        this.parent.setJMenuBar(this);
    }

    protected void addBookmark(Bookmark bookmark) {
        LString lString = new LString("unknown.msg", "unknown");
        JMenuItem jMenuItem = this.bookmarks.add(new JMenuItem(bookmark.getName()));
        String string = bookmark.getUsername().equals("") ? "<" + lString.getString() + ">" : bookmark.getUsername();
        jMenuItem.setToolTipText(String.valueOf(bookmark.getHostname()) + " - " + string);
        jMenuItem.addActionListener(new BookmarkListener(this.parent, bookmark));
        if (this.bookmarks.getItemCount() > 3) {
            this.editBookmarkMI.setEnabled(true);
        }
    }

    private void closeConnection() {
        this.parent.getServerUtil().closeConnection();
    }

    protected void closeConnectionMI() {
        this.openMI.setEnabled(false);
        this.closeMI.setEnabled(true);
        this.bookmarks.setEnabled(false);
    }

    protected void disableConnectionMI() {
        this.openMI.setEnabled(false);
        this.closeMI.setEnabled(false);
        this.bookmarks.setEnabled(false);
    }

    protected void editBookmark(Bookmark bookmark, int n2) {
        JMenuItem jMenuItem = this.bookmarks.getItem(n2 + 3);
        jMenuItem.setText(bookmark.getName());
        String string = bookmark.getUsername().equals("") ? "<unknown>" : bookmark.getUsername();
        jMenuItem.setToolTipText(String.valueOf(bookmark.getHostname()) + " - " + string);
    }

    protected int getBookmarkCount() {
        return this.bookmarks.getItemCount();
    }

    private JMenu getBookmarksMenu() {
        this.bookmarks = new JMenu(new LString("menu.bookmarks.label", "Bookmarks").getString());
        this.bookmarks.setMnemonic(new LString("menu.bookmarks.mnemonic", "B").getFirstChar());
        this.addBookmarkMI = this.bookmarks.add(new JMenuItem(new LString("menu.add_bookmark.label", "Add Bookmark ...").getString()));
        this.addBookmarkMI.setMnemonic(new LString("menu.add_bookmark.mnemonic", "A").getFirstChar());
        if (!System.getProperty("os.name").startsWith("Mac")) {
            this.addBookmarkMI.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        } else {
            this.addBookmarkMI.setAccelerator(KeyStroke.getKeyStroke(68, 4));
        }
        this.addBookmarkMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new AddBookmarkDialog(SecureFtpMenu.this.parent);
            }
        });
        this.editBookmarkMI = this.bookmarks.add(new JMenuItem(new LString("menu.edit_bookmarks.label", "Edit Bookmarks ...").getString()));
        this.editBookmarkMI.setMnemonic(new LString("menu.edit_bookmarks.mnemonic", "E").getFirstChar());
        if (!System.getProperty("os.name").startsWith("Mac")) {
            this.editBookmarkMI.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        } else {
            this.editBookmarkMI.setAccelerator(KeyStroke.getKeyStroke(66, 4));
        }
        this.editBookmarkMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new EditBookmarksDialog(SecureFtpMenu.this.parent);
            }
        });
        this.bookmarks.addSeparator();
        this.bv = this.parent.getBookmarks();
        if (this.bv.size() == 0) {
            this.editBookmarkMI.setEnabled(false);
        }
        int n2 = 0;
        while (n2 < this.bv.size()) {
            Bookmark bookmark = (Bookmark)this.bv.get(n2);
            String string = bookmark.getUsername().equals("") ? new LString("unknown_host.tooltip", "<unknown>").getString() : bookmark.getUsername();
            JMenuItem jMenuItem = this.bookmarks.add(new JMenuItem(bookmark.getName()));
            jMenuItem.setToolTipText(String.valueOf(bookmark.getHostname()) + " - " + string);
            jMenuItem.addActionListener(new BookmarkListener(this.parent, bookmark));
            ++n2;
        }
        return this.bookmarks;
    }

    private JMenu getConnectionMenu() {
        this.connection = new JMenu(new LString("menu.connection.label", "Connection").getString());
        this.connection.setMnemonic(new LString("menu.connection.mnemonic", "C").getFirstChar());
        this.openMI = this.connection.add(new JMenuItem(new LString("menu.open.label", "Open ...").getString()));
        this.openMI.setMnemonic(new LString("menu.open.mnemonic", "O").getFirstChar());
        if (!System.getProperty("os.name").startsWith("Mac")) {
            this.openMI.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        } else {
            this.openMI.setAccelerator(KeyStroke.getKeyStroke(79, 4));
        }
        this.openMI.getAccessibleContext().setAccessibleDescription("Connect to FTP server");
        this.openMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecureFtpMenu.this.openConnectionDialog();
            }
        });
        this.closeMI = this.connection.add(new JMenuItem(new LString("menu.close.label", "Close").getString()));
        this.closeMI.setMnemonic(new LString("menu.close.mnemonic", "l").getFirstChar());
        if (!System.getProperty("os.name").startsWith("Mac")) {
            this.closeMI.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        } else {
            this.closeMI.setAccelerator(KeyStroke.getKeyStroke(87, 4));
        }
        this.closeMI.setEnabled(false);
        this.closeMI.getAccessibleContext().setAccessibleDescription("Disconnect from FTP server");
        this.closeMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecureFtpMenu.this.closeConnection();
            }
        });
        this.connection.addSeparator();
        this.exitMI = this.connection.add(new JMenuItem(new LString("menu.exit.label", "Exit").getString()));
        this.exitMI.setMnemonic(new LString("menu.exit.mnemonic", "E").getFirstChar());
        if (!System.getProperty("os.name").startsWith("Mac")) {
            this.exitMI.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        } else {
            this.exitMI.setAccelerator(KeyStroke.getKeyStroke(81, 4));
        }
        this.exitMI.getAccessibleContext().setAccessibleDescription("Exit");
        this.exitMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SecureFtpMenu.this.parent.getFtpNet() != null && SecureFtpMenu.this.parent.getFtpNet().isConnected()) {
                    SecureFtpMenu.this.parent.getFtpNet().disconnect();
                }
                SecureFtpMenu.this.parent.savePrefs();
                System.exit(0);
            }
        });
        if (!this.parent.isApplication()) {
            this.exitMI.setEnabled(false);
        }
        return this.connection;
    }

    private JMenu getModeMenu() {
        this.mode = new JMenu(new LString("menu.transfer.label", "Transfer Mode").getString());
        this.mode.setMnemonic(new LString("menu.transfer.mnemonic", "M").getFirstChar());
        this.autoMI = this.mode.add(new JRadioButtonMenuItem(new LString("menu.auto.label", "Auto").getString()));
        this.autoMI.setMnemonic(new LString("menu.auto.mnemonic", "u").getFirstChar());
        this.autoMI.getAccessibleContext().setAccessibleDescription("Auto mode");
        this.autoListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecureFtpMenu.this.parent.getServerUtil().setMode("U");
                if (SecureFtpMenu.this.parent.getToolBar() != null) {
                    SecureFtpMenu.this.parent.getToolBar().setMode(0);
                }
                SecureFtpMenu.this.writeModePrefs(0);
            }
        };
        this.autoMI.addActionListener(this.autoListener);
        this.binaryMI = this.mode.add(new JRadioButtonMenuItem(new LString("menu.binary.label", "Binary").getString()));
        this.binaryMI.setMnemonic(new LString("menu.binary.mnemonic", "B").getFirstChar());
        this.binaryMI.getAccessibleContext().setAccessibleDescription("Binary mode");
        this.binaryListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecureFtpMenu.this.parent.getServerUtil().setMode("B");
                if (SecureFtpMenu.this.parent.getToolBar() != null) {
                    SecureFtpMenu.this.parent.getToolBar().setMode(1);
                }
                SecureFtpMenu.this.writeModePrefs(1);
            }
        };
        this.binaryMI.addActionListener(this.binaryListener);
        this.asciiMI = this.mode.add(new JRadioButtonMenuItem(new LString("menu.ascii.label", "Text").getString()));
        this.asciiMI.setMnemonic(new LString("menu.ascii.mnemonic", "x").getFirstChar());
        this.asciiMI.getAccessibleContext().setAccessibleDescription("Figure out which mode to transfer data");
        this.asciiListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecureFtpMenu.this.parent.getServerUtil().setMode("A");
                if (SecureFtpMenu.this.parent.getToolBar() != null) {
                    SecureFtpMenu.this.parent.getToolBar().setMode(2);
                }
                SecureFtpMenu.this.writeModePrefs(2);
            }
        };
        this.asciiMI.addActionListener(this.asciiListener);
        this.modeItemVector.addElement(this.autoMI);
        this.modeItemVector.addElement(this.binaryMI);
        this.modeItemVector.addElement(this.asciiMI);
        this.modeActionVector.addElement(this.autoListener);
        this.modeActionVector.addElement(this.binaryListener);
        this.modeActionVector.addElement(this.asciiListener);
        this.modeGroup.add(this.autoMI);
        this.modeGroup.add(this.binaryMI);
        this.modeGroup.add(this.asciiMI);
        return this.mode;
    }

    private JMenu getMyHelpMenu() {
        this.help = new JMenu(new LString("menu.help.label", "Help").getString());
        this.help.setMnemonic(new LString("menu.help.mnemonic", "H").getFirstChar());
        this.helpMI = this.help.add(new JMenuItem(new LString("menu.help_contents.label", "Help ...").getString()));
        this.helpMI.setMnemonic(new LString("menu.help_contents.mnemonic", "p").getFirstChar());
        this.helpMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecureFtpMenu.this.parent.displayHelp();
            }
        });
        this.help.addSeparator();
        this.aboutMI = this.help.add(new JMenuItem(new LString("menu.about.label", "About Secure FTP ...").getString()));
        this.aboutMI.getAccessibleContext().setAccessibleDescription("Display About info");
        this.aboutMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new AboutBox(SecureFtpMenu.this.parent);
            }
        });
        return this.help;
    }

    private JMenu getOptionsMenu() {
        this.options = new JMenu(new LString("menu.options.label", "Options").getString());
        this.options.setMnemonic(new LString("menu.options.mnemonic", "O").getFirstChar());
        this.options.add(this.getModeMenu());
        this.proxyMI = this.options.add(new JMenuItem(new LString("menu.proxy.label", "Proxy ...").getString()));
        this.proxyMI.setMnemonic(new LString("menu.proxy.mnemonic", "y").getFirstChar());
        this.proxyMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new ProxyDialog(SecureFtpMenu.this.parent);
            }
        });
        if (!System.getProperty("os.name").startsWith("Mac")) {
            this.options.add(this.getThemeMenu());
        }
        this.options.addSeparator();
        this.sessionMI = this.options.add(new JMenuItem(new LString("menu.session.label", "Session Log ...").getString()));
        this.sessionMI.setMnemonic(new LString("menu.session.mnemonic", "S").getFirstChar());
        if (!System.getProperty("os.name").startsWith("Mac")) {
            this.sessionMI.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        } else {
            this.sessionMI.setAccelerator(KeyStroke.getKeyStroke(76, 4));
        }
        this.sessionMI.getAccessibleContext().setAccessibleDescription("Display server responses");
        this.sessionMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecureFtpMenu.this.parent.getSessionLoggingFrame().setVisible(true);
                SecureFtpMenu.this.parent.getSessionLoggingFrame().getScrollPane().revalidate();
                SecureFtpMenu.this.parent.getDesktopPane().revalidate();
            }
        });
        return this.options;
    }

    private JMenu getThemeMenu() {
        this.theme = new JMenu(new LString("menu.theme.label", "Theme").getString());
        this.theme.setMnemonic(new LString("menu.theme.mnemonic", "T").getFirstChar());
        this.blueberryThemeMI = this.theme.add(new JRadioButtonMenuItem(new LString("menu.theme_blueberry.label", "Blueberry").getString()));
        this.blueberryListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = new Color(85, 150, 200);
                SecureFtpMenu.this.setTheme(new Theme(new Color(64, 109, 148), color, new Color(130, 170, 240)));
                SecureFtpMenu.this.writeThemePrefs(0, color);
            }
        };
        this.blueberryThemeMI.addActionListener(this.blueberryListener);
        this.cherryThemeMI = this.theme.add(new JRadioButtonMenuItem(new LString("menu.theme_cherry.label", "Cherry").getString()));
        this.cherryListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = new Color(204, 153, 153);
                SecureFtpMenu.this.setTheme(new Theme(new Color(153, 102, 102), color, new Color(255, 204, 204)));
                SecureFtpMenu.this.writeThemePrefs(1, color);
            }
        };
        this.cherryThemeMI.addActionListener(this.cherryListener);
        this.grapeThemeMI = this.theme.add(new JRadioButtonMenuItem(new LString("menu.theme_grape.label", "Grape").getString()));
        this.grapeListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = new Color(153, 153, 204);
                SecureFtpMenu.this.setTheme(new Theme(new Color(102, 102, 153), color, new Color(204, 204, 255)));
                SecureFtpMenu.this.writeThemePrefs(2, color);
            }
        };
        this.grapeThemeMI.addActionListener(this.grapeListener);
        this.limeThemeMI = this.theme.add(new JRadioButtonMenuItem(new LString("menu.theme_lime.label", "Lime").getString()));
        this.limeListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = new Color(153, 204, 153);
                SecureFtpMenu.this.setTheme(new Theme(new Color(102, 153, 102), color, new Color(204, 255, 204)));
                SecureFtpMenu.this.writeThemePrefs(3, color);
            }
        };
        this.limeThemeMI.addActionListener(this.limeListener);
        this.tangerineThemeMI = this.theme.add(new JRadioButtonMenuItem(new LString("menu.theme_tangerine.label", "Tangerine").getString()));
        this.tangerineListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = new Color(239, 151, 50);
                SecureFtpMenu.this.setTheme(new Theme(new Color(200, 100, 70), color, new Color(255, 200, 160)));
                SecureFtpMenu.this.writeThemePrefs(4, color);
            }
        };
        this.tangerineThemeMI.addActionListener(this.tangerineListener);
        this.theme.addSeparator();
        this.otherThemeMI = this.theme.add(new JRadioButtonMenuItem(new LString("menu.theme_other.label", "Other ...").getString()));
        this.otherListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SecureFtpMenu.this.selectedColor == null) {
                    SecureFtpMenu.this.selectedColor = JColorChooser.showDialog(SecureFtpMenu.this.parent.getContentPane(), "Color Selection", MetalLookAndFeel.getDesktopColor());
                }
                if (SecureFtpMenu.this.selectedColor != null) {
                    SecureFtpMenu.this.setTheme(new Theme(new Color(102, 102, 102), SecureFtpMenu.this.selectedColor, new Color(204, 204, 204)));
                    SecureFtpMenu.this.writeThemePrefs(5, SecureFtpMenu.this.selectedColor);
                    SecureFtpMenu.this.selectedColor = null;
                }
            }
        };
        this.otherThemeMI.addActionListener(this.otherListener);
        this.themeItemVector.addElement(this.blueberryThemeMI);
        this.themeItemVector.addElement(this.cherryThemeMI);
        this.themeItemVector.addElement(this.grapeThemeMI);
        this.themeItemVector.addElement(this.limeThemeMI);
        this.themeItemVector.addElement(this.tangerineThemeMI);
        this.themeItemVector.addElement(this.otherThemeMI);
        this.themeActionVector.addElement(this.blueberryListener);
        this.themeActionVector.addElement(this.cherryListener);
        this.themeActionVector.addElement(this.grapeListener);
        this.themeActionVector.addElement(this.limeListener);
        this.themeActionVector.addElement(this.tangerineListener);
        this.themeActionVector.addElement(this.otherListener);
        this.themeGroup.add(this.blueberryThemeMI);
        this.themeGroup.add(this.cherryThemeMI);
        this.themeGroup.add(this.grapeThemeMI);
        this.themeGroup.add(this.limeThemeMI);
        this.themeGroup.add(this.tangerineThemeMI);
        this.themeGroup.add(this.otherThemeMI);
        return this.theme;
    }

    protected void moveBookmark(Bookmark bookmark, int n2, int n3) {
        JMenuItem jMenuItem = new JMenuItem(bookmark.getName());
        jMenuItem.addActionListener(new BookmarkListener(this.parent, bookmark));
        String string = bookmark.getUsername().equals("") ? "<unknown>" : bookmark.getUsername();
        jMenuItem.setToolTipText(String.valueOf(bookmark.getHostname()) + " - " + string);
        this.bookmarks.remove(n2 + 3);
        this.bookmarks.insert(jMenuItem, n3 + 3);
    }

    private void openConnectionDialog() {
        this.parent.getServerUtil().openConnectionDialog();
    }

    protected void openConnectionMI() {
        this.openMI.setEnabled(true);
        this.closeMI.setEnabled(false);
        this.bookmarks.setEnabled(true);
    }

    protected void removeBookmark(int n2) {
        this.bookmarks.remove(n2 + 3);
        this.bookmarks.repaint();
        this.editBookmarkMI.setEnabled(this.bookmarks.getItemCount() > 3);
    }

    private void setMenuPrefs() {
        int n2 = this.parent.getPrefs().getThemeIndex();
        if (n2 == 5) {
            this.selectedColor = this.parent.getPrefs().getThemeColor();
        }
        if (!System.getProperty("os.name").startsWith("Mac")) {
            this.setThemeFromPrefs(n2);
        }
        this.setModeFromPrefs(this.parent.getPrefs().getTransferMode());
    }

    protected void setMode(int n2) {
        ((JRadioButtonMenuItem)this.modeItemVector.elementAt(n2)).setSelected(true);
    }

    protected void setModeFromPrefs(int n2) {
        ((JRadioButtonMenuItem)this.modeItemVector.elementAt(n2)).setSelected(true);
        ((ActionListener)this.modeActionVector.elementAt(n2)).actionPerformed(new ActionEvent(this, 1001, "preference"));
    }

    protected void setTheme(DefaultMetalTheme defaultMetalTheme) {
        MetalLookAndFeel.setCurrentTheme(defaultMetalTheme);
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            debug.println("problem setting theme");
        }
        this.updateComponents(this.parent.getContentPane());
    }

    private void setThemeFromPrefs(int n2) {
        ((JRadioButtonMenuItem)this.themeItemVector.elementAt(n2)).setSelected(true);
        ((ActionListener)this.themeActionVector.elementAt(n2)).actionPerformed(new ActionEvent(this, 1001, "preference"));
    }

    protected void updateComponents(Component component) {
        if (component instanceof JButton) {
            return;
        }
        if (component instanceof JComponent) {
            ((JComponent)component).updateUI();
        }
        Component[] componentArray = null;
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray != null) {
            int n2 = 0;
            while (n2 < componentArray.length) {
                this.updateComponents(componentArray[n2]);
                ++n2;
            }
        }
    }

    private void writeModePrefs(int n2) {
        this.parent.getPrefs().setTransferMode(n2);
        try {
            this.parent.getPrefs().writePreferences();
        }
        catch (Exception exception) {
            new ErrorDialog(exception.getMessage(), "Failed To Write Preferences");
        }
    }

    private void writeThemePrefs(int n2, Color color) {
        this.parent.getPrefs().setThemeIndex(n2);
        this.parent.getPrefs().setThemeColor(color);
        try {
            this.parent.getPrefs().writePreferences();
        }
        catch (Exception exception) {
            new ErrorDialog(exception.getMessage(), "Failed To Write Preferences");
        }
    }
}

