/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.Constants;
import edu.sdsc.secureftp.data.BookmarkVector;
import edu.sdsc.secureftp.data.Data;
import edu.sdsc.secureftp.data.HostInfo;
import edu.sdsc.secureftp.data.Preferences;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.EULADialog;
import edu.sdsc.secureftp.gui.ErrorDialog;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.LocalFrame;
import edu.sdsc.secureftp.gui.LocalListPanel;
import edu.sdsc.secureftp.gui.LocalUtil;
import edu.sdsc.secureftp.gui.SecureFtpMenu;
import edu.sdsc.secureftp.gui.SecureFtpToolBar;
import edu.sdsc.secureftp.gui.SecurityVectorThread;
import edu.sdsc.secureftp.gui.ServerFrame;
import edu.sdsc.secureftp.gui.ServerListPanel;
import edu.sdsc.secureftp.gui.ServerUtil;
import edu.sdsc.secureftp.gui.SessionLoggingFrame;
import edu.sdsc.secureftp.gui.SplashThread;
import edu.sdsc.secureftp.gui.TransferStatusDialog;
import edu.sdsc.secureftp.help.HelpViewerThread;
import edu.sdsc.secureftp.network.BasicFtp;
import edu.sdsc.secureftp.network.SSLInit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.File;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SecureFtpApplet
extends JApplet
implements Constants {
    private BasicFtp net;
    private BookmarkVector bookmarks;
    private boolean app;
    private Data localData;
    private Data serverData;
    private HelpViewerThread help;
    private int networkStatus = 0;
    private JDesktopPane desktopPane;
    private JFrame applicationFrame;
    private LocalFrame localFrame;
    private LocalUtil localUtil;
    private Preferences prefs = null;
    private SSLInit sslInit;
    private SecureFtpMenu menubar;
    private SecureFtpToolBar toolbar;
    private ServerUtil serverUtil;
    private ServerFrame serverFrame;
    private SessionLoggingFrame sessionFrame;
    private String secureFtpHomeDir;
    private TransferStatusDialog transferDialog;
    protected Vector securityVector = new Vector();
    protected String initialFrame = null;

    protected void createFtpHomeDirectory() {
        File file;
        String string = System.getProperty("SECUREFTP_HOME");
        if (string == null || string.trim().equals("")) {
            string = String.valueOf(System.getProperty("user.home")) + File.separator + ".secureftp";
        }
        if (!(file = new File(string)).isAbsolute()) {
            file = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + string);
        }
        if (!file.isDirectory()) {
            new EULADialog(this);
            if (!file.mkdirs()) {
                LString lString = new LString("failed_to_make_dir.msg", "Failed to make directory \"[^0]\"");
                lString.replace(0, file.getAbsolutePath());
                new ErrorDialog(lString.getString(), new LString("failed_to_make_dir.title", "Failed to make directory").getString());
            }
        }
        this.secureFtpHomeDir = file.getAbsolutePath();
        debug.println("secureftp hd: " + this.secureFtpHomeDir);
    }

    protected void createServerFrame() {
        this.serverFrame = new ServerFrame(this, this.net);
        this.desktopPane.add((Component)this.serverFrame, new Integer(0));
        this.desktopPane.revalidate();
    }

    public void displayHelp() {
        try {
            this.help.join();
            this.help.getHelpViewer().getHelpBroker().setDisplayed(true);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected Frame getBaseFrame() {
        Container container = this.getContentPane();
        Frame frame = container == null ? JOptionPane.getRootFrame() : (container instanceof Frame ? (Frame)container : JOptionPane.getFrameForComponent(container.getParent()));
        return frame;
    }

    protected BookmarkVector getBookmarks() {
        return this.bookmarks;
    }

    protected JDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    public String getFtpHomeDirectory() {
        return this.secureFtpHomeDir;
    }

    public BasicFtp getFtpNet() {
        return this.net;
    }

    public HostInfo getHostInfo() {
        return this.serverUtil.getHostInfo();
    }

    public String getHostName() {
        return (String)this.serverUtil.getHostInfo().get("hostname");
    }

    public Data getLocalData() {
        return this.localData;
    }

    public LocalFrame getLocalFrame() {
        return this.localFrame;
    }

    public LocalListPanel getLocalPanel() {
        return this.localFrame.getLocalPanel();
    }

    public LocalUtil getLocalUtil() {
        return this.localUtil;
    }

    protected SecureFtpMenu getMenuBar() {
        return this.menubar;
    }

    public int getNetworkStatus() {
        return this.networkStatus;
    }

    protected Preferences getPrefs() {
        block2: {
            if (this.prefs != null) break block2;
            this.createFtpHomeDirectory();
            this.prefs = new Preferences(String.valueOf(this.getFtpHomeDirectory()) + File.separator + "preferences");
            try {
                this.prefs.readPreferences();
            }
            catch (Exception exception) {
                new ErrorDialog(exception.getMessage(), new LString("failed_to_read_prefs.msg", "Failed to read preferences").getString());
            }
        }
        return this.prefs;
    }

    public SSLInit getSSLInit() {
        return this.sslInit;
    }

    public Data getServerData() {
        return this.serverData;
    }

    public ServerFrame getServerFrame() {
        return this.serverFrame;
    }

    public ServerListPanel getServerPanel() {
        return this.serverFrame.getServerPanel();
    }

    public ServerUtil getServerUtil() {
        return this.serverUtil;
    }

    public SessionLoggingFrame getSessionLoggingFrame() {
        return this.sessionFrame;
    }

    protected SecureFtpToolBar getToolBar() {
        return this.toolbar;
    }

    public TransferStatusDialog getTransferStatusDialog() {
        return this.transferDialog;
    }

    public void init() {
        this.setVisible(false);
        SplashThread splashThread = new SplashThread();
        splashThread.start();
        this.help = new HelpViewerThread();
        this.help.start();
        if (!this.app) {
            this.prefs = this.getPrefs();
            this.prefs.setWidth(this.getWidth());
            this.prefs.setHeight(this.getHeight());
        }
        this.bookmarks = new BookmarkVector(String.valueOf(this.getFtpHomeDirectory()) + File.separator + "bookmarks");
        try {
            this.bookmarks.readFromDisk();
        }
        catch (Exception exception) {
            new ErrorDialog(exception.getMessage(), new LString("failed_to_read_bookmarks.msg", "Failed to read bookmarks.").getString());
        }
        this.localData = new Data(this);
        this.serverData = new Data(this);
        this.sslInit = new SSLInit();
        this.sslInit.start();
        new SecurityVectorThread(this, this.securityVector, this.localData, this.serverData).start();
        this.serverUtil = new ServerUtil(this);
        this.localUtil = new LocalUtil(this);
        this.setProxyPrefs();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        if (this.isApplication()) {
            this.menubar = new SecureFtpMenu(this);
            container.add((Component)this.menubar, "North");
        } else {
            this.menubar = new SecureFtpMenu(this);
        }
        this.desktopPane = new JDesktopPane();
        this.desktopPane.setOpaque(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        this.toolbar = new SecureFtpToolBar(this);
        jPanel.add((Component)this.toolbar, "North");
        jPanel.add((Component)this.desktopPane, "Center");
        this.localFrame = new LocalFrame(this);
        this.desktopPane.add((Component)this.localFrame, new Integer(0));
        this.sessionFrame = new SessionLoggingFrame(this);
        this.desktopPane.add((Component)this.sessionFrame, new Integer(0));
        if (!this.app) {
            this.prefs.setInternalWidth(this.getLocalFrame().getWidth());
            this.prefs.setInternalHeight(this.getLocalFrame().getHeight());
        }
        this.localFrame.getListing();
        this.desktopPane.revalidate();
        splashThread.done();
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {}
        this.setVisible(true);
    }

    protected boolean isApplication() {
        return this.app;
    }

    public void savePrefs() {
        debug.println("width = " + this.getWidth() + " height = " + this.getHeight(), 4);
        this.prefs.setWidth(this.applicationFrame.getWidth());
        this.prefs.setHeight(this.applicationFrame.getHeight());
        this.prefs.setInternalWidth(this.getLocalFrame().getWidth());
        this.prefs.setInternalHeight(this.getLocalFrame().getHeight());
        try {
            this.prefs.writePreferences();
        }
        catch (Exception exception) {
            new ErrorDialog(exception.getMessage(), new LString("failed_to_write_prefs.msg", "Failed to write preferences.").getString());
        }
    }

    protected void setApp(boolean bl2) {
        this.app = bl2;
    }

    protected void setAppFrame(JFrame jFrame) {
        this.applicationFrame = jFrame;
    }

    public void setFtpNet(BasicFtp basicFtp) {
        this.net = basicFtp;
    }

    public void setNetworkStatus(int n2) {
        this.networkStatus = n2;
        debug.println("network status = " + n2, 3);
    }

    private void setProxyPrefs() {
        String string = this.getPrefs().getHttpProxyHost();
        String string2 = this.getPrefs().getHttpProxyPort();
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        System.setProperty("http.proxyHost", string.trim());
        System.setProperty("http.proxyPort", string2.trim());
        if (string.trim().equals("") || string2.trim().equals("")) {
            System.setProperty("http.proxySet", "false");
        } else {
            System.setProperty("http.proxySet", "true");
        }
        this.getServerUtil().setSocksProxyHost(this.getPrefs().getSocksProxyHost());
        this.getServerUtil().setSocksProxyPort(this.getPrefs().getSocksProxyPort());
    }

    protected void setTransferStatusDialog(TransferStatusDialog transferStatusDialog) {
        this.transferDialog = transferStatusDialog;
    }
}

