/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.data.CertificateInfo;
import edu.sdsc.secureftp.gui.LString;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SSLSecurityPanel
extends JPanel {
    protected GridBagConstraints gbc = new GridBagConstraints();
    private CertificateInfo certInfo;
    private JPanel infoPanel;
    private int colx1 = 0;
    private int colx2 = 0;

    public SSLSecurityPanel(X509Certificate x509Certificate) {
        this.certInfo = new CertificateInfo(x509Certificate);
        this.setPreferredSize(new Dimension(400, 200));
        this.infoPanel = new JPanel();
        this.infoPanel.setLayout(new GridBagLayout());
        this.infoPanel.add(Box.createVerticalStrut(5), this.getGBC(0, 18, 0.5, 1.0, 0, this.colx1++, 1, 1));
        this.infoPanel.add(Box.createVerticalStrut(5), this.getGBC(0, 18, 0.5, 1.0, 2, this.colx2++, 1, 1));
        this.infoPanel.add((Component)new JLabel("  " + new LString("ssl_panel.certificate.label", "Certificate").getString() + ":"), this.getGBC(0, 18, 0.5, 1.0, 0, this.colx1++, 1, 1));
        this.infoPanel.add((Component)new JLabel(String.valueOf(new LString("ssl_panel.issued_by.label", "Issued By").getString()) + ":"), this.getGBC(0, 18, 0.5, 1.0, 2, this.colx2++, 1, 1));
        this.infoPanel.add((Component)this.getCNLabel(), this.getGBC(0, 18, 0.5, 1.0, 0, this.colx1, 1, 1));
        this.infoPanel.add((Component)this.getICNLabel(), this.getGBC(0, 18, 0.5, 1.0, 2, this.colx2, 1, 1));
        this.infoPanel.add((Component)this.getEmailLabel(), this.getGBC(0, 18, 0.5, 1.0, 0, this.colx1, 1, 1));
        this.infoPanel.add((Component)this.getIOULabel(), this.getGBC(0, 18, 0.5, 1.0, 2, this.colx2, 1, 1));
        this.infoPanel.add((Component)this.getOULabel(), this.getGBC(0, 18, 0.5, 1.0, 0, this.colx1, 1, 1));
        this.infoPanel.add((Component)this.getIOrgLabel(), this.getGBC(0, 18, 0.5, 1.0, 2, this.colx2, 1, 1));
        this.infoPanel.add((Component)this.getOrgLabel(), this.getGBC(0, 18, 0.5, 1.0, 0, this.colx1, 1, 1));
        this.infoPanel.add((Component)this.getICountryLabel(), this.getGBC(0, 18, 0.5, 1.0, 2, this.colx2, 1, 1));
        this.infoPanel.add((Component)this.getCityStateCountryLabel(), this.getGBC(0, 18, 0.5, 1.0, 0, this.colx1, 1, 1));
        this.infoPanel.add((Component)this.getSerialNumberLabel(), this.getGBC(0, 17, 1.0, 1.0, 0, ++this.colx1, 4, 1));
        this.infoPanel.add((Component)this.getDateLabel(), this.getGBC(0, 18, 1.0, 1.0, 0, ++this.colx1, 4, 1));
        this.infoPanel.add((Component)this.getFingerprintLabel(), this.getGBC(0, 18, 1.0, 1.0, 0, ++this.colx1, 4, 1));
        this.infoPanel.add((Component)this.getFingerprint(), this.getGBC(0, 18, 1.0, 1.0, 0, ++this.colx1, 4, 1));
        this.setLayout(new BorderLayout());
        this.add((Component)this.infoPanel, "North");
    }

    protected JLabel getCNLabel() {
        JLabel jLabel;
        String string = "       " + this.certInfo.getCN();
        if (string == null || string.trim().equals("null")) {
            jLabel = new JLabel("");
        } else {
            jLabel = new JLabel(string);
            ++this.colx1;
        }
        jLabel.setFont(new Font("Dialog", 0, 10));
        return jLabel;
    }

    protected JLabel getCityStateCountryLabel() {
        String string = this.certInfo.getLocality();
        String string2 = this.certInfo.getState();
        String string3 = this.certInfo.getCountry();
        if (string == null || string.trim().equals("null")) {
            string = "";
        }
        if (string2 == null || string2.trim().equals("null")) {
            string2 = "";
        } else if (string != null && !string.equals("")) {
            string2 = ", " + string2;
        }
        if (string3 == null || string3.trim().equals("null")) {
            string3 = "";
        } else if (string2 != null && !string2.equals("")) {
            string3 = ", " + string3;
        }
        String string4 = "       " + string + string2 + string3;
        JLabel jLabel = new JLabel(string4);
        if (!string4.trim().equals("")) {
            ++this.colx1;
        }
        jLabel.setFont(new Font("Dialog", 0, 10));
        return jLabel;
    }

    protected JLabel getDateLabel() {
        DateFormat dateFormat = DateFormat.getDateInstance(2);
        LString lString = new LString("ssl_panel.cert_valid.msg", "This certificate is valid from [^0] to [^1]");
        lString.replace(0, dateFormat.format(this.certInfo.getStartDate()));
        lString.replace(1, dateFormat.format(this.certInfo.getEndDate()));
        JLabel jLabel = new JLabel("    " + lString.getString());
        jLabel.setFont(new Font("Dialog", 0, 10));
        return jLabel;
    }

    protected JLabel getEmailLabel() {
        JLabel jLabel;
        String string = "       " + this.certInfo.getEmail();
        if (string == null || string.trim().equals("null")) {
            jLabel = new JLabel("");
        } else {
            jLabel = new JLabel(string);
            ++this.colx1;
        }
        jLabel.setFont(new Font("Dialog", 0, 10));
        return jLabel;
    }

    protected JLabel getFingerprint() {
        String string = "       " + this.certInfo.getFingerprint();
        JLabel jLabel = string.trim().equals("null") ? new JLabel(new LString("unknown.msg", "unknown").getString()) : new JLabel(string);
        jLabel.setFont(new Font("Dialog", 0, 10));
        return jLabel;
    }

    protected JLabel getFingerprintLabel() {
        String string = "    " + new LString("ssl_panel.cert_fingerprint.label", "Certificate Fingerprint").getString() + ":";
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font("Dialog", 0, 10));
        return jLabel;
    }

    protected GridBagConstraints getGBC(int n2, int n3, double d10, double d11, int n4, int n5, int n6, int n7) {
        this.gbc.fill = n2;
        this.gbc.anchor = n3;
        this.gbc.weightx = d10;
        this.gbc.weighty = d11;
        this.gbc.gridx = n4;
        this.gbc.gridy = n5;
        this.gbc.gridwidth = n6;
        this.gbc.gridheight = n7;
        return this.gbc;
    }

    protected JLabel getICNLabel() {
        JLabel jLabel;
        String string = "   " + this.certInfo.getIssuerCN();
        if (string == null || string.trim().equals("null")) {
            jLabel = new JLabel("");
        } else {
            jLabel = new JLabel(string);
            ++this.colx2;
        }
        jLabel.setFont(new Font("Dialog", 0, 10));
        return jLabel;
    }

    protected JLabel getICountryLabel() {
        JLabel jLabel;
        String string = "   " + this.certInfo.getIssuerCountry();
        if (string == null || string.trim().equals("null")) {
            jLabel = new JLabel("");
        } else {
            jLabel = new JLabel(string);
            ++this.colx2;
        }
        jLabel.setFont(new Font("Dialog", 0, 10));
        return jLabel;
    }

    protected JLabel getIOULabel() {
        JLabel jLabel;
        String string = "   " + this.certInfo.getIssuerOU();
        if (string == null || string.trim().equals("null")) {
            jLabel = new JLabel("");
        } else {
            jLabel = new JLabel(string);
            ++this.colx2;
        }
        jLabel.setFont(new Font("Dialog", 0, 10));
        return jLabel;
    }

    protected JLabel getIOrgLabel() {
        JLabel jLabel;
        String string = "   " + this.certInfo.getIssuerOrg();
        if (string == null || string.trim().equals("null")) {
            jLabel = new JLabel("");
        } else {
            jLabel = new JLabel(string);
            ++this.colx2;
        }
        jLabel.setFont(new Font("Dialog", 0, 10));
        return jLabel;
    }

    protected JLabel getOULabel() {
        JLabel jLabel;
        String string = "       " + this.certInfo.getOU();
        if (string == null || string.trim().equals("null")) {
            jLabel = new JLabel("");
        } else {
            jLabel = new JLabel(string);
            ++this.colx1;
        }
        jLabel.setFont(new Font("Dialog", 0, 10));
        return jLabel;
    }

    protected JLabel getOrgLabel() {
        JLabel jLabel;
        String string = "       " + this.certInfo.getOrg();
        if (string == null || string.trim().equals("null")) {
            jLabel = new JLabel("");
        } else {
            jLabel = new JLabel(string);
            ++this.colx1;
        }
        jLabel.setFont(new Font("Dialog", 0, 10));
        return jLabel;
    }

    protected JLabel getSerialNumberLabel() {
        String string = this.certInfo.getSerialNumber();
        String string2 = "    Serial Number: " + string;
        JLabel jLabel = string.trim().equals("null") ? new JLabel(new LString("unknown.msg", "unknown").getString()) : new JLabel(string2);
        jLabel.setFont(new Font("Dialog", 0, 10));
        return jLabel;
    }
}

