/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.Constants;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.ErrorDialog;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.Keymap;

public class ProxyDialog
extends JDialog
implements Constants {
    private SecureFtpApplet parent;
    private GridBagConstraints gbc = new GridBagConstraints();
    JPanel mainPanel = new JPanel();
    private JTextField httpProxyHost;
    private JTextField httpProxyPort;
    private JTextField socksProxyHost;
    private JTextField socksProxyPort;
    private JPanel buttonPanel = new JPanel();
    private JButton okButton = new JButton(new LString("ok_button.label", "OK").getString());
    private JButton cancelButton = new JButton(new LString("cancel_button.label", "Cancel").getString());

    public ProxyDialog(SecureFtpApplet secureFtpApplet) {
        super(secureFtpApplet.getBaseFrame(), new LString("proxy_info.title", "Proxy information").getString(), true);
        this.parent = secureFtpApplet;
        this.getContentPane().setLayout(new BorderLayout());
        this.getMainPanel();
        if (!System.getProperty("java.version").startsWith("1.2")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProxyDialog.this.socksProxyHost.requestFocus();
                    ProxyDialog.this.setResizable(false);
                }
            });
        }
        this.buttonPanel.setLayout(new FlowLayout());
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.addButtonListeners();
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
        this.setLocationRelativeTo(this.parent.getContentPane());
        ((Component)this).setVisible(true);
    }

    private void addButtonListeners() {
        SwingUtilities.getRootPane(this).setDefaultButton(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ProxyDialog.this.socksProxyHost.getText().trim().equals("")) {
                    ProxyDialog.this.parent.getServerUtil().setSocksProxyHost(null);
                } else {
                    ProxyDialog.this.parent.getServerUtil().setSocksProxyHost(ProxyDialog.this.socksProxyHost.getText().trim());
                }
                if (ProxyDialog.this.socksProxyPort.getText().trim().equals("")) {
                    ProxyDialog.this.parent.getServerUtil().setSocksProxyPort(null);
                } else {
                    ProxyDialog.this.parent.getServerUtil().setSocksProxyPort(ProxyDialog.this.socksProxyPort.getText().trim());
                }
                ProxyDialog.this.writeProxyPrefs(ProxyDialog.this.socksProxyHost.getText().trim(), ProxyDialog.this.socksProxyPort.getText().trim());
                ProxyDialog.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                debug.println("cancelling connection", 3);
                ProxyDialog.this.dispose();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    ProxyDialog.this.dispose();
                }
            }
        });
    }

    private GridBagConstraints getGBC(int n2, int n3, double d10, double d11, int n4, int n5, int n6, int n7) {
        this.gbc.fill = n2;
        this.gbc.anchor = n3;
        this.gbc.weightx = d10;
        this.gbc.weighty = d11;
        this.gbc.gridx = n4;
        this.gbc.gridy = n5;
        this.gbc.gridwidth = n6;
        this.gbc.gridheight = n7;
        return this.gbc;
    }

    private void getMainPanel() {
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setPreferredSize(new Dimension(320, 100));
        this.mainPanel.add((Component)new JLabel(new LString("connection_info.hostname.label", "Hostname").getString()), this.getGBC(0, 17, 0.5, 1.0, 1, 0, 1, 1));
        this.mainPanel.add((Component)new JLabel(new LString("connection_info.port.label", "Port").getString()), this.getGBC(0, 17, 0.5, 1.0, 2, 0, 1, 1));
        this.mainPanel.add((Component)new JLabel("  Socks v4:"), this.getGBC(0, 18, 0.2, 1.0, 0, 1, 1, 1));
        this.socksProxyHost = new JTextField(10);
        this.mainPanel.add((Component)this.socksProxyHost, this.getGBC(0, 18, 0.4, 1.0, 1, 1, 4, 1));
        this.socksProxyPort = new JTextField(5);
        this.mainPanel.add((Component)this.socksProxyPort, this.getGBC(0, 18, 0.4, 1.0, 2, 1, 5, 1));
        this.socksProxyPort.setText("1080");
        this.unSetEnterEvent(this.socksProxyHost);
        this.unSetEnterEvent(this.socksProxyPort);
        if (this.parent.getServerUtil().getSocksProxyHost() != null) {
            this.socksProxyHost.setText(this.parent.getServerUtil().getSocksProxyHost());
        }
        if (this.parent.getServerUtil().getSocksProxyPort() != null) {
            this.socksProxyPort.setText(this.parent.getServerUtil().getSocksProxyPort());
        }
    }

    private void unSetEnterEvent(JTextField jTextField) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        Keymap keymap = jTextField.getKeymap();
        keymap.removeKeyStrokeBinding(keyStroke);
    }

    private void writeProxyPrefs(String string, String string2) {
        this.parent.getPrefs().setSocksProxyHost(string);
        this.parent.getPrefs().setSocksProxyPort(string2);
        try {
            this.parent.getPrefs().writePreferences();
        }
        catch (Exception exception) {
            new ErrorDialog(exception.getMessage(), new LString("failed_to_write_prefs.msg", "Failed to write preferences.").getString());
        }
    }
}

