/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.Keymap;

public class PasswordDialog
extends JDialog {
    private SecureFtpApplet parent;
    JPanel mainPanel = new JPanel();
    private String passMessage;
    private static JPasswordField passwordField;
    private transient boolean status;
    private JPanel buttonPanel = new JPanel();
    private JButton okButton = new JButton(new LString("ok_button.label", "OK").getString());
    private JButton cancelButton = new JButton(new LString("cancel_button.label", "Cancel").getString());
    private GridBagConstraints gbc = new GridBagConstraints();

    public PasswordDialog(SecureFtpApplet secureFtpApplet, String string, String string2) {
        super(secureFtpApplet.getBaseFrame(), string, true);
        this.parent = secureFtpApplet;
        this.getContentPane().setLayout(new BorderLayout());
        if (!System.getProperty("java.version").startsWith("1.2")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PasswordDialog.this.setResizable(false);
                }
            });
        }
        this.passMessage = string2;
        this.getMainPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.addButtonListeners();
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
        this.setLocationRelativeTo(this.parent.getContentPane());
        ((Component)this).setVisible(true);
    }

    static /* synthetic */ boolean access$0(PasswordDialog passwordDialog) {
        return passwordDialog.status;
    }

    private void addButtonListeners() {
        SwingUtilities.getRootPane(this).setDefaultButton(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PasswordDialog.this.status = true;
                PasswordDialog.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                debug.println("cancelling passwd request", 2);
                PasswordDialog.this.parent.getServerUtil().closeConnection();
                PasswordDialog.this.status = false;
                PasswordDialog.this.dispose();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    PasswordDialog.this.parent.getServerUtil().closeConnection();
                    PasswordDialog.this.status = false;
                    PasswordDialog.this.dispose();
                }
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        passwordField.requestFocus();
    }

    private GridBagConstraints getGBC(int n2, int n3, double d10, double d11, int n4, int n5, int n6, int n7) {
        this.gbc.fill = n2;
        this.gbc.anchor = n3;
        this.gbc.weightx = d10;
        this.gbc.weighty = d11;
        this.gbc.gridx = n4;
        this.gbc.gridy = n5;
        this.gbc.gridwidth = n6;
        this.gbc.gridheight = n7;
        return this.gbc;
    }

    private void getMainPanel() {
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setPreferredSize(new Dimension(350, 70));
        this.mainPanel.add((Component)new JLabel("  " + this.passMessage), this.getGBC(0, 17, 1.0, 1.0, 0, 0, 1, 2));
        passwordField = new JPasswordField(15);
        this.mainPanel.add((Component)passwordField, this.getGBC(0, 10, 1.0, 1.0, 0, 2, 4, 1));
        this.unSetEnterEvent(passwordField);
    }

    public static char[] getPassword(SecureFtpApplet secureFtpApplet) {
        return PasswordDialog.getPassword(secureFtpApplet, new LString("password_required.title", "Password required").getString(), String.valueOf(new LString("enter_your_password.msg", "Enter your password").getString()) + ":");
    }

    public static char[] getPassword(SecureFtpApplet secureFtpApplet, String string) {
        LString lString = new LString("password_required_for_host.title", "Password required for \"[^0]\"");
        lString.replace(0, string);
        return PasswordDialog.getPassword(secureFtpApplet, lString.getString(), String.valueOf(new LString("enter_your_password.msg", "Enter your password").getString()) + ":");
    }

    public static char[] getPassword(SecureFtpApplet secureFtpApplet, String string, String string2) {
        PasswordDialog passwordDialog = new PasswordDialog(secureFtpApplet, string, string2);
        boolean bl2 = passwordDialog.getStatus();
        if (bl2) {
            return passwordField.getPassword();
        }
        return null;
    }

    protected boolean getStatus() {
        return this.status;
    }

    private void unSetEnterEvent(JTextField jTextField) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        Keymap keymap = jTextField.getKeymap();
        keymap.removeKeyStrokeBinding(keyStroke);
    }
}

