/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.data.Bookmark;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.MakingConnectionDialog;
import edu.sdsc.secureftp.gui.OpenConnection;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import edu.sdsc.secureftp.network.BasicFtp;

public class OpenBookmarkConnection {
    private SecureFtpApplet parent;
    private Bookmark book;
    private MakingConnectionDialog cancelDialog;
    private OpenConnection connectionThread;

    public OpenBookmarkConnection(SecureFtpApplet secureFtpApplet, Bookmark bookmark) {
        this.parent = secureFtpApplet;
        this.book = bookmark;
        this.makeConnection();
    }

    protected String getHostName() {
        return this.book.getHostname();
    }

    private void makeConnection() {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (this.book.getAnon()) {
            string2 = "secureftp@";
        }
        string = this.book.getUsername() != null && !this.book.getUsername().equals("") ? this.book.getUsername() : new String("");
        if (this.book.getPassword() != null && !this.book.getPassword().equals("")) {
            string2 = this.book.getPassword();
        } else if (!this.book.getAnon()) {
            string2 = new String("");
        }
        string3 = ((BasicFtp)this.parent.securityVector.elementAt(this.book.getSecurity())).getSecurityType();
        this.cancelDialog = new MakingConnectionDialog(this.parent, this);
        this.connectionThread = new OpenConnection(this.parent, this.cancelDialog, this.book.getHostname(), this.book.getPort(), string, string2, this.book.getSecurity(), string3, this.book.getPasv(), this.book.getAnon(), this.book.getProxy(), this.book.getSSLData(), this.book.getLocalDir(), this.book.getRemoteDir());
        this.connectionThread.start();
    }

    protected void stopConnection() {
        debug.println("killing connection thread", 2);
        this.cancelDialog.getProgressBar().setValue(this.cancelDialog.getProgressBar().getMaximum());
        if (this.parent.getFtpNet() != null && this.parent.getFtpNet().isConnected()) {
            this.parent.getFtpNet().disconnect();
        }
        this.parent.getServerUtil().enableOpenConnectionItems();
        this.connectionThread.stop();
    }
}

