/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.OpenBookmarkConnection;
import edu.sdsc.secureftp.gui.OpenConnectionDialog;
import edu.sdsc.secureftp.gui.ProgressThread;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class MakingConnectionDialog
extends JDialog {
    private JButton cancelButton = new JButton(new LString("cancel_button.label", "Cancel").getString());
    private JPanel infoPanel = new JPanel();
    private JPanel textPanel = new JPanel();
    private JPanel progPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JProgressBar progressBar = new JProgressBar(0, 100);
    private SecureFtpApplet parent = null;
    private OpenBookmarkConnection ob = null;
    private OpenConnectionDialog oc = null;
    protected GridBagConstraints gbc = new GridBagConstraints();

    public MakingConnectionDialog(SecureFtpApplet secureFtpApplet, OpenBookmarkConnection openBookmarkConnection) {
        super(secureFtpApplet.getBaseFrame(), new LString("making_connection.title", "Making Connection ...").getString(), false);
        this.parent = secureFtpApplet;
        this.ob = openBookmarkConnection;
        this.setupDialog();
    }

    public MakingConnectionDialog(SecureFtpApplet secureFtpApplet, OpenConnectionDialog openConnectionDialog) {
        super(secureFtpApplet.getBaseFrame(), "Making Connection ...", false);
        this.parent = secureFtpApplet;
        this.oc = openConnectionDialog;
        this.setupDialog();
    }

    protected GridBagConstraints getGBC(int n2, int n3, double d10, double d11, int n4, int n5, int n6, int n7) {
        this.gbc.fill = n2;
        this.gbc.anchor = n3;
        this.gbc.weightx = d10;
        this.gbc.weighty = d11;
        this.gbc.gridx = n4;
        this.gbc.gridy = n5;
        this.gbc.gridwidth = n6;
        this.gbc.gridheight = n7;
        return this.gbc;
    }

    protected JProgressBar getProgressBar() {
        return this.progressBar;
    }

    private void setupDialog() {
        this.parent.getServerUtil().disableAllConnectionItems();
        if (!System.getProperty("java.version").startsWith("1.2")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MakingConnectionDialog.this.setResizable(false);
                }
            });
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.infoPanel.setLayout(new BorderLayout());
        this.infoPanel.setPreferredSize(new Dimension(300, 75));
        this.getContentPane().add((Component)this.infoPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.infoPanel.add((Component)this.textPanel, "North");
        this.infoPanel.add((Component)this.progPanel, "Center");
        this.progPanel.add(this.progressBar);
        this.textPanel.setLayout(new GridBagLayout());
        this.textPanel.add(Box.createVerticalStrut(5), this.getGBC(0, 18, 0.1, 1.0, 0, 0, 1, 1));
        this.textPanel.add(Box.createVerticalStrut(5), this.getGBC(0, 18, 0.9, 1.0, 2, 0, 1, 1));
        this.textPanel.add(Box.createHorizontalStrut(5), this.getGBC(0, 17, 0.1, 1.0, 0, 1, 1, 1));
        this.textPanel.add((Component)new JLabel(String.valueOf(new LString("connecting_to.msg", "Connecting to").getString()) + ": "), this.getGBC(0, 17, 0.9, 1.0, 1, 1, 1, 1));
        JLabel jLabel = this.oc != null ? new JLabel(this.oc.getHostNameTextField().getText()) : (this.ob != null ? new JLabel(this.ob.getHostName()) : new JLabel(new LString("unknown.msg", "unknown").getString()));
        jLabel.setFont(new Font("Dialog", 0, 12));
        this.textPanel.add(Box.createHorizontalStrut(5), this.getGBC(0, 17, 0.1, 1.0, 0, 2, 1, 1));
        this.textPanel.add((Component)jLabel, this.getGBC(0, 17, 0.9, 1.0, 1, 2, 1, 1));
        this.textPanel.add(Box.createVerticalStrut(5), this.getGBC(0, 18, 0.1, 1.0, 0, 3, 1, 1));
        this.textPanel.add(Box.createVerticalStrut(5), this.getGBC(0, 18, 0.9, 1.0, 2, 3, 1, 1));
        this.buttonPanel.add(this.cancelButton);
        SwingUtilities.getRootPane(this).setDefaultButton(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MakingConnectionDialog.this.stopConnection();
                MakingConnectionDialog.this.parent.getServerUtil().enableOpenConnectionItems();
            }
        });
        this.pack();
        this.setLocationRelativeTo(this.parent.getContentPane());
        ((Component)this).setVisible(true);
        new ProgressThread(this.progressBar).start();
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 27) {
                    MakingConnectionDialog.this.stopConnection();
                    MakingConnectionDialog.this.parent.getServerUtil().enableOpenConnectionItems();
                }
            }
        });
    }

    private void stopConnection() {
        if (this.oc != null) {
            this.oc.stopConnection();
        } else if (this.ob != null) {
            this.ob.stopConnection();
        }
        this.dispose();
    }
}

