/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.Constants;
import edu.sdsc.secureftp.data.FileEntry;
import edu.sdsc.secureftp.data.FtpPut;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.ListPanel;
import edu.sdsc.secureftp.gui.LocalUtil;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import edu.sdsc.secureftp.gui.SortDecorator;
import edu.sdsc.secureftp.gui.TransferStatusDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class LocalListPanel
extends ListPanel
implements Constants {
    private LocalUtil loc;

    public LocalListPanel(LocalUtil localUtil, SecureFtpApplet secureFtpApplet) {
        super(secureFtpApplet);
        this.setName("local");
        this.setLayout(new BorderLayout());
        this.scrollPane = this.createTable();
        this.scrollPane.setBackground(Color.white);
        this.add((Component)this.scrollPane, "Center");
        this.loc = localUtil;
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 0) {
                    LocalListPanel.this.loc.enableButtonBar();
                }
                if (mouseEvent.getClickCount() == 2) {
                    String string = (String)LocalListPanel.this.tableView.getValueAt(LocalListPanel.this.tableView.getSelectedRow(), 1);
                    if (LocalListPanel.this.dirStruct.get(string).equals("%")) {
                        LocalListPanel.this.parent.getLocalUtil().cdup();
                    } else if (LocalListPanel.this.dirStruct.get(string).equals("d")) {
                        LocalListPanel.this.changeDir(string);
                    } else {
                        LocalListPanel.this.upload(string);
                    }
                }
            }
        };
        this.tableView.addMouseListener(mouseAdapter);
        final SortDecorator sortDecorator = new SortDecorator(this.tableView.getModel());
        this.tableView.setModel(sortDecorator);
        JTableHeader jTableHeader = this.tableView.getTableHeader();
        jTableHeader.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = tableView.getColumnModel();
                int n2 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n3 = tableView.convertColumnIndexToModel(n2);
                sortDecorator.sort(n3);
                parent.getLocalPanel().repaint();
            }
        });
    }

    private void changeDir(String string) {
        if (this.dirStruct.get(string).equals("d")) {
            this.loc.chdir(string);
            this.loc.list();
            this.parent.getLocalFrame().getDirTextField().setText(this.loc.getDirName());
        } else {
            debug.println("LocalListPanel: change dir: call upload()", 2);
            this.upload(string);
        }
        debug.println("LocalListPanel: local change dir to: " + string, 5);
        debug.println("LocalListPanel: current local dir: " + this.loc.getDirName(), 4);
    }

    public void clearSelections() {
        this.tableView.removeRowSelectionInterval(0, this.tableView.getRowCount() - 1);
        this.parent.getLocalUtil().disableButtonBar();
    }

    protected void handleDrop(FileEntry[] fileEntryArray, Point point) {
        try {
            if (this.tableView.rowAtPoint(point) > 0) {
                if (this.isDir((String)this.tableView.getValueAt(this.tableView.rowAtPoint(point), 1))) {
                    this.changeDir((String)this.tableView.getValueAt(this.tableView.rowAtPoint(point), 1));
                }
                this.parent.getServerPanel().download(fileEntryArray);
            } else {
                this.parent.getServerPanel().download(fileEntryArray);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.parent.getServerPanel().download(fileEntryArray);
        }
    }

    public boolean isDir(String string) {
        return this.dirStruct.get(string).equals("d");
    }

    protected void upload(String string) {
        File file = new File(string).getAbsoluteFile();
        FileEntry[] fileEntryArray = new FileEntry[]{new FileEntry(file.isDirectory() ? (char)'d' : 'f', file.length(), file.getAbsolutePath())};
        this.upload(fileEntryArray);
    }

    protected void upload(FileEntry[] fileEntryArray) {
        if (this.parent.getFtpNet() == null || !this.parent.getFtpNet().isConnected()) {
            this.getToolkit().beep();
            this.parent.getLocalFrame().setStatus(new LString("not_connected_upload.msg", "You must be connected to upload").getString());
            return;
        }
        if (this.parent.getNetworkStatus() != 0) {
            debug.println("network status = " + this.parent.getNetworkStatus());
            this.getToolkit().beep();
            this.parent.getLocalFrame().setStatus(new LString("upload_not_avail.msg", "You cannot upload at this time.").getString());
            return;
        }
        this.parent.setTransferStatusDialog(new TransferStatusDialog(this.parent, new FtpPut(this.parent, fileEntryArray, this.parent.getServerUtil().getMode())));
    }
}

