/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.data.FileEntry;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.ErrorDialog;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.LocalListPanel;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import edu.sdsc.secureftp.gui.StatusPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class LocalFrame
extends JInternalFrame {
    private LocalListPanel localPanel = null;
    private StatusPanel statusPanel;
    private JPanel navPanel;
    private JToolBar buttonBar;
    private JTextField dirTextField;
    private SecureFtpApplet parent;
    private JButton deleteButton;
    private JButton renameButton;
    private JButton stopButton;
    private JButton uploadButton;

    public LocalFrame(SecureFtpApplet secureFtpApplet) {
        super(new LString("local_frame.title", "Local Machine").getString(), true, false, true, true);
        this.parent = secureFtpApplet;
        int n2 = this.parent.getWidth() / 2 - 10;
        int n3 = this.parent.getHeight() - 75;
        if (this.parent.isApplication()) {
            n2 = this.parent.getPrefs().getInternalWidth();
            n3 = this.parent.getPrefs().getInternalHeight();
        }
        this.setBounds(5, 5, n2, n3);
        this.setVisible(true);
        this.localPanel = new LocalListPanel(this.parent.getLocalUtil(), this.parent);
        this.localPanel.setBackground(Color.white);
        this.statusPanel = new StatusPanel(this.parent);
        this.navPanel = new JPanel();
        this.navPanel.setLayout(new BorderLayout());
        this.dirTextField = new JTextField(20);
        this.dirTextField.setBorder(BorderFactory.createEtchedBorder());
        this.navPanel.add((Component)this.getButtonBar(), "North");
        this.navPanel.add(Box.createHorizontalStrut(12), "West");
        this.navPanel.add((Component)this.dirTextField, "Center");
        this.navPanel.add(Box.createHorizontalStrut(12), "East");
        this.navPanel.add(Box.createVerticalStrut(5), "South");
        this.getContentPane().add((Component)this.navPanel, "North");
        this.getContentPane().add((Component)this.localPanel, "Center");
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.addListeners();
    }

    private void addListeners() {
        this.dirTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                block2: {
                    if (keyEvent.getKeyCode() != 10) break block2;
                    try {
                        LocalFrame.this.parent.getLocalUtil().changeDir(LocalFrame.this.dirTextField.getText());
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    protected void delayedStatusReset(int n2) {
        this.statusPanel.delayedStatusReset(n2);
    }

    private JToolBar getButtonBar() {
        if (this.buttonBar == null) {
            this.buttonBar = new JToolBar();
            this.buttonBar.setOrientation(0);
            this.buttonBar.setFloatable(false);
            JButton jButton = new JButton(new ImageIcon(this.getClass().getResource("images/back.gif")));
            jButton.setToolTipText(new LString("internal_frame.cdup.tooltip", "Up one directory").getString());
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    debug.println("back button clicked", 3);
                    LocalFrame.this.parent.getLocalUtil().cdup();
                    LocalFrame.this.parent.getLocalPanel().requestFocus();
                }
            });
            this.deleteButton = new JButton(new ImageIcon(this.getClass().getResource("images/delete.gif")));
            this.deleteButton.setToolTipText(new LString("internal_frame.delete.tooltip", "Delete").getString());
            this.deleteButton.setEnabled(true);
            this.deleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LString lString;
                    LString lString2;
                    debug.println("delete button clicked", 3);
                    FileEntry[] fileEntryArray = LocalFrame.this.localPanel.getSelectedEntries();
                    LocalFrame.this.parent.getLocalPanel().requestFocus();
                    if (fileEntryArray == null) {
                        LocalFrame.this.getToolkit().beep();
                        LocalFrame.this.setStatus(new LString("select_an_item.msg", "You must select an item.").getString());
                        return;
                    }
                    if (fileEntryArray.length > 1) {
                        lString2 = new LString("delete_all_selected_items.msg", "Delete ALL selected items?");
                        lString = new LString("delete_selected_items.title", "Delete selected items");
                    } else if (LocalFrame.this.localPanel.isDir(fileEntryArray[0].getName())) {
                        if (fileEntryArray[0].getName().equals("..")) {
                            LocalFrame.this.getToolkit().beep();
                            LocalFrame.this.setStatus(new LString("cannot_delete_item.msg", "You cannot delete this item.").getString());
                            return;
                        }
                        lString2 = new LString("delete_all_contents.msg", "Delete \"[^0]\" and all of its contents?");
                        lString2.replace(0, fileEntryArray[0].getName());
                        lString = new LString("delete_directory.title", "Delete directory");
                    } else {
                        if (fileEntryArray[0].getName().equals("..")) {
                            LocalFrame.this.getToolkit().beep();
                            LocalFrame.this.setStatus(new LString("cannot_delete_item.msg", "You cannot delete this item.").getString());
                            return;
                        }
                        lString2 = new LString("delete_file.msg", "Delete \"[^0]\"?");
                        lString2.replace(0, fileEntryArray[0].getName());
                        lString = new LString("delete_file.title", "Delete file");
                    }
                    int n2 = JOptionPane.showConfirmDialog(LocalFrame.this.parent.getContentPane(), String.valueOf(lString2.getString()) + "\n", lString.getString(), 1);
                    switch (n2) {
                        case 0: {
                            if (LocalFrame.this.parent.getLocalUtil().delete(fileEntryArray)) {
                                LocalFrame.this.parent.getLocalUtil().list();
                                break;
                            }
                            new ErrorDialog(new LString("unable_delete_item.msg", "Unable to delete file(s)").getString(), new LString("delete_failed.title", "Delete failed").getString());
                            break;
                        }
                        case 1: 
                        case 2: {
                            LocalFrame.this.setStatus(new LString("delete_cancelled.msg", "Deletion cancelled.").getString());
                            break;
                        }
                    }
                }
            });
            JButton jButton2 = new JButton(new ImageIcon(this.getClass().getResource("images/mkdir.gif")));
            jButton2.setToolTipText(new LString("internal_frame.mkdir.tooltip", "Create new directory").getString());
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    debug.println("mkdir button clicked", 3);
                    LocalFrame.this.parent.getLocalPanel().requestFocus();
                    try {
                        String string = String.valueOf(new LString("create_new_dir.msg", "Create new directory").getString()) + ":";
                        String string2 = new LString("create_new_dir.title", "Create new directory").getString();
                        String string3 = JOptionPane.showInputDialog(LocalFrame.this.parent.getContentPane(), string, string2, 3);
                        if (string3 != null) {
                            if (LocalFrame.this.parent.getLocalUtil().mkdir(string3)) {
                                LocalFrame.this.parent.getLocalUtil().list();
                            } else {
                                new ErrorDialog(String.valueOf(new LString("unable_create_dir.msg", "Unable to create directory").getString()) + ": " + string3, new LString("create_dir_failed.title", "Create directory failed").getString());
                            }
                        } else {
                            LocalFrame.this.setStatus(new LString("create_dir_cancelled.msg", "Create new directory cancelled").getString());
                        }
                    }
                    catch (Exception exception) {}
                }
            });
            JButton jButton3 = new JButton(new ImageIcon(this.getClass().getResource("images/refresh.gif")));
            jButton3.setToolTipText(new LString("internal_frame.refresh.tooltip", "Refresh").getString());
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    debug.println("refresh button clicked", 3);
                    LocalFrame.this.parent.getLocalUtil().list();
                    LocalFrame.this.parent.getLocalPanel().requestFocus();
                }
            });
            this.renameButton = new JButton(new ImageIcon(this.getClass().getResource("images/rename.gif")));
            this.renameButton.setToolTipText(new LString("internal_frame.rename.tooltip", "Rename").getString());
            this.renameButton.setEnabled(true);
            this.renameButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    debug.println("rename button clicked", 3);
                    FileEntry[] fileEntryArray = LocalFrame.this.localPanel.getSelectedEntries();
                    LocalFrame.this.parent.getLocalPanel().requestFocus();
                    if (fileEntryArray == null) {
                        LocalFrame.this.getToolkit().beep();
                        LocalFrame.this.setStatus(new LString("select_an_item.msg", "You must select an item.").getString());
                        return;
                    }
                    if (fileEntryArray.length > 1) {
                        LocalFrame.this.getToolkit().beep();
                        LocalFrame.this.setStatus(new LString("rename_select_max_one.msg", "Select only one file to rename").getString());
                        return;
                    }
                    if (fileEntryArray[0].getName().equals("..")) {
                        LocalFrame.this.getToolkit().beep();
                        LocalFrame.this.setStatus(new LString("cannot_rename_item.msg", "You cannot rename this item.").getString());
                        return;
                    }
                    try {
                        LString lString = new LString("rename_file.msg", "New name for \"[^0]\"");
                        lString.replace(0, fileEntryArray[0].getName());
                        LString lString2 = new LString("rename.title", "Rename");
                        String string = JOptionPane.showInputDialog(LocalFrame.this.parent.getContentPane(), String.valueOf(lString.getString()) + ":", lString2.getString(), 3);
                        if (string != null) {
                            if (LocalFrame.this.parent.getLocalUtil().rename(fileEntryArray[0].getName(), string)) {
                                LocalFrame.this.parent.getLocalUtil().list();
                            } else {
                                LString lString3 = new LString("unable_rename_item.msg", "Unable to rename \"[^0]\" to \"[^1]\".");
                                lString3.replace(0, fileEntryArray[0].getName());
                                lString3.replace(1, string);
                                LString lString4 = new LString("rename_failed.title", "Rename failed");
                                new ErrorDialog(lString3.getString(), new LString("rename_failed.title", "Rename failed").getString());
                            }
                        } else {
                            LocalFrame.this.setStatus(new LString("rename_cancelled.msg", "Rename cancelled.").getString());
                        }
                    }
                    catch (Exception exception) {}
                }
            });
            this.stopButton = new JButton(new ImageIcon(this.getClass().getResource("images/stop.gif")));
            this.stopButton.setToolTipText(new LString("internal_frame.stop.tooltip", "Stop").getString());
            this.stopButton.setEnabled(false);
            this.stopButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    debug.println("stop button clicked", 3);
                    LocalFrame.this.parent.getLocalPanel().requestFocus();
                    try {
                        LocalFrame.this.parent.getLocalUtil().stopList();
                        LocalFrame.this.stopButton.setEnabled(false);
                    }
                    catch (Exception exception) {}
                }
            });
            this.uploadButton = new JButton(new ImageIcon(this.getClass().getResource("images/upload.gif")));
            this.uploadButton.setToolTipText(new LString("internal_frame.upload.tooltip", "Upload").getString());
            this.uploadButton.setEnabled(true);
            this.uploadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    debug.println("upload button clicked", 3);
                    LocalFrame.this.parent.getLocalPanel().requestFocus();
                    if (LocalFrame.this.parent.getFtpNet() == null || !LocalFrame.this.parent.getFtpNet().isConnected()) {
                        LocalFrame.this.getToolkit().beep();
                        LocalFrame.this.setStatus(new LString("not_connected_upload.msg", "You must be connected to upload.").getString());
                        return;
                    }
                    FileEntry[] fileEntryArray = LocalFrame.this.localPanel.getSelectedEntries();
                    if (fileEntryArray == null) {
                        String string = JOptionPane.showInputDialog(LocalFrame.this.parent.getContentPane(), String.valueOf(new LString("upload_file.msg", "Upload file or directory").getString()) + ":", new LString("upload_file.title", "Upload file/directory").getString(), 3);
                        if (string != null && !string.trim().equals("")) {
                            LocalFrame.this.localPanel.upload(string);
                        }
                    } else {
                        LocalFrame.this.localPanel.upload(fileEntryArray);
                    }
                }
            });
            this.buttonBar.addSeparator();
            this.buttonBar.add(this.uploadButton);
            this.buttonBar.addSeparator();
            this.buttonBar.add(jButton);
            this.buttonBar.add(jButton3);
            this.buttonBar.add(this.stopButton);
            this.buttonBar.addSeparator();
            this.buttonBar.add(jButton2);
            this.buttonBar.add(this.renameButton);
            this.buttonBar.add(this.deleteButton);
        }
        return this.buttonBar;
    }

    protected JButton getDeleteButton() {
        return this.deleteButton;
    }

    public JTextField getDirTextField() {
        return this.dirTextField;
    }

    protected void getListing() {
        this.parent.getLocalUtil().list();
        this.dirTextField.setText(this.parent.getLocalUtil().getDirName());
    }

    protected LocalListPanel getLocalPanel() {
        return this.localPanel;
    }

    protected JProgressBar getProgressBar() {
        return this.statusPanel.getProgressBar();
    }

    protected JButton getRenameButton() {
        return this.renameButton;
    }

    protected StatusPanel getStatusPanel() {
        return this.statusPanel;
    }

    protected JButton getStopButton() {
        return this.stopButton;
    }

    protected JButton getUploadButton() {
        return this.uploadButton;
    }

    protected void setStatus(String string) {
        this.setStatus(string, 2);
    }

    protected void setStatus(String string, int n2) {
        this.statusPanel.setStatus(string);
        if (n2 > 0) {
            this.delayedStatusReset(n2);
        }
    }
}

