/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.Constants;
import edu.sdsc.secureftp.data.DirStruct;
import edu.sdsc.secureftp.data.FileEntry;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.CustomTableModel;
import edu.sdsc.secureftp.gui.DropListViewport;
import edu.sdsc.secureftp.gui.DropTable;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;

public class ListPanel
extends JPanel
implements Constants {
    protected DropTable tableView;
    protected JScrollPane scrollPane;
    protected SecureFtpApplet parent;
    protected DirStruct dirStruct = new DirStruct();
    protected ImageIcon dirImage;
    protected ImageIcon prevDirImage;
    protected ImageIcon fileImage;
    protected ImageIcon linkImage;
    String name;
    String size;
    String modified;
    private CustomTableModel model;

    public ListPanel(SecureFtpApplet secureFtpApplet) {
        this.parent = secureFtpApplet;
        this.name = new LString("list_panel.name.column", "Name").getString();
        this.size = new LString("list_panel.size.column", "Size").getString();
        this.modified = new LString("list_panel.modified.column", "Last Modified").getString();
    }

    public void buildPreviousDirectoryRow() {
        this.dirStruct.put("..", "%");
        this.buildRow(this.prevDirImage, "..", "", "");
    }

    public void buildRow(String string, String string2, String string3, String string4) {
        debug.println(String.valueOf(string2) + " is of type " + string, 3);
        if (string2.equals(".") || string2.equals("..")) {
            return;
        }
        this.dirStruct.put(string2, string);
        ImageIcon imageIcon = string.equals("d") ? this.dirImage : (string.equals("l") ? this.linkImage : this.fileImage);
        this.buildRow(imageIcon, string2, string3, string4);
    }

    public void buildRow(ImageIcon imageIcon, String string, String string2, String string3) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(imageIcon);
        vector.addElement(string);
        vector.addElement(string2);
        vector.addElement(string3);
        this.model.addRow(vector);
        this.setColumnWidths();
        this.requestFocus();
        if (this.scrollPane != null) {
            this.scrollPane.getVerticalScrollBar().setValue(0);
        }
    }

    public JScrollPane createTable() {
        this.model = new CustomTableModel();
        this.tableView = new DropTable(this, this.model);
        this.tableView.setRowHeight(20);
        this.tableView.setRowSelectionAllowed(true);
        this.tableView.setColumnSelectionAllowed(false);
        this.tableView.setIntercellSpacing(new Dimension(0, 0));
        this.tableView.setShowHorizontalLines(false);
        this.tableView.setShowVerticalLines(false);
        this.tableView.setSelectionMode(2);
        this.model.addColumn(" ");
        this.model.addColumn(this.name);
        this.model.addColumn(this.size);
        this.model.addColumn(this.modified);
        this.dirImage = new ImageIcon(this.getClass().getResource("images/folder.gif"));
        this.prevDirImage = new ImageIcon(this.getClass().getResource("images/prevdir.gif"));
        this.linkImage = new ImageIcon(this.getClass().getResource("images/unknown.gif"));
        this.fileImage = new ImageIcon(this.getClass().getResource("images/file.gif"));
        this.buildPreviousDirectoryRow();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewport(new DropListViewport(jScrollPane, this));
        jScrollPane.getViewport().setBackground(Color.white);
        jScrollPane.getViewport().add(this.tableView);
        jScrollPane.setViewportBorder(BorderFactory.createLineBorder(Color.white));
        return jScrollPane;
    }

    protected int getRowCount() {
        return this.tableView.getRowCount();
    }

    public FileEntry[] getSelectedEntries() {
        FileEntry[] fileEntryArray = null;
        int[] nArray = this.tableView.getSelectedRows();
        if (nArray.length > 0) {
            fileEntryArray = new FileEntry[nArray.length];
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            String string = (String)this.tableView.getValueAt(nArray[n2], 1);
            long l2 = 0L;
            try {
                l2 = Long.parseLong((String)this.tableView.getValueAt(nArray[n2], 2));
            }
            catch (Exception exception) {}
            char c10 = '?';
            if (string != null) {
                c10 = ((String)this.dirStruct.get(string)).charAt(0);
            }
            fileEntryArray[n2] = new FileEntry(c10, l2, string);
            ++n2;
        }
        return fileEntryArray;
    }

    protected void handleDrop(FileEntry[] fileEntryArray, Point point) {
    }

    public void removeAllRows() {
        int n2 = this.model.getRowCount();
        debug.println("ListPanel: rowCount = " + n2, 6);
        int n3 = n2 - 1;
        while (n3 >= 0) {
            debug.println("ListPanel: deleted row " + n3, 6);
            this.model.removeRow(n3);
            --n3;
        }
        this.buildPreviousDirectoryRow();
    }

    private void setColumnWidths() {
        TableColumn tableColumn = this.tableView.getColumn(" ");
        TableColumn tableColumn2 = this.tableView.getColumn(this.name);
        TableColumn tableColumn3 = this.tableView.getColumn(this.size);
        TableColumn tableColumn4 = this.tableView.getColumn(this.modified);
        tableColumn.setMinWidth(18);
        tableColumn.setMaxWidth(18);
        tableColumn2.setMinWidth(60);
        tableColumn3.setMinWidth(10);
        tableColumn4.setMinWidth(40);
        this.tableView.sizeColumnsToFit(0);
    }
}

