/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.data.Bookmark;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.BookmarkTableModel;
import edu.sdsc.secureftp.gui.EditBookmarkDialog;
import edu.sdsc.secureftp.gui.ErrorDialog;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class EditBookmarksPanel
extends JPanel {
    private JTable tableView;
    private JScrollPane scrollPane;
    private SecureFtpApplet parent;
    private BookmarkTableModel model;

    public EditBookmarksPanel(SecureFtpApplet secureFtpApplet) {
        this.parent = secureFtpApplet;
        this.setLayout(new BorderLayout());
        this.scrollPane = this.createTable();
        this.scrollPane.setBackground(Color.white);
        this.add((Component)this.scrollPane, "Center");
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    EditBookmarksPanel.this.editSelectedRow();
                }
            }
        };
        this.tableView.addMouseListener(mouseAdapter);
    }

    public void buildRow(String string, String string2, String string3) {
        Vector<String> vector = new Vector<String>();
        vector.addElement(string);
        vector.addElement(string2);
        vector.addElement(string3);
        this.model.addRow(vector);
        this.setColumnWidths();
    }

    protected void clearSelections() {
        this.tableView.removeRowSelectionInterval(0, this.tableView.getRowCount() - 1);
    }

    public JScrollPane createTable() {
        JScrollPane jScrollPane = new JScrollPane();
        this.model = new BookmarkTableModel();
        this.tableView = new JTable(this.model);
        this.tableView.setRowHeight(20);
        this.tableView.setRowSelectionAllowed(true);
        this.tableView.setColumnSelectionAllowed(false);
        this.tableView.setIntercellSpacing(new Dimension(0, 0));
        this.tableView.setShowHorizontalLines(true);
        this.tableView.setShowVerticalLines(false);
        this.tableView.setSelectionMode(0);
        this.model.addColumn(new LString("edit_bookmarks.bookmark.column", "Bookmark").getString());
        this.model.addColumn(new LString("edit_bookmarks.location.column", "Location").getString());
        this.model.addColumn(new LString("edit_bookmarks.username.column", "Username").getString());
        jScrollPane.getViewport().setBackground(Color.white);
        jScrollPane.getViewport().add(this.tableView);
        return jScrollPane;
    }

    public void editSelectedRow() {
        if (this.tableView.getSelectedRowCount() <= 0) {
            return;
        }
        int n2 = this.tableView.getSelectedRow();
        Bookmark bookmark = (Bookmark)this.parent.getBookmarks().elementAt(n2);
        new EditBookmarkDialog(this.parent, bookmark);
        String string = bookmark.getName();
        String string2 = bookmark.getHostname();
        String string3 = bookmark.getUsername();
        this.tableView.setValueAt(string, n2, 0);
        this.tableView.setValueAt(string2, n2, 1);
        this.tableView.setValueAt(string3, n2, 2);
        this.parent.getMenuBar().editBookmark(bookmark, n2);
        this.clearSelections();
    }

    protected int getRowCount() {
        return this.tableView.getRowCount();
    }

    public int getSelectedIndex() {
        return this.tableView.getSelectedRow();
    }

    public void moveRow(int n2, int n3) {
        if (n3 < 0) {
            return;
        }
        if (n3 >= this.tableView.getRowCount()) {
            return;
        }
        this.model.moveRow(n2, n2, n3);
        this.tableView.setRowSelectionInterval(n3, n3);
        Bookmark bookmark = (Bookmark)this.parent.getBookmarks().elementAt(n2);
        this.parent.getMenuBar().moveBookmark(bookmark, n2, n3);
        this.parent.getBookmarks().removeElementAt(n2);
        this.parent.getBookmarks().add(n3, bookmark);
        try {
            this.parent.getBookmarks().writeToDisk();
        }
        catch (IOException iOException) {
            new ErrorDialog(iOException.getMessage(), new LString("failed_to_write_bookmarks.msg", "Failed to write bookmarks").getString());
        }
    }

    public void removeAllRows() {
        int n2 = this.model.getRowCount();
        debug.println("ListPanel: rowCount = " + n2, 6);
        int n3 = n2 - 1;
        while (n3 >= 0) {
            debug.println("ListPanel: deleted row " + n3, 6);
            this.model.removeRow(n3);
            --n3;
        }
    }

    public void removeSelectedRow() {
        if (this.tableView.getSelectedRowCount() <= 0) {
            return;
        }
        int n2 = this.tableView.getSelectedRow();
        debug.println("selected row before delete = " + n2);
        debug.println("number of rows before delete = " + this.tableView.getRowCount());
        debug.println("number of vector items before delete = " + this.parent.getBookmarks().size());
        debug.println("number of menu items before delete = " + this.parent.getMenuBar().getBookmarkCount());
        int n3 = n2 + 3;
        debug.println("should delete menu item = " + n3 + "\n");
        this.model.removeRow(n2);
        this.parent.getMenuBar().removeBookmark(n2);
        this.parent.getBookmarks().removeElementAt(n2);
        try {
            this.parent.getBookmarks().writeToDisk();
        }
        catch (IOException iOException) {
            new ErrorDialog(iOException.getMessage(), new LString("failed_to_write_bookmarks.msg", "Failed to write bookmarks").getString());
        }
        this.clearSelections();
        debug.println("selected row after delete = " + this.tableView.getSelectedRow());
        debug.println("number of rows after delete = " + this.tableView.getRowCount());
        debug.println("number of menu items after delete = " + this.parent.getMenuBar().getBookmarkCount());
        debug.println("number of vector items after delete = " + this.parent.getBookmarks().size() + "\n");
    }

    private void setColumnWidths() {
        TableColumn tableColumn = this.tableView.getColumn(new LString("edit_bookmarks.bookmark.column", "Bookmark").getString());
        TableColumn tableColumn2 = this.tableView.getColumn(new LString("edit_bookmarks.location.column", "Location").getString());
        TableColumn tableColumn3 = this.tableView.getColumn(new LString("edit_bookmarks.username.column", "Username").getString());
        tableColumn.setMinWidth(60);
        tableColumn2.setMinWidth(60);
        tableColumn3.setMinWidth(40);
        this.tableView.sizeColumnsToFit(0);
    }
}

